/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.ckeditor.listener;

import com.fasterxml.jackson.dataformat.yaml.snakeyaml.util.UriEncoder;
import java.time.YearMonth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ecm.connector.platform.ManageDocumentService;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.social.core.activity.ActivityLifeCycleEvent;
import org.exoplatform.social.core.activity.ActivityListenerPlugin;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;

public class ActivityImageLinkUpdateListener
extends ActivityListenerPlugin {
    public static final String IP_REGEX = "(((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)";
    public static final String URL_OR_URI_REGEX = "^(((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?)?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$";
    private static final String PERSONAL_DOCUMENTS_DRIVE_NAME_PARAM = "personal.drive.name";
    private static final String PERSONAL_DOCUMENTS_DRIVE_NAME = "Personal Documents";
    private static final String SPACE_DOCUMENTS_FOLDER = "Activity Stream Documents/Pictures";
    private static final String PERSONAL_DOCUMENTS_FOLDER = "Public/Activity Stream Documents/Pictures";
    private static final String UPLOAD_ID_PARAMETER = "uploadId=";
    private static final Pattern UPLOAD_ID_PATTERN = Pattern.compile("uploadId=(([0-9]|[a-f]|[A-F])*)");
    private static final Pattern UPLOAD_URL_PATTERN = Pattern.compile("^(((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?((((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?)?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    private static final Log LOG = ExoLogger.getLogger(ActivityImageLinkUpdateListener.class);
    private final PortalContainer portalContainer;
    private final ActivityManager activityManager;
    private final IdentityManager identityManager;
    private final ManageDriveService driveService;
    private final UploadService uploadService;
    private final LinkManager linkManager;
    private final RepositoryService repositoryService;
    private final SpaceService spaceService;
    private ManageDocumentService documentService;
    private String personalDriveName = "Personal Documents";
    private String repositoryName;

    public ActivityImageLinkUpdateListener(PortalContainer portalContainer, RepositoryService repositoryService, UploadService uploadService, LinkManager linkManager, ActivityManager activityManager, IdentityManager identityManager, ManageDriveService driveService, SpaceService spaceService, InitParams params) {
        ValueParam personalDocumentsDriveName;
        this.activityManager = activityManager;
        this.identityManager = identityManager;
        this.driveService = driveService;
        this.uploadService = uploadService;
        this.linkManager = linkManager;
        this.repositoryService = repositoryService;
        this.portalContainer = portalContainer;
        this.spaceService = spaceService;
        if (params != null && (personalDocumentsDriveName = params.getValueParam(PERSONAL_DOCUMENTS_DRIVE_NAME_PARAM)) != null) {
            this.personalDriveName = personalDocumentsDriveName.getValue();
        }
    }

    public void saveActivity(ActivityLifeCycleEvent event) {
        try {
            this.updateImageLink(event);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while processing activity body for attached images", (Throwable)e);
        }
    }

    public void updateActivity(ActivityLifeCycleEvent event) {
        try {
            this.updateImageLink(event);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while processing activity body for attached images", (Throwable)e);
        }
    }

    public void saveComment(ActivityLifeCycleEvent event) {
        try {
            this.updateImageLink(event);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while processing activity body for attached images", (Throwable)e);
        }
    }

    public void likeActivity(ActivityLifeCycleEvent event) {
    }

    public void likeComment(ActivityLifeCycleEvent event) {
    }

    private void updateImageLink(ActivityLifeCycleEvent event) throws Exception {
        Map<String, String> urls;
        ExoSocialActivity activity = event.getActivity();
        String body = activity.getBody();
        String title = activity.getTitle();
        boolean storeActivity = false;
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)body) && body.contains(UPLOAD_ID_PARAMETER) && !(urls = this.getModifiedLink(activity, body)).isEmpty()) {
            urlToReplaces.putAll(urls);
            body = this.replaceUrl(body, urlToReplaces);
            activity.setBody(body);
            storeActivity = true;
        }
        if (StringUtils.isNotBlank((String)title) && title.contains(UPLOAD_ID_PARAMETER)) {
            urls = this.getModifiedLink(activity, title);
            urlToReplaces.putAll(urls);
            if (!urlToReplaces.isEmpty()) {
                title = this.replaceUrl(title, urlToReplaces);
                activity.setTitle(title);
                storeActivity = true;
            }
        }
        if (storeActivity) {
            this.activityManager.updateActivity(activity);
        }
    }

    private String replaceUrl(String body, Map<String, String> urlToReplaces) {
        for (String url : urlToReplaces.keySet()) {
            while (body.contains(url)) {
                body = body.replace(url, UriEncoder.encode((String)urlToReplaces.get(url)));
            }
        }
        return body;
    }

    private Map<String, String> getModifiedLink(ExoSocialActivity activity, String body) throws Exception, RepositoryException {
        HashSet<String> processedUploads = new HashSet<String>();
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        Matcher matcher = UPLOAD_ID_PATTERN.matcher(body);
        if (!matcher.find()) {
            return urlToReplaces;
        }
        String posterId = activity.getPosterId();
        String userName = this.identityManager.getIdentity(posterId, false).getRemoteId();
        YearMonth yearMonth = YearMonth.now();
        int year = yearMonth.getYear();
        int month = yearMonth.getMonthValue();
        String monthString = String.format("%02d", month);
        String currentFolder = null;
        DriveData selectedDriveData = null;
        if (activity.getActivityStream().getType() != null && "space".equals(activity.getActivityStream().getType().toString())) {
            currentFolder = "Activity Stream Documents/Pictures/" + year + "/" + monthString;
            String streamOwner = activity.getStreamOwner();
            Space space = this.spaceService.getSpaceByPrettyName(streamOwner);
            if (space == null) {
                LOG.warn("Can't find space with pretty name: {}. The uploaded files on activity {} will be ignored.", new Object[]{streamOwner, activity.getId()});
            }
            selectedDriveData = this.driveService.getDriveByName(space.getGroupId().replaceAll("/", "."));
        } else {
            currentFolder = "Public/Activity Stream Documents/Pictures/" + year + "/" + monthString;
            List personalDrives = this.driveService.getPersonalDrives(userName);
            if (personalDrives == null || personalDrives.isEmpty()) {
                LOG.warn("The user {} hasn't personal drives, thus the uploaded files will be deleted from teporary folder", new Object[]{userName});
                return urlToReplaces;
            }
            for (DriveData driveData : personalDrives) {
                if (!this.personalDriveName.equals(driveData.getName())) continue;
                selectedDriveData = driveData;
                break;
            }
            if (selectedDriveData == null) {
                selectedDriveData = (DriveData)personalDrives.get(0);
                LOG.warn("Cannot find configured personal drive with name {}, another drive will be used instead: {}", new Object[]{this.personalDriveName, selectedDriveData.getName()});
            }
        }
        String originalBody = body;
        do {
            UploadResource uploadedResource;
            String uploadId;
            if (processedUploads.contains(uploadId = matcher.group(matcher.groupCount() - 1)) || (uploadedResource = this.uploadService.getUploadResource(uploadId)) == null) continue;
            String fileName = uploadedResource.getFileName();
            Node parentForlderNode = this.getNode(selectedDriveData, currentFolder, userName);
            int i = 1;
            String originalfileName = fileName;
            while (parentForlderNode.hasNode(fileName)) {
                if (originalfileName.contains(".")) {
                    int indexOfPoint = originalfileName.indexOf(".");
                    fileName = originalfileName.substring(0, indexOfPoint) + "(" + i + ")" + originalfileName.substring(indexOfPoint);
                } else {
                    fileName = originalfileName + "(" + i + ")";
                }
                ++i;
            }
            fileName = Text.escapeIllegalJcrChars((String)fileName);
            fileName = Utils.cleanName((String)fileName);
            Response uploadResponse = this.getDocumentService().processUpload(selectedDriveData.getWorkspace(), selectedDriveData.getName(), currentFolder, null, "save", null, fileName, uploadId, "keepBoth");
            if (uploadResponse.getStatus() != 200) {
                LOG.warn("Error while uploading file with upload id: {}, name: {}, cause = {}", new Object[]{uploadId, fileName, uploadResponse.getEntity()});
                continue;
            }
            parentForlderNode = this.getNode(selectedDriveData, currentFolder, userName);
            fileName = Utils.cleanNameWithAccents((String)fileName);
            if (!parentForlderNode.hasNode(fileName = Utils.cleanName((String)fileName))) {
                LOG.warn("Cannot find attached file in JCR with upload id: {}, name: {}", new Object[]{uploadId, fileName});
                continue;
            }
            int uploadIdIndex = matcher.start();
            String urlToReplace = ActivityImageLinkUpdateListener.getURLToReplace(originalBody, uploadId, uploadIdIndex);
            if (!UPLOAD_URL_PATTERN.matcher(urlToReplace).matches()) {
                LOG.warn("Unrecognized URL to replace in activity body {}", new Object[]{urlToReplace});
                continue;
            }
            String fileURI = CommonsUtils.getCurrentDomain() + this.getJcrURI(parentForlderNode, fileName);
            if (!StringUtils.isNotBlank((String)urlToReplace)) continue;
            urlToReplaces.put(urlToReplace, fileURI);
            processedUploads.add(uploadId);
        } while (matcher.find());
        return urlToReplaces;
    }

    private String getJcrURI(Node parentForlderNode, String fileName) throws RepositoryException {
        Node fileNode = parentForlderNode.getNode(fileName);
        return "/" + this.portalContainer.getName() + "/" + this.portalContainer.getRestContextName() + "/jcr/" + this.getRepositoryName() + "/" + fileNode.getSession().getWorkspace().getName() + fileNode.getPath();
    }

    private static String getURLToReplace(String body, String uploadId, int uploadIdIndex) {
        int srcBeginIndex = body.lastIndexOf("\"", uploadIdIndex);
        int srcEndIndex = -1;
        if (srcBeginIndex < 0) {
            srcBeginIndex = body.lastIndexOf("'", uploadIdIndex);
            if (srcBeginIndex < 0) {
                LOG.warn((Object)("Cannot find src start delimiter in URL for uploadId " + uploadId + " ignore URL replacing"));
            } else {
                srcEndIndex = body.indexOf("'", srcBeginIndex + 1);
            }
        } else {
            srcEndIndex = body.indexOf("\"", srcBeginIndex + 1);
        }
        String urlToReplace = null;
        if (srcEndIndex < 0) {
            LOG.warn((Object)("Cannot find src end delimiter in URL for uploadId " + uploadId + " ignore URL replacing"));
        } else {
            urlToReplace = body.substring(srcBeginIndex + 1, srcEndIndex);
        }
        return urlToReplace;
    }

    private Node getNode(DriveData driveData, String currentFolder, String userId) throws Exception {
        String driveHomePath;
        Session session = this.getSession(driveData.getWorkspace());
        String drivePath = driveHomePath = driveData.getHomePath();
        if (driveData.getName().equals(this.personalDriveName)) {
            drivePath = Utils.getPersonalDrivePath((String)driveHomePath, (String)userId);
        }
        Node node = (Node)session.getItem(Text.escapeIllegalJcrChars((String)drivePath));
        if (StringUtils.isEmpty((String)currentFolder)) {
            return node;
        }
        for (String folder : currentFolder.split("/")) {
            if (StringUtils.isBlank((String)folder)) continue;
            if (node.hasNode(folder)) {
                if (!(node = node.getNode(folder)).isNodeType("exo:symlink")) continue;
                node = this.linkManager.getTarget(node);
                continue;
            }
            node = node.isNodeType("exo:symlink") ? this.linkManager.getTarget(node).getNode(folder) : node.addNode(folder);
        }
        session.save();
        return node;
    }

    private Session getSession(String workspaceName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getUserSessionProvider();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        return sessionProvider.getSession(workspaceName, manageableRepository);
    }

    public ManageDocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (ManageDocumentService)this.portalContainer.getComponentInstanceOfType(ManageDocumentService.class);
        }
        return this.documentService;
    }

    public String getRepositoryName() {
        if (this.repositoryName == null) {
            try {
                this.repositoryName = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            }
            catch (RepositoryException e) {
                this.repositoryName = this.repositoryService.getConfig().getDefaultRepositoryName();
            }
        }
        return this.repositoryName;
    }
}

