/*
 * Copyright (C) 2003-2010 eXo Platform SAS.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Affero General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see<http://www.gnu.org/licenses/>.
 */
package org.exoplatform.forum.ext.impl;

import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.faq.service.Category;
import org.exoplatform.faq.service.FAQService;
import org.exoplatform.faq.service.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.impl.SpaceServiceImpl;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

/**
 * Created by The eXo Platform SAS
 * Author : eXoPlatform
 *          exo@exoplatform.com
 * Jul 7, 2010  
 */
public class AnswerDataInitialize extends SpaceListenerPlugin {

  private static final Log LOG = ExoLogger.getLogger(AnswerDataInitialize.class);

  private final InitParams params;
  

  public AnswerDataInitialize(InitParams params) {
    this.params = params;
  }
  
  @Override
  public void applicationActivated(SpaceLifeCycleEvent event) {

  }

  @Override
  public void applicationAdded(SpaceLifeCycleEvent event) {
    String portletName = "";
    if (params.getValueParam("portletName") != null)
      portletName = params.getValueParam("portletName").getValue();
    else if (LOG.isDebugEnabled()) {
      LOG.debug("Initparam is not configured for portletName property");
    }

    if (!portletName.equals(event.getSource())) {
      /*
       * this function is called only if Answers Portlet is added to Social Space.
       * Hence, if the application added to space do not have the name as configured, we will be out now.
       */
      return;
    }
    
    Space space = event.getSpace();
    FAQService fServie = (FAQService) PortalContainer.getInstance().getComponentInstanceOfType(FAQService.class);
    try {
      Category parent = fServie.getCategoryById(Utils.CATEGORY_HOME);
      if (parent != null) {
        Category cat = new Category();
        cat.setId(Utils.CATE_SPACE_ID_PREFIX + space.getPrettyName());
        cat.setName(space.getDisplayName());
        cat.setUserPrivate(new String[] { space.getGroupId() });
        cat.setDescription(space.getDescription());
        cat.setIndex(1);
        // TODO hard text manager should check with portal team
        cat.setModerators(new String[] { SpaceServiceImpl.MANAGER + ":" + space.getGroupId() });
        if (fServie.getCategoryById(cat.getId()) == null) {
          fServie.saveCategory(Utils.CATEGORY_HOME, cat, true);
        }
      } else {
        LOG.error("\n\n Root category null please check to create one !");
      }
    } catch (Exception e) { //FAQException
      LOG.error("\n\n Initialize category false " + e.getMessage());
    }
  }

  @Override
  public void applicationDeactivated(SpaceLifeCycleEvent event) {
  }

  @Override
  public void applicationRemoved(SpaceLifeCycleEvent event) {

  }

  @Override
  public void grantedLead(SpaceLifeCycleEvent event) {

  }

  @Override
  public void joined(SpaceLifeCycleEvent event) {

  }

  @Override
  public void left(SpaceLifeCycleEvent event) {

  }

  @Override
  public void revokedLead(SpaceLifeCycleEvent event) {

  }

  @Override
  public void spaceCreated(SpaceLifeCycleEvent event) {

  }

  @Override
  public void spaceRemoved(SpaceLifeCycleEvent event) {

  }

  @Override
  public void spaceRenamed(SpaceLifeCycleEvent event) {}

  @Override
  public void spaceDescriptionEdited(SpaceLifeCycleEvent event) {}

  @Override
  public void spaceAvatarEdited(SpaceLifeCycleEvent event) {}

  @Override
  public void spaceAccessEdited(SpaceLifeCycleEvent event) {    
  }

}
