/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.backupconsole;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import javax.ws.rs.core.Response;
import org.exoplatform.jcr.backupconsole.BackupAgentResponse;
import org.exoplatform.jcr.backupconsole.BackupClient;
import org.exoplatform.jcr.backupconsole.BackupExecuteException;
import org.exoplatform.jcr.backupconsole.ClientTransport;
import org.exoplatform.services.jcr.ext.backup.server.bean.BackupConfigBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.RestoreBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.BackupServiceInfoBean;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.DetailedInfo;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.ShortInfo;
import org.exoplatform.services.jcr.ext.backup.server.bean.response.ShortInfoList;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class BackupClientImpl
implements BackupClient {
    private static final int BLOCK_SIZE = 1024;
    private ClientTransport transport;
    private final String userName;
    private final String pass;

    public BackupClientImpl(ClientTransport transport, String login, String pass) {
        this.transport = transport;
        this.userName = login;
        this.pass = pass;
    }

    public String startBackUp(String repositoryName, String workspaceName, String backupDir) throws IOException, BackupExecuteException {
        JsonValue json;
        String sURL = "/rest/jcr-backup/start/" + repositoryName + "/" + workspaceName;
        BackupConfigBean bean = new BackupConfigBean(Integer.valueOf(0), backupDir);
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        try {
            json = generatorImpl.createJsonObject((Object)bean);
        }
        catch (JsonException e) {
            throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
        }
        BackupAgentResponse response = this.transport.executePOST(sURL, json.toString());
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    public String startIncrementalBackUp(String repositoryName, String workspaceName, String backupDir, long incr) throws IOException, BackupExecuteException {
        JsonValue json;
        String sURL = "/rest/jcr-backup/start/" + repositoryName + "/" + workspaceName;
        BackupConfigBean bean = new BackupConfigBean(Integer.valueOf(1), backupDir, Long.valueOf(incr));
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        try {
            json = generatorImpl.createJsonObject((Object)bean);
        }
        catch (JsonException e) {
            throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
        }
        BackupAgentResponse response = this.transport.executePOST(sURL, json.toString());
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    public String status(String backupId) throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/info/backup/" + backupId;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            DetailedInfo info;
            try {
                info = (DetailedInfo)this.getObject(DetailedInfo.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get DetailedInfo from responce.", e);
            }
            if (info.getType() == 0) {
                String result = "\nThe completed (ready to restore) backup information : \n";
                BackupConfigBean configBean = info.getBackupConfig();
                result = result + "\t\tbackup id               : " + info.getBackupId() + "\n" + "\t\tbackup folder           : " + configBean.getBackupDir() + "\n" + "\t\trepository name         : " + info.getRepositoryName() + "\n" + "\t\tworkspace name          : " + info.getWorkspaceName() + "\n" + "\t\tbackup type             : " + (configBean.getBackupType() == 1 ? "full + incremetal" : "full only") + "\n" + "\t\tstarted time            : " + info.getStartedTime() + "\n" + (info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time           : " + info.getFinishedTime() + "\n\n");
                return result;
            }
            String result = "\nThe current backup information : \n";
            BackupConfigBean configBean = info.getBackupConfig();
            result = result + "\t\tbackup id                : " + info.getBackupId() + "\n" + "\t\tbackup folder            : " + configBean.getBackupDir() + "\n" + "\t\trepository name          : " + info.getRepositoryName() + "\n" + "\t\tworkspace name           : " + info.getWorkspaceName() + "\n" + "\t\tbackup type              : " + (configBean.getBackupType() == 1 ? "full + incremetal" : "full only") + "\n" + "\t\tfull backup state        : " + this.getState(info.getState()) + "\n" + (info.getBackupType() == 0 ? "" : "\t\tincremental backup state : working\n") + "\t\tstarted time             : " + info.getStartedTime() + "\n" + (info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time            : " + info.getFinishedTime() + "\n\n");
            return result;
        }
        return this.failureProcessing(response);
    }

    public String stop(String backupId) throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/stop/" + backupId;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    public String restore(String repositoryName, String workspaceName, String backupId, InputStream config) throws IOException, BackupExecuteException {
        JsonValue json;
        String sURL = "/rest/jcr-backup/restore/" + repositoryName + "/" + workspaceName;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] b = new byte[1024];
        int len = 0;
        while ((len = config.read(b)) != -1) {
            bout.write(b, 0, len);
        }
        config.close();
        byte[] cb = bout.toByteArray();
        bout.close();
        RestoreBean bean = new RestoreBean(backupId, new String(cb, "UTF-8"));
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        try {
            json = generatorImpl.createJsonObject((Object)bean);
        }
        catch (JsonException e) {
            throw new BackupExecuteException("Can not get json from  : " + bean.getClass().toString(), e);
        }
        BackupAgentResponse response = this.transport.executePOST(sURL, json.toString());
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    public String drop(boolean forceClose, String repositoryName, String workspaceName) throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/drop-workspace/" + repositoryName + "/" + workspaceName + "/" + forceClose;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return "\nSuccessful : \n\tstatus code = " + response.getStatus() + "\n";
        }
        return this.failureProcessing(response);
    }

    public String info() throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/info";
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            BackupServiceInfoBean info;
            try {
                info = (BackupServiceInfoBean)this.getObject(BackupServiceInfoBean.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get BackupServiceInfoBean from responce.", e);
            }
            String result = "\nThe backup service information : \n\tfull backup type               : " + info.getFullBackupType() + "\n" + "\tincremetal backup type         : " + info.getIncrementalBackupType() + "\n" + "\tbackup log folder              : " + info.getBackupLogDir() + "\n" + "\tdefault incremental job period : " + info.getDefaultIncrementalJobPeriod() + "\n\n";
            return result;
        }
        return this.failureProcessing(response);
    }

    public String list() throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/info/backup/current";
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            ShortInfoList infoList;
            try {
                infoList = (ShortInfoList)this.getObject(ShortInfoList.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get ShortInfoList from responce.", e);
            }
            String result = "\nThe current backups information : \n";
            if (infoList.getBackups().size() == 0) {
                result = result + "\tNo active backups.\n\n";
            }
            int count = 1;
            for (ShortInfo shortInfo : infoList.getBackups()) {
                result = result + "\t" + count + ") Backup with id " + shortInfo.getBackupId() + " :\n";
                result = result + "\t\trepository name           : " + shortInfo.getRepositoryName() + "\n" + "\t\tworkspace name            : " + shortInfo.getWorkspaceName() + "\n" + "\t\tbackup type               : " + (shortInfo.getBackupType() == 1 ? "full + incremetal" : "full only") + "\n" + "\t\tfull backup state         : " + this.getState(shortInfo.getState()) + "\n" + (shortInfo.getBackupType() == 0 ? "" : "\t\tincremental backup state  : working\n") + "\t\tstarted time              : " + shortInfo.getStartedTime() + "\n" + (shortInfo.getFinishedTime().equals("") ? "" : "\t\tfinished time             : " + shortInfo.getFinishedTime() + "\n");
                ++count;
            }
            return result;
        }
        return this.failureProcessing(response);
    }

    public String listCompleted() throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/info/backup/completed";
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            ShortInfoList infoList;
            try {
                infoList = (ShortInfoList)this.getObject(ShortInfoList.class, response.getResponseData());
                new String(response.getResponseData());
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("Can not get ShortInfoList from responce.", e);
            }
            String result = "\nThe completed (ready to restore) backups information : \n";
            if (infoList.getBackups().size() == 0) {
                result = result + "\tNo completed backups.\n\n";
            }
            int count = 1;
            for (ShortInfo shortInfo : infoList.getBackups()) {
                result = result + "\t" + count + ") Backup with id " + shortInfo.getBackupId() + " :\n";
                result = result + "\t\trepository name           : " + shortInfo.getRepositoryName() + "\n" + "\t\tworkspace name            : " + shortInfo.getWorkspaceName() + "\n" + "\t\tbackup type               : " + (shortInfo.getBackupType() == 1 ? "full + incremetal" : "full only") + "\n" + "\t\tstarted time              : " + shortInfo.getStartedTime() + "\n" + (shortInfo.getFinishedTime().equals("") ? "\n" : "\t\tfinished time             : " + shortInfo.getFinishedTime() + "\n");
                ++count;
            }
            return result;
        }
        return this.failureProcessing(response);
    }

    public String restores(String repositoryName, String workspaceName) throws IOException, BackupExecuteException {
        String sURL = "/rest/jcr-backup/info/restore/" + repositoryName + "/" + workspaceName;
        BackupAgentResponse response = this.transport.executeGET(sURL);
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            DetailedInfo info;
            try {
                info = (DetailedInfo)this.getObject(DetailedInfo.class, response.getResponseData());
            }
            catch (Exception e) {
                throw new RuntimeException("Can not get DetailedInfo from responce.", e);
            }
            String result = "\nThe current restores information : \n";
            result = result + "\tRestore with id " + info.getBackupId() + ":\n";
            BackupConfigBean configBean = info.getBackupConfig();
            result = result + "\t\tbackup folder           : " + configBean.getBackupDir() + "\n" + "\t\trepository name         : " + info.getRepositoryName() + "\n" + "\t\tworkspace name          : " + info.getWorkspaceName() + "\n" + "\t\tbackup type             : " + (configBean.getBackupType() == 1 ? "full + incremetal" : "full only") + "\n" + "\t\trestore state           : " + this.getRestoreState(info.getState()) + "\n" + "\t\tstarted time            : " + info.getStartedTime() + "\n" + (info.getFinishedTime().equals("") ? "\n" : "\t\tfinished time           : " + info.getFinishedTime() + "\n\n");
            return result;
        }
        return this.failureProcessing(response);
    }

    private Object getObject(Class cl, byte[] data) throws Exception {
        JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
        JsonParserImpl jsonParser = new JsonParserImpl();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
        jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
        JsonValue jsonValue = jsonHandler.getJsonObject();
        return new BeanBuilder().createObject(cl, jsonValue);
    }

    private String getRestoreState(int restoreState) {
        String state = "unknown sate of restore";
        switch (restoreState) {
            case 4: {
                state = "initialized";
                break;
            }
            case 1: {
                state = "started";
                break;
            }
            case 2: {
                state = "successful";
                break;
            }
            case 3: {
                state = "fail";
                break;
            }
        }
        return state;
    }

    private String getState(int state) {
        String st = "";
        switch (state) {
            case 4: {
                st = "finished";
                break;
            }
            case 2: {
                st = "working";
                break;
            }
            case 1: {
                st = "waiting";
                break;
            }
            case 0: {
                st = "starting";
                break;
            }
        }
        return st;
    }

    private String failureProcessing(BackupAgentResponse response) throws BackupExecuteException {
        try {
            String result = "\nFailure :\n\tsatatus code : " + response.getStatus() + "\n" + "\tmessage      : " + new String(response.getResponseData(), "UTF-8") + "\n\n";
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new BackupExecuteException("Can not encoded the responce : " + e.getMessage(), e);
        }
    }
}

