/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.backupconsole;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.exoplatform.jcr.backupconsole.BackupClientImpl;
import org.exoplatform.jcr.backupconsole.BackupExecuteException;
import org.exoplatform.jcr.backupconsole.ClientTransportImpl;

public class BackupConsole {
    private static final String INCORRECT_PARAM = "Incorrect parameter: ";
    private static final String TOO_MANY_PARAMS = "Too many parameters.";
    private static final String LOGIN_PASS_SPLITTER = ":";
    private static final String FORCE_CLOSE = "force-close-session";
    private static final String HELP_INFO = "Help info:\n <url> <cmd> \n <url>  :   http(s)//login:password@host:port/<context> \n <cmd>  :   start <repo/ws> <backup_dir> [<incr>] \n            stop <backup_id> \n            status <backup_id> \n            restores <repo/ws> \n            restore <repo/ws> <backup_id> <pathToConfigFile> \n            list [completed] \n            info \n            drop [force-close-session] <repo/ws>  \n            help  \n\n start          - start backup \n stop           - stop backup \n status         - information about the current or completed backup by 'backup_id' \n restores       - information about the last restore on specific workspace \n restore        - restore the workspace from specific backup \n list           - information about the current backups (in progress) \n list completed - information about the completed (ready to restore) backups \n info           - information about the service backup \n drop           - delete the workspace \n help           - print help information about backup console \n\n <repo/ws>           - /<reponsitory-name>/<workspace-name>  the workspace \n <backup_dir>        - path to folder for backup on remote server \n <backup_id>         - the identifier for backup \n <incr>              - incemental job period \n <pathToConfigFile>  - path (local) to workspace configuration \n force-close-session - close opened sessions on workspace. \n\n";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) {
        URL url;
        int curArg = 0;
        if (curArg == args.length) {
            System.out.println("Incorrect parameter: There is no any parameters.");
            return;
        }
        if (args[curArg].equalsIgnoreCase("help")) {
            System.out.println(HELP_INFO);
            return;
        }
        String sUrl = args[curArg];
        ++curArg;
        try {
            url = new URL(sUrl);
        }
        catch (MalformedURLException e) {
            System.out.println("Incorrect parameter: There is no url parameter.");
            return;
        }
        String login = url.getUserInfo();
        if (login == null) {
            System.out.println("Incorrect parameter: There is no specific Login:Password in url parameter - " + sUrl);
            return;
        }
        if (!login.matches("[^:]+:[^:]+")) {
            System.out.println("Incorrect parameter: There is incorrect Login:Password parameter - " + login);
            return;
        }
        String host = url.getHost() + LOGIN_PASS_SPLITTER + url.getPort();
        String[] lp = login.split(LOGIN_PASS_SPLITTER);
        ClientTransportImpl transport = new ClientTransportImpl(lp[0], lp[1], host, url.getProtocol());
        BackupClientImpl client = new BackupClientImpl(transport, lp[0], lp[1]);
        if (curArg == args.length) {
            System.out.println("Incorrect parameter: There is no command parameter.");
            return;
        }
        String command = args[curArg++];
        try {
            String pathToConf;
            File conf;
            String pathToWS;
            if (command.equalsIgnoreCase("start")) {
                String pathToWS2;
                if ((pathToWS2 = BackupConsole.getRepoWS(args, curArg++)) == null) {
                    return;
                }
                String repositoryName = BackupConsole.getRepositoryName(pathToWS2);
                String workspaceName = BackupConsole.getWorkspaceName(pathToWS2);
                if (curArg == args.length) {
                    System.out.println("Incorrect parameter: There is no path to backup dir parameter.");
                    return;
                }
                String backupDir = args[curArg++];
                if (curArg == args.length) {
                    System.out.println(client.startBackUp(repositoryName, workspaceName, backupDir));
                    return;
                }
                String incr = args[curArg++];
                long inc = 0L;
                try {
                    inc = Long.parseLong(incr);
                }
                catch (NumberFormatException e) {
                    System.out.println("Incorrect parameter: Incemental job period is not didgit - " + e.getMessage());
                    return;
                }
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.startIncrementalBackUp(repositoryName, workspaceName, backupDir, inc));
                return;
            }
            if (command.equalsIgnoreCase("stop")) {
                if (curArg == args.length) {
                    System.out.println("Incorrect parameter: There is no backup identifier parameter.");
                    return;
                }
                String backupId = args[curArg++];
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.stop(backupId));
                return;
            }
            if (command.equalsIgnoreCase("drop")) {
                if (curArg == args.length) {
                    System.out.println("Incorrect parameter: There is no path to workspace or force-session-close parameter.");
                    return;
                }
                String param = args[curArg++];
                boolean isForce = true;
                if (!param.equalsIgnoreCase(FORCE_CLOSE)) {
                    isForce = false;
                }
                int n = --curArg;
                ++curArg;
                String pathToWS3 = BackupConsole.getRepoWS(args, n);
                if (pathToWS3 == null) {
                    return;
                }
                String repositoryName = BackupConsole.getRepositoryName(pathToWS3);
                String workspaceName = BackupConsole.getWorkspaceName(pathToWS3);
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.drop(isForce, repositoryName, workspaceName));
                return;
            }
            if (command.equalsIgnoreCase("status")) {
                if (curArg == args.length) {
                    System.out.println("Incorrect parameter: There is no backup identifier parameter.");
                    return;
                }
                String backupId = args[curArg++];
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.status(backupId));
                return;
            }
            if (command.equalsIgnoreCase("info")) {
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.info());
                return;
            }
            if (command.equalsIgnoreCase("restores")) {
                String pathToWS4;
                if ((pathToWS4 = BackupConsole.getRepoWS(args, curArg++)) == null) {
                    return;
                }
                String repositoryName = BackupConsole.getRepositoryName(pathToWS4);
                String workspaceName = BackupConsole.getWorkspaceName(pathToWS4);
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.restores(repositoryName, workspaceName));
                return;
            }
            if (command.equalsIgnoreCase("list")) {
                String complated;
                if (curArg == args.length) {
                    System.out.println(client.list());
                    return;
                }
                if (!(complated = args[curArg++]).equalsIgnoreCase("completed")) {
                    System.out.println("Incorrect parameter: There is no 'completed' parameter - " + complated);
                    return;
                }
                if (curArg < args.length) {
                    System.out.println(TOO_MANY_PARAMS);
                    return;
                }
                System.out.println(client.listCompleted());
                return;
            }
            if (!command.equalsIgnoreCase("restore")) {
                System.out.println("Unknown command <" + command + ">");
                return;
            }
            if ((pathToWS = BackupConsole.getRepoWS(args, curArg++)) == null) {
                return;
            }
            String repositoryName = BackupConsole.getRepositoryName(pathToWS);
            String workspaceName = BackupConsole.getWorkspaceName(pathToWS);
            if (curArg == args.length) {
                System.out.println("Incorrect parameter: There is no backup identifier parameter.");
                return;
            }
            String backupId = args[curArg++];
            if (curArg == args.length) {
                System.out.println("Incorrect parameter: There is no path to config file parameter.");
                return;
            }
            if (!(conf = new File(pathToConf = args[curArg++])).exists()) {
                System.out.println(" File " + pathToConf + " do not exist. Check the path.");
                return;
            }
            if (curArg < args.length) {
                System.out.println(TOO_MANY_PARAMS);
                return;
            }
            System.out.println(client.restore(repositoryName, workspaceName, backupId, new FileInputStream(conf)));
            return;
        }
        catch (IOException e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        catch (BackupExecuteException e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static String getWorkspaceName(String pathToWS) {
        return pathToWS.split("/")[2];
    }

    private static String getRepositoryName(String pathToWS) {
        return pathToWS.split("/")[1];
    }

    private static String getRepoWS(String[] args, int curArg) {
        if (curArg == args.length) {
            System.out.println("Incorrect parameter: There is no path to workspace parameter.");
            return null;
        }
        String repWS = args[curArg];
        if (!(repWS = repWS.replaceAll("\\\\", "/")).matches("[/][^/]+[/][^/]+")) {
            System.out.println("Incorrect parameter: There is incorrect path to workspace parameter: " + repWS);
            return null;
        }
        return repWS;
    }
}

