/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.backupconsole;

import java.io.IOException;
import java.net.URL;
import javax.ws.rs.core.Response;
import org.exoplatform.common.http.client.AuthorizationHandler;
import org.exoplatform.common.http.client.AuthorizationInfo;
import org.exoplatform.common.http.client.CookieModule;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.ModuleException;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.jcr.backupconsole.BackupAgentResponse;
import org.exoplatform.jcr.backupconsole.BackupExecuteException;
import org.exoplatform.jcr.backupconsole.ClientTransport;
import org.exoplatform.jcr.backupconsole.FormAuthentication;

public class ClientTransportImpl
implements ClientTransport {
    private final String host;
    private final String login;
    private final String password;
    private final String protocol;
    private String realm = null;
    private FormAuthentication formAuthentication;

    public ClientTransportImpl(String login, String password, String host, String protocol) {
        this.host = host;
        this.login = login;
        this.password = password;
        this.protocol = protocol;
    }

    public ClientTransportImpl(FormAuthentication formAuthentication, String host, String protocol) {
        this(null, null, host, protocol);
        this.formAuthentication = formAuthentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRealm(String sUrl) throws IOException, ModuleException {
        AuthorizationHandler ah = AuthorizationInfo.getAuthHandler();
        try {
            URL url = new URL(sUrl);
            HTTPConnection connection = new HTTPConnection(url);
            connection.removeModule(CookieModule.class);
            AuthorizationInfo.setAuthHandler(null);
            HTTPResponse resp = connection.Get(url.getFile());
            String authHeader = resp.getHeader("WWW-Authenticate");
            if (authHeader == null) {
                String string = null;
                return string;
            }
            String realm = authHeader.split("=")[1];
            String string = realm = realm.substring(1, realm.length() - 1);
            return string;
        }
        finally {
            AuthorizationInfo.setAuthHandler((AuthorizationHandler)ah);
        }
    }

    @Override
    public BackupAgentResponse executePOST(String sURL, String postData) throws IOException, BackupExecuteException {
        try {
            HTTPResponse resp;
            String complURL = this.protocol + "://" + this.host + sURL;
            URL url = new URL(complURL);
            HTTPConnection connection = new HTTPConnection(url);
            connection.setAllowUserInteraction(false);
            if (this.formAuthentication != null) {
                URL urlLogin = new URL(this.protocol + "://" + this.host + this.formAuthentication.getFormPath());
                HTTPConnection connectionLogin = new HTTPConnection(urlLogin);
                connectionLogin.setAllowUserInteraction(false);
                NVPair[] formParams = new NVPair[this.formAuthentication.getFormParams().size()];
                int pairCount = 0;
                for (String key : this.formAuthentication.getFormParams().keySet()) {
                    formParams[pairCount++] = new NVPair(key, this.formAuthentication.getFormParams().get(key));
                }
                HTTPResponse respLogin = "POST".equalsIgnoreCase(this.formAuthentication.getMethod()) ? connectionLogin.Post(urlLogin.getFile(), formParams) : connectionLogin.Get(urlLogin.getFile(), formParams);
                if (Response.Status.OK.getStatusCode() != respLogin.getStatusCode()) {
                    System.out.println("Form authentication is fail, status code : " + respLogin.getStatusCode());
                    System.exit(0);
                }
            } else {
                if (this.realm == null) {
                    this.realm = this.getRealm(complURL);
                    if (this.realm == null) {
                        throw new BackupExecuteException("Can not connect to server using basic authentication. Try to use form authentication.");
                    }
                }
                connection.addBasicAuthorization(this.realm, this.login, this.password);
            }
            if (postData == null) {
                resp = connection.Post(url.getFile());
            } else {
                NVPair[] pairs = new NVPair[]{new NVPair("Content-Type", "application/json; charset=UTF-8"), new NVPair("Content-Length", Integer.toString(postData.length()))};
                resp = connection.Post(url.getFile(), postData.getBytes(), pairs);
            }
            BackupAgentResponse responce = new BackupAgentResponse(resp.getData(), resp.getStatusCode());
            return responce;
        }
        catch (ModuleException e) {
            throw new BackupExecuteException(e.getMessage(), e);
        }
    }

    @Override
    public BackupAgentResponse executeGET(String sURL) throws IOException, BackupExecuteException {
        try {
            String complURL = this.protocol + "://" + this.host + sURL;
            URL url = new URL(complURL);
            HTTPConnection connection = new HTTPConnection(url);
            connection.setAllowUserInteraction(false);
            if (this.formAuthentication != null) {
                URL urlLogin = new URL(this.protocol + "://" + this.host + this.formAuthentication.getFormPath());
                HTTPConnection connectionLogin = new HTTPConnection(urlLogin);
                connectionLogin.setAllowUserInteraction(false);
                NVPair[] formParams = new NVPair[this.formAuthentication.getFormParams().size()];
                int pairCount = 0;
                for (String key : this.formAuthentication.getFormParams().keySet()) {
                    formParams[pairCount++] = new NVPair(key, this.formAuthentication.getFormParams().get(key));
                }
                HTTPResponse respLogin = "POST".equalsIgnoreCase(this.formAuthentication.getMethod()) ? connectionLogin.Post(urlLogin.getFile(), formParams) : connectionLogin.Get(urlLogin.getFile(), formParams);
                if (Response.Status.OK.getStatusCode() != respLogin.getStatusCode()) {
                    System.out.println("Form authentication is fail, status code : " + respLogin.getStatusCode());
                    System.exit(0);
                }
            } else {
                if (this.realm == null) {
                    this.realm = this.getRealm(complURL);
                    if (this.realm == null) {
                        throw new BackupExecuteException("Can not connect to server using basic authentication. Try to use form authentication.");
                    }
                }
                connection.addBasicAuthorization(this.realm, this.login, this.password);
            }
            HTTPResponse resp = connection.Get(url.getFile());
            BackupAgentResponse responce = new BackupAgentResponse(resp.getData(), resp.getStatusCode());
            return responce;
        }
        catch (ModuleException e) {
            throw new BackupExecuteException(e.getMessage(), e);
        }
    }
}

