/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Element
implements Serializable,
Cloneable {
    static final long serialVersionUID = -7401070179721710743L;
    private static final Log LOG = LogFactory.getLog((class$net$sf$ehcache$Element == null ? (class$net$sf$ehcache$Element = Element.class$("net.sf.ehcache.Element")) : class$net$sf$ehcache$Element).getName());
    private final Serializable key;
    private Serializable value;
    private long version;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    private long hitCount;
    static /* synthetic */ Class class$net$sf$ehcache$Element;

    public Element(Serializable key, Serializable value, long version) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.creationTime = System.currentTimeMillis();
        this.hitCount = 0L;
    }

    public Element(Serializable key, Serializable value) {
        this(key, value, 1L);
    }

    public Serializable getKey() {
        return this.key;
    }

    public Serializable getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public void setCreateTime() {
        this.creationTime = System.currentTimeMillis();
    }

    public long getVersion() {
        return this.version;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    long getNextToLastAccessTime() {
        return this.nextToLastAccessTime;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ key = ").append(this.key).append(", value=").append(this.value).append(", version=").append(this.version).append(", hitCount=").append(this.hitCount).append(", CreationTime = ").append(this.getCreationTime()).append(", LastAccessTime = ").append(this.getLastAccessTime()).append(" ]");
        return sb.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        Element element = new Element(this.deepCopy(this.key), this.deepCopy(this.value), this.version);
        element.creationTime = this.creationTime;
        element.lastAccessTime = this.lastAccessTime;
        element.nextToLastAccessTime = this.nextToLastAccessTime;
        element.hitCount = this.hitCount;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Serializable deepCopy(Serializable oldValue) {
        Serializable newValue;
        block10: {
            newValue = null;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oos = null;
            ObjectInputStream ois = null;
            oos = new ObjectOutputStream(bout);
            oos.writeObject(oldValue);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ois = new ObjectInputStream(bin);
            newValue = (Serializable)ois.readObject();
            Object var8_9 = null;
            try {
                oos.close();
                ois.close();
            }
            catch (IOException e2) {
                LOG.error("Error closing Stream");
            }
            break block10;
            {
                catch (IOException e) {
                    LOG.error("Error cloning Element with key " + this.key + " during serialization and deserialization of value");
                    Object var8_10 = null;
                    try {
                        oos.close();
                        ois.close();
                    }
                    catch (IOException e2) {
                        LOG.error("Error closing Stream");
                    }
                    break block10;
                }
                catch (ClassNotFoundException e) {
                    LOG.error("Error cloning Element with key " + this.key + " during serialization and deserialization of value");
                    Object var8_11 = null;
                    try {
                        oos.close();
                        ois.close();
                    }
                    catch (IOException e2) {
                        LOG.error("Error closing Stream");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    oos.close();
                    ois.close();
                }
                catch (IOException e2) {
                    LOG.error("Error closing Stream");
                }
                throw throwable;
            }
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSerializedSize() {
        long size = 0L;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(this);
            long l = size = (long)bout.size();
            return l;
        }
        catch (IOException e) {
            LOG.error("Error measuring element size for element with key " + this.key);
        }
        finally {
            try {
                oos.close();
            }
            catch (IOException e) {
                LOG.error("Error closing ObjectOutputStream");
            }
        }
        return size;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

