/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.poi.hslf.record.RecordAtom;
import org.apache.poi.util.StringUtil;

public class DocumentEncryptionAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private static long _type = 12052L;
    private byte[] data;
    private String encryptionProviderName;

    protected DocumentEncryptionAtom(byte[] source, int start, int len) {
        int pos;
        System.arraycopy(source, start, this._header, 0, 8);
        this.data = new byte[len - 8];
        System.arraycopy(source, start + 8, this.data, 0, len - 8);
        int endPos = -1;
        for (pos = start + 8 + 44; pos < start + len && endPos < 0; pos += 2) {
            if (source[pos] != 0 || source[pos + 1] != 0) continue;
            endPos = pos;
        }
        pos = start + 8 + 44;
        int stringLen = (endPos - pos) / 2;
        this.encryptionProviderName = StringUtil.getFromUnicodeLE(source, pos, stringLen);
    }

    public int getKeyLength() {
        return this.data[28];
    }

    public String getEncryptionProviderName() {
        return this.encryptionProviderName;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this.data);
    }
}

