/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSEnvelopedDataStreamGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMEGenerator;
import org.bouncycastle.mail.smime.SMIMEStreamingProcessor;

public class SMIMEEnvelopedGenerator
extends SMIMEGenerator {
    public static final String DES_EDE3_CBC = CMSEnvelopedDataGenerator.DES_EDE3_CBC;
    public static final String RC2_CBC = CMSEnvelopedDataGenerator.RC2_CBC;
    public static final String IDEA_CBC = "1.3.6.1.4.1.188.7.1.1.2";
    public static final String CAST5_CBC = "1.2.840.113533.7.66.10";
    public static final String AES128_CBC = CMSEnvelopedDataGenerator.AES128_CBC;
    public static final String AES192_CBC = CMSEnvelopedDataGenerator.AES192_CBC;
    public static final String AES256_CBC = CMSEnvelopedDataGenerator.AES256_CBC;
    public static final String CAMELLIA128_CBC = CMSEnvelopedDataGenerator.CAMELLIA128_CBC;
    public static final String CAMELLIA192_CBC = CMSEnvelopedDataGenerator.CAMELLIA192_CBC;
    public static final String CAMELLIA256_CBC = CMSEnvelopedDataGenerator.CAMELLIA256_CBC;
    public static final String SEED_CBC = CMSEnvelopedDataGenerator.SEED_CBC;
    public static final String DES_EDE3_WRAP = CMSEnvelopedDataGenerator.DES_EDE3_WRAP;
    public static final String AES128_WRAP = CMSEnvelopedDataGenerator.AES128_WRAP;
    public static final String AES256_WRAP = CMSEnvelopedDataGenerator.AES256_WRAP;
    public static final String CAMELLIA128_WRAP = CMSEnvelopedDataGenerator.CAMELLIA128_WRAP;
    public static final String CAMELLIA192_WRAP = CMSEnvelopedDataGenerator.CAMELLIA192_WRAP;
    public static final String CAMELLIA256_WRAP = CMSEnvelopedDataGenerator.CAMELLIA256_WRAP;
    public static final String SEED_WRAP = CMSEnvelopedDataGenerator.SEED_WRAP;
    public static final String ECDH_SHA1KDF = CMSEnvelopedDataGenerator.ECDH_SHA1KDF;
    private static final String ENCRYPTED_CONTENT_TYPE = "application/pkcs7-mime; name=\"smime.p7m\"; smime-type=enveloped-data";
    private EnvelopedGenerator fact = new EnvelopedGenerator();

    public void addKeyTransRecipient(X509Certificate x509Certificate) throws IllegalArgumentException {
        this.fact.addKeyTransRecipient(x509Certificate);
    }

    public void addKeyTransRecipient(PublicKey publicKey, byte[] byArray) throws IllegalArgumentException {
        this.fact.addKeyTransRecipient(publicKey, byArray);
    }

    public void addKEKRecipient(SecretKey secretKey, byte[] byArray) throws IllegalArgumentException {
        this.fact.addKEKRecipient(secretKey, byArray);
    }

    public void addKeyAgreementRecipient(String string, PrivateKey privateKey, PublicKey publicKey, X509Certificate x509Certificate, String string2, String string3) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeyException {
        this.fact.addKeyAgreementRecipient(string, privateKey, publicKey, x509Certificate, string2, string3);
    }

    public void setBerEncodeRecipients(boolean bl) {
        this.fact.setBEREncodeRecipients(bl);
    }

    private MimeBodyPart make(MimeBodyPart mimeBodyPart, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        KeyGenerator.getInstance(string, string2);
        try {
            MimeBodyPart mimeBodyPart2 = new MimeBodyPart();
            mimeBodyPart2.setContent(new ContentEncryptor(mimeBodyPart, string, n, string2), ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Type", ENCRYPTED_CONTENT_TYPE);
            mimeBodyPart2.addHeader("Content-Disposition", "attachment; filename=\"smime.p7m\"");
            mimeBodyPart2.addHeader("Content-Description", "S/MIME Encrypted Message");
            mimeBodyPart2.addHeader("Content-Transfer-Encoding", this.encoding);
            return mimeBodyPart2;
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("exception putting multi-part together.", messagingException);
        }
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string, 0, string2);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", messagingException);
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string, 0, string2);
    }

    public MimeBodyPart generate(MimeBodyPart mimeBodyPart, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        return this.make(this.makeContentBodyPart(mimeBodyPart), string, n, string2);
    }

    public MimeBodyPart generate(MimeMessage mimeMessage, String string, int n, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, SMIMEException {
        try {
            mimeMessage.saveChanges();
        }
        catch (MessagingException messagingException) {
            throw new SMIMEException("unable to save message", messagingException);
        }
        return this.make(this.makeContentBodyPart(mimeMessage), string, n, string2);
    }

    static {
        MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
        mailcapCommandMap.addMailcap("application/pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.pkcs7_mime");
        mailcapCommandMap.addMailcap("application/x-pkcs7-mime;; x-java-content-handler=org.bouncycastle.mail.smime.handlers.x_pkcs7_mime");
        CommandMap.setDefaultCommandMap(mailcapCommandMap);
    }

    private static class WrappingIOException
    extends IOException {
        private Throwable cause;

        WrappingIOException(String string, Throwable throwable) {
            super(string);
            this.cause = throwable;
        }

        public Throwable getCause() {
            return this.cause;
        }
    }

    private class EnvelopedGenerator
    extends CMSEnvelopedDataStreamGenerator {
        private String _encryptionOID;
        private SecretKey _encKey;
        private AlgorithmParameters _params;
        private ASN1EncodableVector _recipientInfos;

        private EnvelopedGenerator() {
        }

        protected OutputStream open(OutputStream outputStream, String string, SecretKey secretKey, AlgorithmParameters algorithmParameters, ASN1EncodableVector aSN1EncodableVector, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
            this._encryptionOID = string;
            this._encKey = secretKey;
            this._params = algorithmParameters;
            this._recipientInfos = aSN1EncodableVector;
            return super.open(outputStream, string, secretKey, algorithmParameters, aSN1EncodableVector, string2);
        }

        OutputStream regenerate(OutputStream outputStream, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
            return super.open(outputStream, this._encryptionOID, this._encKey, this._params, this._recipientInfos, string);
        }
    }

    private class ContentEncryptor
    implements SMIMEStreamingProcessor {
        private final MimeBodyPart _content;
        private final String _encryptionOid;
        private final int _keySize;
        private final String _provider;
        private boolean _firstTime = true;

        ContentEncryptor(MimeBodyPart mimeBodyPart, String string, int n, String string2) {
            this._content = mimeBodyPart;
            this._encryptionOid = string;
            this._keySize = n;
            this._provider = string2;
        }

        public void write(OutputStream outputStream) throws IOException {
            try {
                OutputStream outputStream2;
                if (this._firstTime) {
                    outputStream2 = this._keySize == 0 ? SMIMEEnvelopedGenerator.this.fact.open(outputStream, this._encryptionOid, this._provider) : SMIMEEnvelopedGenerator.this.fact.open(outputStream, this._encryptionOid, this._keySize, this._provider);
                    this._firstTime = false;
                } else {
                    outputStream2 = SMIMEEnvelopedGenerator.this.fact.regenerate(outputStream, this._provider);
                }
                this._content.writeTo(outputStream2);
                outputStream2.close();
            }
            catch (MessagingException messagingException) {
                throw new WrappingIOException(messagingException.toString(), messagingException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new WrappingIOException(noSuchAlgorithmException.toString(), noSuchAlgorithmException);
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new WrappingIOException(noSuchProviderException.toString(), noSuchProviderException);
            }
            catch (CMSException cMSException) {
                throw new WrappingIOException(cMSException.toString(), cMSException);
            }
        }
    }
}

