/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.monitor.jvm;

import java.lang.management.ManagementFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exoplatform.container.BaseContainerLifecyclePlugin;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.monitor.jvm.MemoryInfo;

public class AddJVMComponentsToRootContainer
extends BaseContainerLifecyclePlugin {
    private static final Log log = LogFactory.getLog(AddJVMComponentsToRootContainer.class);

    public void initContainer(ExoContainer container) {
        this.attemptToRegisterMXComponent(container, ManagementFactory.getOperatingSystemMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getRuntimeMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getThreadMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getClassLoadingMXBean());
        this.attemptToRegisterMXComponent(container, ManagementFactory.getCompilationMXBean());
        this.attemptToRegisterMXComponent(container, new MemoryInfo());
        this.attemptToRegisterMXComponent(container, "MemoryManagerMXBean", ManagementFactory.getMemoryManagerMXBeans());
        this.attemptToRegisterMXComponent(container, "MemoryPoolMXBeans", ManagementFactory.getMemoryPoolMXBeans());
        this.attemptToRegisterMXComponent(container, "GarbageCollectorMXBeans", ManagementFactory.getGarbageCollectorMXBeans());
    }

    private void attemptToRegisterMXComponent(ExoContainer container, Object mxComponent) {
        if (mxComponent != null) {
            log.debug("Attempt to register mx component " + mxComponent);
            container.registerComponentInstance(mxComponent);
            log.debug("Mx component " + mxComponent + " registered");
        }
    }

    private void attemptToRegisterMXComponent(ExoContainer container, Object mxKey, Object mxComponent) {
        if (mxComponent != null) {
            log.debug("Attempt to register mx component " + mxComponent + " with key " + mxKey);
            container.registerComponentInstance(mxKey, mxComponent);
            log.debug("Mx component " + mxComponent + " registered");
        }
    }
}

