/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.services.cache.concurrent.ConcurrentFIFOExoCache;
import org.exoplatform.services.cache.concurrent.ObjectRef;
import org.exoplatform.services.cache.concurrent.Queue;
import org.exoplatform.services.cache.concurrent.SimpleObjectRef;
import org.exoplatform.services.cache.concurrent.SynchronizedQueue;

class CacheState {
    private final Log log;
    private final ConcurrentFIFOExoCache config;
    final ConcurrentHashMap<Serializable, ObjectRef> map;
    final Queue<ObjectRef> queue;

    CacheState(ConcurrentFIFOExoCache config, Log log) {
        this.log = log;
        this.config = config;
        this.map = new ConcurrentHashMap();
        this.queue = new SynchronizedQueue<ObjectRef>(log);
    }

    public void assertConsistency() {
        if (this.queue instanceof SynchronizedQueue) {
            ((SynchronizedQueue)this.queue).assertConsistency();
        }
        int mapSize = this.map.size();
        int effectiveQueueSize = this.queue.size();
        if (effectiveQueueSize != mapSize) {
            throw new AssertionError((Object)("The map size is " + mapSize + " is different from the queue size " + effectiveQueueSize));
        }
    }

    public Object get(Serializable name) {
        ObjectRef entry = this.map.get(name);
        if (entry != null) {
            Object o = entry.getObject();
            if (entry.isValid()) {
                ++this.config.hits;
                this.config.onGet(name, o);
                return o;
            }
            ++this.config.misses;
            if (this.map.remove(name, entry)) {
                this.queue.remove(entry);
            }
            this.config.onExpire(name, o);
        }
        return null;
    }

    private boolean isTraceEnabled() {
        return this.log != null && this.log.isTraceEnabled();
    }

    private void trace(String message) {
        this.log.trace(message + " [" + Thread.currentThread().getName() + "]");
    }

    void put(long expirationTime, Serializable name, Object obj) {
        boolean trace = this.isTraceEnabled();
        SimpleObjectRef nextRef = new SimpleObjectRef(expirationTime, name, obj);
        ObjectRef previousRef = this.map.put(name, nextRef);
        if (previousRef != null) {
            this.queue.remove(previousRef);
            if (trace) {
                this.trace("Replaced item=" + previousRef.serial + " with item=" + nextRef.serial + " in the map");
            }
        } else if (trace) {
            this.trace("Added item=" + nextRef.serial + " to map");
        }
        this.queue.add(nextRef);
        ArrayList<ObjectRef> evictedRefs = this.queue.trim(this.config.maxSize);
        if (evictedRefs != null) {
            for (ObjectRef evictedRef : evictedRefs) {
                this.map.remove(evictedRef.name, evictedRef);
                this.config.onExpire(evictedRef.name, evictedRef.getObject());
            }
        }
        this.config.onPut(name, obj);
    }

    public Object remove(Serializable name) {
        boolean trace = this.isTraceEnabled();
        ObjectRef item = this.map.remove(name);
        if (item != null) {
            boolean removed;
            if (trace) {
                this.trace("Removed item=" + item.serial + " from the map going to remove it");
            }
            boolean valid = (removed = this.queue.remove(item)) && item.isValid();
            Object object = item.getObject();
            if (valid) {
                this.config.onRemove(name, object);
                return object;
            }
            this.config.onExpire(name, object);
            return null;
        }
        return null;
    }
}

