/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.database.impl;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.sql.DataSource;
import org.enhydra.jdbc.pool.StandardXAPoolDataSource;
import org.enhydra.jdbc.standard.StandardXADataSource;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.database.DatabaseService;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.transaction.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XAPoolTxSupportDatabaseService
implements DatabaseService {
    private HashMap<String, ExoDatasource> datasources_ = new HashMap(5);
    private ExoDatasource defaultDS_;
    private TransactionService txService_;

    public XAPoolTxSupportDatabaseService(InitParams params, TransactionService txService) throws Exception {
        this.txService_ = txService;
        Iterator i = params.getPropertiesParamIterator();
        while (i.hasNext()) {
            PropertiesParam param = (PropertiesParam)i.next();
            String name = param.getName();
            ExoDatasource ds = new ExoDatasource(this.createDatasource(param.getProperties()));
            this.datasources_.put(name, ds);
            if (this.defaultDS_ != null) continue;
            this.defaultDS_ = ds;
        }
    }

    @Override
    public ExoDatasource getDatasource() throws Exception {
        return this.defaultDS_;
    }

    @Override
    public ExoDatasource getDatasource(String dsName) throws Exception {
        return this.datasources_.get(dsName);
    }

    @Override
    public Connection getConnection() throws Exception {
        return this.defaultDS_.getConnection();
    }

    @Override
    public Connection getConnection(String dsName) throws Exception {
        ExoDatasource ds = this.datasources_.get(dsName);
        return ds.getConnection();
    }

    @Override
    public void closeConnection(Connection conn) throws Exception {
        this.defaultDS_.closeConnection(conn);
    }

    @Override
    public TransactionService getTransactionService() throws Exception {
        return this.txService_;
    }

    private DataSource createDatasource(Map<String, String> props) throws Exception {
        StandardXADataSource ds = new StandardXADataSource();
        ds.setDriverName(props.get("connection.driver"));
        ds.setUrl(props.get("connection.url"));
        ds.setUser(props.get("connection.login"));
        ds.setPassword(props.get("connection.password"));
        ds.setTransactionManager(this.txService_.getTransactionManager());
        StandardXAPoolDataSource pool = new StandardXAPoolDataSource(3);
        pool.setMinSize(Integer.parseInt(props.get("connection.min-size")));
        pool.setMaxSize(Integer.parseInt(props.get("connection.max-size")));
        pool.setUser(props.get("connection.login"));
        pool.setPassword(props.get("connection.password"));
        pool.setDataSource(ds);
        return pool;
    }
}

