/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.audit;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.StringTokenizer;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.IllegalNameException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditRecord;
import org.exoplatform.services.jcr.ext.audit.AuditService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.registry.RegistryEntry;
import org.exoplatform.services.jcr.ext.registry.RegistryService;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.ValueDataConvertor;
import org.exoplatform.services.jcr.impl.dataflow.session.SessionChangesLog;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AuditServiceImpl
implements AuditService,
Startable {
    private static final String ADMIN_INDENTITY = "adminIdentity";
    private String adminIdentity;
    private InitParams initParams;
    private RegistryService registryService;
    private RepositoryService repositoryService;
    private static Log log = ExoLogger.getLogger("jcr.AuditService");
    private List<String> adminIdentitys = null;
    private static final String SERVICE_NAME = "Audit";

    public AuditServiceImpl(InitParams initParams, RepositoryService repService) throws RepositoryConfigurationException {
        this(initParams, repService, null);
    }

    public AuditServiceImpl(InitParams initParams, RepositoryService repService, RegistryService registryService) throws RepositoryConfigurationException {
        this.initParams = initParams;
        this.registryService = registryService;
        this.repositoryService = repService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.registryService != null && !this.registryService.getForceXMLConfigurationValue(this.initParams)) {
            SessionProvider sessionProvider = SessionProvider.createSystemProvider();
            try {
                this.readParamsFromRegistryService(sessionProvider);
            }
            catch (Exception e) {
                this.readParamsFromFile();
                try {
                    this.writeParamsToRegistryService(sessionProvider);
                }
                catch (Exception exc) {
                    log.error("Cannot write init configuration to RegistryService.", exc);
                }
            }
            finally {
                sessionProvider.close();
            }
        } else {
            this.readParamsFromFile();
        }
    }

    public void addRecord(Item item, int eventType) throws RepositoryException {
        NodeData vancestor;
        String auditRecordName;
        this.checkIfAuditable(item);
        AuditSession auditSession = new AuditSession(item);
        SessionImpl session = (SessionImpl)item.getSession();
        SessionDataManager dataManager = auditSession.getDataManager();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory == null) {
            throw new PathNotFoundException("Audit history not found for " + item.getPath());
        }
        if (auditHistory == null) {
            throw new RepositoryException("Audit history for  " + item.getPath() + "not found");
        }
        QPath path = QPath.makeChildPath(auditHistory.getQPath(), AuditService.EXO_AUDITHISTORY_LASTRECORD);
        PropertyData pData = (PropertyData)dataManager.getItemData(path);
        try {
            auditRecordName = String.valueOf((int)ValueDataConvertor.readLong(pData.getValues().get(0)) + 1);
        }
        catch (Exception e) {
            throw new RepositoryException("Error on add audit record. Problem in calculating new record name. " + e.getLocalizedMessage());
        }
        TransientNodeData arNode = TransientNodeData.createNodeData(auditHistory, new InternalQName(null, auditRecordName), AuditService.EXO_AUDITRECORD);
        ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
        access.add(new AccessControlEntry(SystemIdentity.ANY, "set_property"));
        access.add(new AccessControlEntry(SystemIdentity.ANY, "read"));
        for (String identity : this.adminIdentitys) {
            access.add(new AccessControlEntry(identity, "remove"));
        }
        AccessControlList exoAuditRecordAccessControlList = new AccessControlList(session.getUserID(), access);
        arNode.setACL(exoAuditRecordAccessControlList);
        arNode.setOrderNumber(Integer.parseInt(auditRecordName));
        dataManager.update(new ItemState(arNode, 1, true, ((ItemImpl)item).getInternalPath()), true);
        TransientPropertyData arPrType = TransientPropertyData.createPropertyData(arNode, Constants.JCR_PRIMARYTYPE, 7, false);
        arPrType.setValue(new TransientValueData(arNode.getPrimaryTypeName()));
        TransientPropertyData arUser = TransientPropertyData.createPropertyData(arNode, AuditService.EXO_AUDITRECORD_USER, 1, false);
        arUser.setValue(new TransientValueData(session.getUserID()));
        TransientPropertyData arCreated = TransientPropertyData.createPropertyData(arNode, AuditService.EXO_AUDITRECORD_CREATED, 5, false);
        arCreated.setValue(new TransientValueData(dataManager.getTransactManager().getStorageDataManager().getCurrentTime()));
        TransientPropertyData arEventType = TransientPropertyData.createPropertyData(arNode, AuditService.EXO_AUDITRECORD_EVENTTYPE, 3, false);
        arEventType.setValue(new TransientValueData((long)eventType));
        dataManager.update(new ItemState(arPrType, 1, true, ((ItemImpl)item).getInternalPath()), true);
        dataManager.update(new ItemState(arUser, 1, true, ((ItemImpl)item).getInternalPath()), true);
        dataManager.update(new ItemState(arCreated, 1, true, ((ItemImpl)item).getInternalPath()), true);
        dataManager.update(new ItemState(arEventType, 1, true, ((ItemImpl)item).getInternalPath()), true);
        if (item.isNode()) {
            vancestor = ((NodeImpl)item).getVersionableAncestor();
        } else {
            vancestor = ((NodeImpl)((Property)item).getParent()).getVersionableAncestor();
            TransientPropertyData propertyNameData = TransientPropertyData.createPropertyData(arNode, EXO_AUDITRECORD_PROPERTYNAME, 1, false);
            propertyNameData.setValue(new TransientValueData(((ItemImpl)item).getInternalName()));
            dataManager.update(new ItemState(propertyNameData, 1, true, ((ItemImpl)item).getInternalPath()), true);
        }
        if (vancestor != null) {
            String versionName;
            String versionUUID;
            PropertyData bvProp = (PropertyData)dataManager.getItemData(vancestor, new QPathEntry(Constants.JCR_BASEVERSION, 1));
            try {
                versionUUID = ValueDataConvertor.readString(bvProp.getValues().get(0));
                Version version = (Version)((Object)dataManager.getItemByIdentifier(versionUUID, false));
                versionName = version.getName();
                VersionHistory versionHistory = (VersionHistory)((Object)dataManager.getItemByIdentifier(version.getParent().getUUID(), false));
                String[] labels = versionHistory.getVersionLabels(version);
                for (int i = 0; i < labels.length; ++i) {
                    String vl = labels[i];
                    if (i == 0) {
                        versionName = versionName + " ";
                    }
                    versionName = versionName + "'" + vl + "' ";
                }
            }
            catch (IOException e) {
                throw new RepositoryException("Can't read jcr:baseVersion property, error " + e, e);
            }
            TransientPropertyData auditVersion = TransientPropertyData.createPropertyData((NodeData)arNode, EXO_AUDITRECORD_AUDITVERSION, 1, false, new TransientValueData(versionUUID));
            TransientPropertyData auditVersionName = TransientPropertyData.createPropertyData((NodeData)arNode, EXO_AUDITRECORD_AUDITVERSIONNAME, 1, false, new TransientValueData(versionName));
            dataManager.update(new ItemState(auditVersion, 1, true, ((ItemImpl)item).getInternalPath()), true);
            dataManager.update(new ItemState(auditVersionName, 1, true, ((ItemImpl)item).getInternalPath()), true);
        }
        TransientPropertyData pLastRecord = (TransientPropertyData)auditSession.getDataManager().getItemData(QPath.makeChildPath(auditHistory.getQPath(), EXO_AUDITHISTORY_LASTRECORD));
        pLastRecord.setValue(new TransientValueData(String.valueOf(auditRecordName)));
        dataManager.update(new ItemState(pLastRecord, 2, true, ((ItemImpl)item).getInternalPath()), true);
        if (log.isDebugEnabled()) {
            log.debug("Add audit record:  Item path=" + ((ItemImpl)item).getLocation().getInternalPath().getAsString() + " User=" + session.getUserID() + " EventType=" + eventType);
        }
    }

    public void createHistory(Node node) throws RepositoryException {
        this.checkIfAuditable(node);
        AuditSession auditSession = new AuditSession(node);
        NodeData storage = auditSession.getAuditStorage();
        SessionImpl session = (SessionImpl)node.getSession();
        InternalQName aiName = new InternalQName(null, ((ItemImpl)((Object)node)).getData().getIdentifier());
        TransientNodeData ahNode = TransientNodeData.createNodeData(storage, aiName, AuditService.EXO_AUDITHISTORY);
        ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
        access.add(new AccessControlEntry(SystemIdentity.ANY, "add_node"));
        access.add(new AccessControlEntry(SystemIdentity.ANY, "read"));
        access.add(new AccessControlEntry(SystemIdentity.ANY, "set_property"));
        for (String identity : this.adminIdentitys) {
            access.add(new AccessControlEntry(identity, "remove"));
        }
        AccessControlList exoAuditHistoryAccessControlList = new AccessControlList(session.getUserID(), access);
        ahNode.setACL(exoAuditHistoryAccessControlList);
        ahNode.setMixinTypeNames(new InternalQName[]{Constants.MIX_REFERENCEABLE, Constants.EXO_PRIVILEGEABLE});
        TransientPropertyData aPrType = TransientPropertyData.createPropertyData(ahNode, Constants.JCR_PRIMARYTYPE, 7, false);
        aPrType.setValue(new TransientValueData(ahNode.getPrimaryTypeName()));
        TransientPropertyData ahUuid = TransientPropertyData.createPropertyData(ahNode, Constants.JCR_UUID, 1, false);
        ahUuid.setValue(new TransientValueData(ahNode.getIdentifier()));
        TransientPropertyData ahMixinTypes = TransientPropertyData.createPropertyData(ahNode, Constants.JCR_MIXINTYPES, 7, false);
        ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
        mixValues.add(new TransientValueData(Constants.MIX_REFERENCEABLE));
        mixValues.add(new TransientValueData(Constants.EXO_PRIVILEGEABLE));
        ahMixinTypes.setValues(mixValues);
        ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
        for (int i = 0; i < ahNode.getACL().getPermissionEntries().size(); ++i) {
            AccessControlEntry entry = ahNode.getACL().getPermissionEntries().get(i);
            permsValues.add(new TransientValueData(entry));
        }
        TransientPropertyData exoAuditPerms = TransientPropertyData.createPropertyData((NodeData)ahNode, Constants.EXO_PERMISSIONS, 100, true, permsValues);
        TransientPropertyData ahTargetNode = TransientPropertyData.createPropertyData(ahNode, AuditService.EXO_AUDITHISTORY_TARGETNODE, 9, false);
        ahTargetNode.setValue(new TransientValueData(((ItemImpl)((Object)node)).getData().getIdentifier()));
        TransientPropertyData ahLastRecord = TransientPropertyData.createPropertyData(ahNode, AuditService.EXO_AUDITHISTORY_LASTRECORD, 1, false);
        ahLastRecord.setValue(new TransientValueData("0"));
        TransientPropertyData pAuditHistory = TransientPropertyData.createPropertyData((NodeData)((ItemImpl)((Object)node)).getData(), AuditService.EXO_AUDITHISTORY, 1, false);
        pAuditHistory.setValue(new TransientValueData(new Identifier(ahNode.getIdentifier())));
        session.getTransientNodesManager().update(new ItemState(ahNode, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(aPrType, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(ahUuid, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(ahMixinTypes, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(exoAuditPerms, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(ahTargetNode, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(ahLastRecord, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
        session.getTransientNodesManager().update(new ItemState(pAuditHistory, 1, true, ((ItemImpl)((Object)node)).getInternalPath()), true);
    }

    public AuditHistory getHistory(Node node) throws RepositoryException, UnsupportedOperationException {
        AuditSession auditSession = new AuditSession(node);
        SessionDataManager dm = auditSession.getDataManager();
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory != null) {
            ArrayList<AuditRecord> auditRecords = new ArrayList<AuditRecord>();
            ValueFactoryImpl vf = (ValueFactoryImpl)node.getSession().getValueFactory();
            List<NodeData> auditRecordsNodeData = dm.getChildNodesData(auditHistory);
            for (NodeData nodeData : auditRecordsNodeData) {
                List<PropertyData> auditRecordNodeData = dm.getChildPropertiesData(nodeData);
                String user = null;
                InternalQName propertyName = null;
                int eventType = -1;
                Calendar date = null;
                String version = null;
                String versionName = null;
                try {
                    for (PropertyData propertyData : auditRecordNodeData) {
                        ValueData value = propertyData.getValues().get(0);
                        if (propertyData.getQPath().getName().equals(AuditService.EXO_AUDITRECORD_USER)) {
                            user = ValueDataConvertor.readString(value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals(AuditService.EXO_AUDITRECORD_EVENTTYPE)) {
                            eventType = (int)ValueDataConvertor.readLong(value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals(AuditService.EXO_AUDITRECORD_CREATED)) {
                            date = ValueDataConvertor.readDate(value);
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals(AuditService.EXO_AUDITRECORD_PROPERTYNAME)) {
                            propertyName = InternalQName.parse(ValueDataConvertor.readString(value));
                            continue;
                        }
                        if (propertyData.getQPath().getName().equals(AuditService.EXO_AUDITRECORD_AUDITVERSION)) {
                            version = ValueDataConvertor.readString(value);
                            continue;
                        }
                        if (!propertyData.getQPath().getName().equals(AuditService.EXO_AUDITRECORD_AUDITVERSIONNAME)) continue;
                        versionName = ValueDataConvertor.readString(value);
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RepositoryException(e);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException(e);
                }
                catch (IOException e) {
                    throw new RepositoryException(e);
                }
                catch (IllegalNameException e) {
                    throw new RepositoryException(e);
                }
                auditRecords.add(new AuditRecord(user, eventType, date, propertyName, version, versionName));
            }
            return new AuditHistory(node, auditRecords);
        }
        throw new PathNotFoundException("Audit history not found for " + node.getPath());
    }

    public boolean hasHistory(Node node) {
        NodeData data;
        try {
            AuditSession auditSession = new AuditSession(node);
            data = auditSession.getAuditHistoryNodeData();
        }
        catch (RepositoryException e) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Audit history for " + node.getPath() + " not accessible due to error " + e, e);
                }
            }
            catch (RepositoryException e1) {
                log.error("Can't read node path for " + node, e1);
            }
            return false;
        }
        return data != null;
    }

    public void removeHistory(Node node) throws RepositoryException {
        AuditSession auditSession = new AuditSession(node);
        NodeData auditHistory = auditSession.getAuditHistoryNodeData();
        if (auditHistory == null) {
            throw new PathNotFoundException("Audit history not found for " + node.getPath());
        }
        SessionImpl session = (SessionImpl)node.getSession();
        session.getTransientNodesManager().delete(auditHistory);
    }

    private void checkIfAuditable(Item item) throws RepositoryException, UnsupportedOperationException {
        NodeImpl node;
        NodeImpl nodeImpl = node = item.isNode() ? (NodeImpl)item : (NodeImpl)item.getParent();
        if (!node.isNodeType("exo:auditable")) {
            throw new ConstraintViolationException("exo:auditable node expected at: " + node.getPath());
        }
    }

    private void writeParamsToRegistryService(SessionProvider sessionProvider) throws IOException, SAXException, ParserConfigurationException, RepositoryException {
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement(SERVICE_NAME);
        doc.appendChild(root);
        Element element = doc.createElement(ADMIN_INDENTITY);
        this.setAttributeSmart(element, "value", this.adminIdentity);
        root.appendChild(element);
        RegistryEntry serviceEntry = new RegistryEntry(doc);
        this.registryService.createEntry(sessionProvider, "exo:services", serviceEntry);
    }

    private void readParamsFromRegistryService(SessionProvider sessionProvider) throws PathNotFoundException, RepositoryException, RepositoryConfigurationException {
        String entryPath = "exo:services/Audit/adminIdentity";
        RegistryEntry registryEntry = this.registryService.getEntry(sessionProvider, entryPath);
        Document doc = registryEntry.getDocument();
        Element element = doc.getDocumentElement();
        this.adminIdentity = this.getAttributeSmart(element, "value");
        log.info("Admin identity is read from RegistryService");
        this.checkParams();
    }

    private String getAttributeSmart(Element element, String attr) {
        return element.hasAttribute(attr) ? element.getAttribute(attr) : null;
    }

    private void setAttributeSmart(Element element, String attr, String value) {
        if (value == null) {
            element.removeAttribute(attr);
        } else {
            element.setAttribute(attr, value);
        }
    }

    private void readParamsFromFile() {
        ValueParam valParam;
        if (this.initParams != null && (valParam = this.initParams.getValueParam(ADMIN_INDENTITY)) != null) {
            this.adminIdentity = valParam.getValue();
        }
        log.info("Admin identity is read from configuration file");
        this.checkParams();
    }

    private void checkParams() {
        if (this.adminIdentity == null) {
            throw new RuntimeException("Admin identity is not configured");
        }
        StringTokenizer listTokenizer = new StringTokenizer(this.adminIdentity, ";");
        if (listTokenizer.countTokens() < 1) {
            throw new RuntimeException("AccessControlList " + this.adminIdentity + " is empty or have a bad format");
        }
        this.adminIdentitys = new ArrayList<String>(listTokenizer.countTokens());
        while (listTokenizer.hasMoreTokens()) {
            this.adminIdentitys.add(listTokenizer.nextToken());
        }
    }

    public void stop() {
    }

    private class AuditSession {
        private final SessionImpl session;
        private final SessionDataManager dataManager;
        private ExtendedNode node;

        private AuditSession(Item item) throws RepositoryException {
            this.session = (SessionImpl)item.getSession();
            this.node = item.isNode() ? (ExtendedNode)item : (ExtendedNode)item.getParent();
            if (!this.node.isNodeType(AuditService.EXO_AUDITABLE)) {
                throw new RepositoryException("Node is not exo:auditable " + this.node.getPath());
            }
            this.dataManager = this.session.getTransientNodesManager();
        }

        private NodeData getAuditHistoryNodeData() throws RepositoryException {
            PropertyData pData = (PropertyData)this.dataManager.getItemData((NodeData)((NodeImpl)this.node).getData(), new QPathEntry(AuditService.EXO_AUDITHISTORY, 0));
            if (pData != null) {
                try {
                    String ahUuid = ValueDataConvertor.readString(pData.getValues().get(0));
                    return (NodeData)this.dataManager.getItemData(ahUuid);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", e);
                }
                catch (IllegalStateException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", e);
                }
                catch (IOException e) {
                    throw new RepositoryException("Error of exo:auditHistory read", e);
                }
            }
            return null;
        }

        private NodeData getAuditStorage() throws RepositoryException {
            ItemData storage = this.session.getTransientNodesManager().getItemData("00exo0jcr0audit0storage0id000000");
            if (storage == null) {
                SessionChangesLog changesLog = new SessionChangesLog(this.session.getId());
                TransientNodeData exoAuditNode = TransientNodeData.createNodeData((NodeData)((NodeImpl)this.session.getRootNode()).getData(), AuditService.EXO_AUDIT, AuditService.EXO_AUDITSTORAGE, "00exo0jcr0audit0storage0id000000");
                ArrayList<AccessControlEntry> access = new ArrayList<AccessControlEntry>();
                access.add(new AccessControlEntry(SystemIdentity.ANY, "add_node"));
                for (String identity : AuditServiceImpl.this.adminIdentitys) {
                    access.add(new AccessControlEntry(identity, "read"));
                }
                access.add(new AccessControlEntry(SystemIdentity.ANY, "remove"));
                AccessControlList exoAuditAccessControlList = new AccessControlList(SystemIdentity.SYSTEM, access);
                exoAuditNode.setACL(exoAuditAccessControlList);
                InternalQName[] mixins = new InternalQName[]{Constants.EXO_PRIVILEGEABLE, Constants.MIX_REFERENCEABLE};
                exoAuditNode.setMixinTypeNames(mixins);
                TransientPropertyData exoAuditPrType = TransientPropertyData.createPropertyData(exoAuditNode, Constants.JCR_PRIMARYTYPE, 7, false);
                exoAuditPrType.setValue(new TransientValueData(exoAuditNode.getPrimaryTypeName()));
                TransientPropertyData exoAuditUuid = TransientPropertyData.createPropertyData(exoAuditNode, Constants.JCR_UUID, 1, false);
                exoAuditUuid.setValue(new TransientValueData(exoAuditNode.getIdentifier()));
                TransientPropertyData exoAuditMixinTypes = TransientPropertyData.createPropertyData(exoAuditNode, Constants.JCR_MIXINTYPES, 7, true);
                ArrayList<ValueData> mixValues = new ArrayList<ValueData>();
                mixValues.add(new TransientValueData(Constants.MIX_REFERENCEABLE));
                mixValues.add(new TransientValueData(Constants.EXO_PRIVILEGEABLE));
                exoAuditMixinTypes.setValues(mixValues);
                ArrayList<ValueData> permsValues = new ArrayList<ValueData>();
                for (int i = 0; i < exoAuditNode.getACL().getPermissionEntries().size(); ++i) {
                    AccessControlEntry entry = exoAuditNode.getACL().getPermissionEntries().get(i);
                    permsValues.add(new TransientValueData(entry));
                }
                TransientPropertyData exoAuditPerms = TransientPropertyData.createPropertyData((NodeData)exoAuditNode, Constants.EXO_PERMISSIONS, 100, true, permsValues);
                changesLog.add(ItemState.createAddedState(exoAuditNode));
                changesLog.add(ItemState.createAddedState(exoAuditPrType));
                changesLog.add(ItemState.createAddedState(exoAuditUuid));
                changesLog.add(ItemState.createAddedState(exoAuditMixinTypes));
                changesLog.add(ItemState.createAddedState(exoAuditPerms));
                this.session.getTransientNodesManager().getTransactManager().save(changesLog);
                storage = this.session.getTransientNodesManager().getItemData("00exo0jcr0audit0storage0id000000");
            }
            if (!storage.isNode()) {
                throw new RepositoryException("Item with uuid 00exo0jcr0audit0storage0id000000 should be node  ");
            }
            return (NodeData)storage;
        }

        private SessionDataManager getDataManager() {
            return this.dataManager;
        }
    }
}

