/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.InvalidItemStateException;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemDataKeeper;
import org.exoplatform.services.jcr.dataflow.ItemStateChangesLog;
import org.exoplatform.services.jcr.dataflow.persistent.ItemsPersistenceListener;
import org.exoplatform.services.jcr.impl.core.lock.LockManagerImpl;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.dataflow.persistent.CacheableWorkspaceDataManager;
import org.exoplatform.services.log.ExoLogger;

public class WorkspaceDataManagerProxy
implements ItemDataKeeper {
    private static Log log = ExoLogger.getLogger("jcr.WorkspaceDataManagerProxy");
    private List<ItemsPersistenceListener> listeners = new ArrayList<ItemsPersistenceListener>();

    public WorkspaceDataManagerProxy(CacheableWorkspaceDataManager dataManager, SearchManager searchIndex, LockManagerImpl lockManager) {
        this.listeners.add(dataManager.getCache());
        if (searchIndex != null) {
            this.listeners.add(searchIndex);
        }
        if (lockManager != null) {
            this.listeners.add(lockManager);
        }
        log.info("WorkspaceDataManagerProxy is instantiated");
    }

    public void save(ItemStateChangesLog changesLog) throws InvalidItemStateException, UnsupportedOperationException, RepositoryException {
        for (ItemsPersistenceListener listener : this.listeners) {
            listener.onSaveItems(changesLog);
        }
        if (log.isDebugEnabled()) {
            log.debug("ChangesLog sent to " + this.listeners);
        }
    }
}

