/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.dataflow.PersistentDataManager;
import org.exoplatform.services.jcr.ext.replication.ReplicationException;
import org.exoplatform.services.jcr.ext.replication.async.AsyncInitializer;
import org.exoplatform.services.jcr.ext.replication.async.AsyncReceiverImpl;
import org.exoplatform.services.jcr.ext.replication.async.AsyncTransmitterImpl;
import org.exoplatform.services.jcr.ext.replication.async.ChangesPublisherImpl;
import org.exoplatform.services.jcr.ext.replication.async.ChangesSaveErrorLog;
import org.exoplatform.services.jcr.ext.replication.async.ChangesSubscriberImpl;
import org.exoplatform.services.jcr.ext.replication.async.ConnectionListener;
import org.exoplatform.services.jcr.ext.replication.async.MergeDataManager;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportServerImpl;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporterImpl;
import org.exoplatform.services.jcr.ext.replication.async.WorkspaceSynchronizerImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.IncomeStorageImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.LocalStorageImpl;
import org.exoplatform.services.jcr.ext.replication.async.storage.ReplicableValueData;
import org.exoplatform.services.jcr.ext.replication.async.transport.AsyncChannelManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.impl.util.io.WorkspaceFileCleanerHolder;
import org.exoplatform.services.jcr.storage.WorkspaceDataContainer;
import org.exoplatform.services.log.ExoLogger;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncReplication
implements Startable {
    private static final Log LOG = ExoLogger.getLogger("ext.AsyncReplication");
    private static final String IP_ADRESS_TEMPLATE = "[$]bind-ip-address";
    public final int FILE_CLEANER_PERIOD = 150000;
    protected final RepositoryService repoService;
    protected final LinkedHashMap<StorageKey, String> incomeStoragePaths;
    protected final LinkedHashMap<StorageKey, LocalStorageImpl> localStorages;
    protected final int priority;
    protected final List<Integer> otherParticipantsPriority;
    protected Set<AsyncWorker> currentWorkers;
    protected final String bindIPAddress;
    protected final String channelConfig;
    protected final String channelName;
    protected final int waitAllMembersTimeout;
    protected final String mergeTempDir;
    protected final String storageDir;
    protected final String localStorageDir;
    protected final String incomeStorageDir;
    protected final String[] repositoryNames;
    protected final FileCleaner fileCleaner;

    public AsyncReplication(RepositoryService repoService, InitParams params) throws RepositoryException, RepositoryConfigurationException {
        this.repoService = repoService;
        ValuesParam vp = params.getValuesParam("repositories");
        if (vp == null || vp.getValues().size() == 0) {
            throw new RuntimeException("repositories not specified");
        }
        ArrayList repoNamesList = vp.getValues();
        String[] repos = new String[repoNamesList.size()];
        repoNamesList.toArray(repos);
        this.repositoryNames = repos;
        PropertiesParam pps = params.getPropertiesParam("replication-properties");
        if (pps == null) {
            throw new RuntimeException("replication-properties not specified");
        }
        if (pps.getProperty("priority") == null) {
            throw new RuntimeException("priority not specified");
        }
        this.priority = Integer.parseInt(pps.getProperty("priority"));
        this.bindIPAddress = pps.getProperty("bind-ip-address");
        String chConfig = pps.getProperty("channel-config");
        if (chConfig == null) {
            throw new RuntimeException("channel-config not specified");
        }
        this.channelConfig = chConfig.replaceAll(IP_ADRESS_TEMPLATE, this.bindIPAddress);
        this.channelName = pps.getProperty("channel-name");
        if (this.channelName == null) {
            throw new RuntimeException("channel-config not specified");
        }
        if (pps.getProperty("wait-all-members") == null) {
            throw new RuntimeException("wait-all-members timeout not specified");
        }
        this.waitAllMembersTimeout = Integer.parseInt(pps.getProperty("wait-all-members")) * 1000;
        this.storageDir = pps.getProperty("storage-dir");
        if (this.storageDir == null) {
            throw new RuntimeException("storage-dir not specified");
        }
        String sOtherParticipantsPriority = pps.getProperty("other-participants-priority");
        if (sOtherParticipantsPriority == null) {
            throw new RuntimeException("other-participants-priority not specified");
        }
        String[] saOtherParticipantsPriority = sOtherParticipantsPriority.split(",");
        this.otherParticipantsPriority = new ArrayList<Integer>();
        for (String sPriority : saOtherParticipantsPriority) {
            this.otherParticipantsPriority.add(Integer.valueOf(sPriority));
        }
        if (this.hasDuplicatePriority(this.otherParticipantsPriority, this.priority)) {
            throw new RuntimeException("The value of priority is duplicated : Priority = " + this.priority + " ; " + "Other participants priority = " + this.otherParticipantsPriority);
        }
        this.currentWorkers = new LinkedHashSet<AsyncWorker>();
        this.incomeStoragePaths = new LinkedHashMap();
        this.localStorages = new LinkedHashMap();
        File incomeDir = new File(this.storageDir + "/income");
        incomeDir.mkdirs();
        this.incomeStorageDir = incomeDir.getAbsolutePath();
        File localDir = new File(this.storageDir + "/local");
        localDir.mkdirs();
        this.localStorageDir = localDir.getAbsolutePath();
        File mergeTempDir = new File(this.storageDir + "/merge-temp");
        mergeTempDir.mkdirs();
        this.mergeTempDir = mergeTempDir.getAbsolutePath();
        this.fileCleaner = new FileCleaner(150000L, false);
    }

    AsyncReplication(RepositoryService repoService, List<String> repositoryNames, int priority, String bindIPAddress, String channelConfig, String channelName, int waitAllMembersTimeout, String storageDir, List<Integer> otherParticipantsPriority) throws RepositoryException, RepositoryConfigurationException {
        this.repoService = repoService;
        if (repositoryNames.size() == 0) {
            throw new RuntimeException("repositories not specified");
        }
        this.repositoryNames = repositoryNames.toArray(new String[repositoryNames.size()]);
        this.priority = priority;
        this.bindIPAddress = bindIPAddress;
        this.channelConfig = channelConfig.replaceAll(IP_ADRESS_TEMPLATE, bindIPAddress);
        this.channelName = channelName;
        this.waitAllMembersTimeout = waitAllMembersTimeout * 1000;
        this.otherParticipantsPriority = new ArrayList<Integer>(otherParticipantsPriority);
        this.currentWorkers = new LinkedHashSet<AsyncWorker>();
        this.incomeStoragePaths = new LinkedHashMap();
        this.localStorages = new LinkedHashMap();
        this.storageDir = storageDir;
        File incomeDir = new File(storageDir + "/income");
        incomeDir.mkdirs();
        this.incomeStorageDir = incomeDir.getAbsolutePath();
        File localDir = new File(storageDir + "/local");
        localDir.mkdirs();
        this.localStorageDir = localDir.getAbsolutePath();
        File mergeTempDir = new File(storageDir + "/merge-temp");
        mergeTempDir.mkdirs();
        this.mergeTempDir = mergeTempDir.getAbsolutePath();
        this.fileCleaner = new FileCleaner(150000L, false);
    }

    public boolean isActive() {
        return this.currentWorkers.size() > 0;
    }

    public synchronized boolean synchronize() throws RepositoryException, RepositoryConfigurationException, IOException {
        if (this.isActive()) {
            LOG.error("[ERROR] Asynchronous replication service already active. Wait for current synchronization finish.");
            return false;
        }
        if (this.repositoryNames != null && this.repositoryNames.length > 0) {
            for (String repoName : this.repositoryNames) {
                this.synchronize(repoName);
            }
            return true;
        }
        LOG.error("[ERROR] Asynchronous replication service is not proper initializer or started. Repositories list empty. Check log for details.");
        return false;
    }

    protected void synchronize(String repoName) throws RepositoryException, RepositoryConfigurationException, IOException {
        if (this.hasChangesSaveError(repoName)) {
            LOG.error("[ERROR] Synchronization not started. The previous synchronisation have errors.");
            return;
        }
        if (this.hasLocalSorageError(repoName)) {
            LOG.error("[ERROR] Synchronization not started. Loacal storage have errors.");
            return;
        }
        ManageableRepository repository = this.repoService.getRepository(repoName);
        for (String wsName : repository.getWorkspaceNames()) {
            this.synchronize(repoName, wsName);
        }
    }

    protected void synchronize(String repoName, String workspaceName) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository repository = this.repoService.getRepository(repoName);
        WorkspaceContainerFacade syswsc = repository.getWorkspaceContainer(repository.getConfiguration().getSystemWorkspaceName());
        PersistentDataManager sysdm = (PersistentDataManager)syswsc.getComponent(PersistentDataManager.class);
        WorkspaceContainerFacade wsc = repository.getWorkspaceContainer(workspaceName);
        NodeTypeDataManager ntm = (NodeTypeDataManager)wsc.getComponent(NodeTypeDataManager.class);
        PersistentDataManager dm = (PersistentDataManager)wsc.getComponent(PersistentDataManager.class);
        WorkspaceDataContainer dc = (WorkspaceDataContainer)wsc.getComponent(WorkspaceDataContainer.class);
        WorkspaceEntry wconf = (WorkspaceEntry)wsc.getComponent(WorkspaceEntry.class);
        WorkspaceFileCleanerHolder wfcleaner = (WorkspaceFileCleanerHolder)wsc.getComponent(WorkspaceFileCleanerHolder.class);
        StorageKey skey = new StorageKey(repoName, workspaceName);
        LocalStorageImpl localStorage = this.localStorages.get(skey);
        IncomeStorageImpl incomeStorage = new IncomeStorageImpl(this.incomeStoragePaths.get(skey));
        AsyncWorker synchWorker = new AsyncWorker(dm, sysdm, ntm, dc, localStorage, incomeStorage, repoName, workspaceName, repoName + "_" + workspaceName, wconf, wfcleaner);
        synchWorker.run();
        this.currentWorkers.add(synchWorker);
    }

    @Override
    public void start() {
        try {
            for (String repositoryName : this.repositoryNames) {
                ManageableRepository repository = this.repoService.getRepository(repositoryName);
                for (String wsName : repository.getWorkspaceNames()) {
                    StorageKey skey = new StorageKey(repositoryName, wsName);
                    File localDirPerWorkspace = new File(this.localStorageDir + File.separator + repositoryName + File.separator + wsName);
                    localDirPerWorkspace.mkdirs();
                    LocalStorageImpl localStorage = new LocalStorageImpl(localDirPerWorkspace.getAbsolutePath(), this.fileCleaner);
                    this.localStorages.put(skey, localStorage);
                    WorkspaceContainerFacade wsc = repository.getWorkspaceContainer(wsName);
                    PersistentDataManager dm = (PersistentDataManager)wsc.getComponent(PersistentDataManager.class);
                    dm.addItemPersistenceListener(localStorage);
                    File incomeDirPerWorkspace = new File(this.incomeStorageDir + File.separator + repositoryName + File.separator + wsName);
                    incomeDirPerWorkspace.mkdirs();
                    this.incomeStoragePaths.put(new StorageKey(repositoryName, wsName), incomeDirPerWorkspace.getAbsolutePath());
                }
            }
            this.fileCleaner.start();
            this.fileCleaner.setName("AsyncReplication FileCleaner");
            ReplicableValueData.initFileCleaner(this.fileCleaner);
        }
        catch (Throwable e) {
            LOG.error("Asynchronous replication start fails" + e, e);
            throw new RuntimeException("Asynchronous replication start fails " + e, e);
        }
    }

    @Override
    public void stop() {
    }

    private boolean hasLocalSorageError(String repositoryName) throws RepositoryConfigurationException, RepositoryException, IOException {
        boolean hasLocalSorageError = false;
        ManageableRepository repository = this.repoService.getRepository(repositoryName);
        for (String wsName : repository.getWorkspaceNames()) {
            LocalStorage localStorage = this.localStorages.get(new StorageKey(repositoryName, wsName));
            String[] storageError = localStorage.getErrors();
            if (storageError.length <= 0) continue;
            hasLocalSorageError = true;
            LOG.error("The local storage '" + repositoryName + "@" + wsName + "' have errors : ");
            for (String error : storageError) {
                LOG.error(error);
            }
        }
        return hasLocalSorageError;
    }

    private boolean hasChangesSaveError(String repositoryName) throws RepositoryConfigurationException, RepositoryException, IOException {
        boolean hasChangesSaveError = false;
        ManageableRepository repository = this.repoService.getRepository(repositoryName);
        for (String wsName : repository.getWorkspaceNames()) {
            ChangesSaveErrorLog errorLog = new ChangesSaveErrorLog(this.storageDir, repositoryName, wsName);
            String[] changesSaveErrors = errorLog.getErrors();
            if (changesSaveErrors.length <= 0) continue;
            hasChangesSaveError = true;
            LOG.error("The errors log file : " + errorLog.getErrorLog());
            LOG.error("The previous save on '" + repositoryName + "@" + wsName + "' have errors : ");
            for (String error : changesSaveErrors) {
                LOG.error(error);
            }
        }
        return hasChangesSaveError;
    }

    private boolean hasDuplicatePriority(List<Integer> other, int ownPriority) {
        if (other.contains(ownPriority)) {
            return true;
        }
        for (int i = 0; i < other.size(); ++i) {
            int pri = other.get(i);
            ArrayList<Integer> oth = new ArrayList<Integer>(other);
            oth.remove(i);
            if (!oth.contains(pri)) continue;
            return true;
        }
        return false;
    }

    protected class StorageKey {
        private final String repositoryName;
        private final String workspaceName;

        public StorageKey(String repositoryName, String workspaceName) {
            this.repositoryName = repositoryName;
            this.workspaceName = workspaceName;
        }

        public boolean equals(Object o) {
            StorageKey k = (StorageKey)o;
            return this.repositoryName.equals(k.repositoryName) && this.workspaceName.equals(k.workspaceName);
        }

        public int hashCode() {
            return this.repositoryName.hashCode() ^ this.workspaceName.hashCode();
        }
    }

    class AsyncWorker
    implements ConnectionListener {
        protected final AsyncChannelManager channel;
        protected final AsyncInitializer initializer;
        protected final ChangesPublisherImpl publisher;
        protected final ChangesSubscriberImpl subscriber;
        protected final WorkspaceSynchronizerImpl synchronyzer;
        protected final AsyncTransmitterImpl transmitter;
        protected final AsyncReceiverImpl receiver;
        protected final RemoteExporterImpl exporter;
        protected final RemoteExportServerImpl exportServer;
        protected final ChangesSaveErrorLog changesSaveErrorLog;
        protected final MergeDataManager mergeManager;
        protected final PersistentDataManager dataManager;
        protected final PersistentDataManager systemDataManager;
        protected final WorkspaceDataContainer dataContainer;
        protected final NodeTypeDataManager ntManager;
        protected final LocalStorageImpl localStorage;
        protected final IncomeStorageImpl incomeStorage;

        AsyncWorker(PersistentDataManager dataManager, PersistentDataManager systemDataManager, NodeTypeDataManager ntManager, WorkspaceDataContainer dataContainer, LocalStorageImpl localStorage, IncomeStorageImpl incomeStorage, String repoName, String wsName, String chanelNameSufix, WorkspaceEntry workspaceConfig, WorkspaceFileCleanerHolder workspaceCleanerHolder) {
            this.channel = new AsyncChannelManager(AsyncReplication.this.channelConfig, AsyncReplication.this.channelName + "_" + chanelNameSufix, AsyncReplication.this.otherParticipantsPriority.size() + 1);
            this.dataManager = dataManager;
            this.systemDataManager = systemDataManager;
            this.ntManager = ntManager;
            this.dataContainer = dataContainer;
            this.localStorage = localStorage;
            this.incomeStorage = incomeStorage;
            this.transmitter = new AsyncTransmitterImpl(this.channel, AsyncReplication.this.priority);
            this.synchronyzer = new WorkspaceSynchronizerImpl(dataManager, systemDataManager, this.localStorage, workspaceConfig, workspaceCleanerHolder);
            this.exportServer = new RemoteExportServerImpl(this.transmitter, dataManager, ntManager);
            this.changesSaveErrorLog = new ChangesSaveErrorLog(AsyncReplication.this.storageDir, repoName, wsName);
            this.receiver = new AsyncReceiverImpl(this.channel, this.exportServer, AsyncReplication.this.otherParticipantsPriority);
            this.exporter = new RemoteExporterImpl(this.transmitter, this.receiver, AsyncReplication.this.mergeTempDir);
            this.mergeManager = new MergeDataManager(this.exporter, dataManager, ntManager, AsyncReplication.this.mergeTempDir);
            this.initializer = new AsyncInitializer(this.channel, AsyncReplication.this.priority, AsyncReplication.this.otherParticipantsPriority, AsyncReplication.this.waitAllMembersTimeout, true);
            this.publisher = new ChangesPublisherImpl(this.initializer, this.transmitter, this.localStorage);
            this.subscriber = new ChangesSubscriberImpl(this.initializer, this.transmitter, this.synchronyzer, this.mergeManager, this.incomeStorage, this.changesSaveErrorLog, AsyncReplication.this.waitAllMembersTimeout, AsyncReplication.this.priority, AsyncReplication.this.otherParticipantsPriority.size() + 1);
            this.channel.addPacketListener(this.receiver);
            this.channel.addPacketListener(this.initializer);
            this.channel.addStateListener(this.initializer);
            this.channel.addConnectionListener(this);
            this.receiver.setChangesSubscriber(this.subscriber);
            this.initializer.addRemoteListener(this.localStorage);
            this.initializer.addRemoteListener(this.incomeStorage);
            this.initializer.addRemoteListener(this.publisher);
            this.initializer.addRemoteListener(this.exportServer);
            this.initializer.addRemoteListener(this.subscriber);
            this.publisher.addLocalListener(this.localStorage);
            this.publisher.addLocalListener(this.incomeStorage);
            this.publisher.addLocalListener(this.exportServer);
            this.publisher.addLocalListener(this.subscriber);
            this.publisher.addLocalListener(this.initializer);
            this.subscriber.addLocalListener(this.localStorage);
            this.subscriber.addLocalListener(this.incomeStorage);
            this.subscriber.addLocalListener(this.publisher);
            this.subscriber.addLocalListener(this.exportServer);
            this.subscriber.addLocalListener(this.initializer);
        }

        public void onDisconnect() {
            this.doFinalyze();
        }

        private void doFinalyze() {
            this.receiver.setChangesSubscriber(null);
            this.publisher.removeLocalListener(this.exportServer);
            this.publisher.removeLocalListener(this.subscriber);
            this.publisher.removeLocalListener(this.initializer);
            this.publisher.removeLocalListener(this.localStorage);
            this.publisher.removeLocalListener(this.incomeStorage);
            this.subscriber.removeLocalListener(this.publisher);
            this.subscriber.removeLocalListener(this.exportServer);
            this.subscriber.removeLocalListener(this.initializer);
            this.subscriber.removeLocalListener(this.localStorage);
            this.subscriber.removeLocalListener(this.incomeStorage);
            this.initializer.removeRemoteListener(this.subscriber);
            this.initializer.removeRemoteListener(this.publisher);
            this.initializer.removeRemoteListener(this.exportServer);
            this.initializer.removeRemoteListener(this.localStorage);
            this.initializer.removeRemoteListener(this.incomeStorage);
            this.channel.removePacketListener(this.receiver);
            this.channel.removePacketListener(this.initializer);
            this.channel.removeStateListener(this.initializer);
            this.exporter.cleanup();
            AsyncReplication.this.currentWorkers.remove(this);
            this.dataContainer.setReadOnly(false);
            LOG.info("Synchronization done.");
        }

        public void run() {
            try {
                this.dataContainer.setReadOnly(true);
                this.channel.connect();
            }
            catch (ReplicationException e) {
                LOG.error("Synchronization start error " + e, e);
                this.doFinalyze();
            }
        }
    }
}

