/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.async.merge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExportException;
import org.exoplatform.services.jcr.ext.replication.async.RemoteExporter;
import org.exoplatform.services.jcr.ext.replication.async.merge.ChangesMerger;
import org.exoplatform.services.jcr.ext.replication.async.storage.ChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.EditableChangesStorage;
import org.exoplatform.services.jcr.ext.replication.async.storage.ResourcesHolder;
import org.exoplatform.services.jcr.ext.replication.async.storage.StorageRuntimeException;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMerger
implements ChangesMerger {
    protected final boolean localPriority;
    protected final RemoteExporter exporter;
    protected final DataManager dataManager;
    protected final NodeTypeDataManager ntManager;
    protected final ResourcesHolder resHolder;

    public AbstractMerger(boolean localPriority, RemoteExporter exporter, DataManager dataManager, NodeTypeDataManager ntManager, ResourcesHolder resHolder) {
        this.localPriority = localPriority;
        this.exporter = exporter;
        this.dataManager = dataManager;
        this.ntManager = ntManager;
        this.resHolder = resHolder;
    }

    @Override
    public boolean isLocalPriority() {
        return this.localPriority;
    }

    @Override
    public abstract EditableChangesStorage<ItemState> merge(ItemState var1, ChangesStorage<ItemState> var2, ChangesStorage<ItemState> var3, String var4, List<QPath> var5, List<QPath> var6) throws RepositoryException, RemoteExportException, IOException, ClassCastException, ClassNotFoundException, StorageRuntimeException;

    protected List<ItemState> generateDeleleLockProperties(NodeData node) throws RepositoryException {
        ArrayList<ItemState> result = new ArrayList<ItemState>();
        if (this.ntManager.isNodeType(Constants.MIX_LOCKABLE, node.getPrimaryTypeName(), node.getMixinTypeNames())) {
            ItemData item = this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_LOCKISDEEP, 1));
            if (item != null) {
                result.add(new ItemState(item, 4, true, node.getQPath()));
            }
            if ((item = this.dataManager.getItemData(node, new QPathEntry(Constants.JCR_LOCKOWNER, 1))) != null) {
                result.add(new ItemState(item, 4, true, node.getQPath()));
            }
        }
        return result;
    }

    protected ItemState generateRestoreRenamedItem(ItemState deleteState, ItemState renameState) throws ClassCastException, IOException, ClassNotFoundException {
        if (deleteState.getData().isNode()) {
            NodeData node = (NodeData)deleteState.getData();
            TransientNodeData newNode = new TransientNodeData(node.getQPath(), node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
            return new ItemState(newNode, 1, deleteState.isEventFire(), node.getQPath());
        }
        PropertyData prop = (PropertyData)deleteState.getData();
        TransientPropertyData newProp = new TransientPropertyData(prop.getQPath(), prop.getIdentifier(), prop.getPersistedVersion(), prop.getType(), prop.getParentIdentifier(), prop.isMultiValued());
        newProp.setValues(((PropertyData)renameState.getData()).getValues());
        return new ItemState(newProp, 1, deleteState.isEventFire(), prop.getQPath());
    }

    protected List<ItemState> generateRestoreMixinChanges(ItemState firstState, ChangesStorage<ItemState> storage) throws ClassCastException, IOException, ClassNotFoundException, RepositoryException {
        ArrayList<ItemState> resultState = new ArrayList<ItemState>();
        resultState.add(firstState);
        List<ItemState> localMixinSeq = storage.getMixinSequence(firstState);
        for (int i = localMixinSeq.size() - 1; i > 0; --i) {
            ItemState item = localMixinSeq.get(i);
            if (item.getState() == 1) {
                if (item.getData().isNode() && item.getState() == 4) {
                    for (ItemState st : this.generateDeleleLockProperties((NodeData)item.getData())) {
                        resultState.add(st);
                    }
                }
                resultState.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath()));
                continue;
            }
            if (item.getState() != 4) continue;
            resultState.add(new ItemState(item.getData(), 1, item.isEventFire(), item.getData().getQPath()));
        }
        return resultState;
    }

    protected List<ItemState> generateRestoreOrder(ItemState firstState, ChangesStorage<ItemState> storage) throws ClassCastException, IOException, ClassNotFoundException {
        ArrayList<ItemState> resultState = new ArrayList<ItemState>();
        List<ItemState> updateSeq = storage.getUpdateSequence(firstState);
        for (int i = 1; i <= updateSeq.size() - 1; ++i) {
            TransientNodeData newItem;
            QPath name;
            ItemState item = updateSeq.get(i);
            NodeData node = (NodeData)item.getData();
            if (i == 1) {
                resultState.add(new ItemState(item.getData(), 4, item.isEventFire(), item.getData().getQPath(), item.isInternallyCreated(), false));
            } else {
                name = QPath.makeChildPath(node.getQPath().makeParentPath(), node.getQPath().getName(), node.getQPath().getIndex() - 1);
                newItem = new TransientNodeData(name, node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
                resultState.add(new ItemState(newItem, 2, item.isEventFire(), name, item.isInternallyCreated()));
            }
            if (i != updateSeq.size() - 1) continue;
            item = updateSeq.get(1);
            node = (NodeData)item.getData();
            name = QPath.makeChildPath(node.getQPath().makeParentPath(), node.getQPath().getName(), updateSeq.size() - 1);
            newItem = new TransientNodeData(name, node.getIdentifier(), node.getPersistedVersion(), node.getPrimaryTypeName(), node.getMixinTypeNames(), node.getOrderNumber(), node.getParentIdentifier(), node.getACL());
            resultState.add(new ItemState(newItem, 2, item.isEventFire(), name, item.isInternallyCreated()));
        }
        return resultState;
    }

    protected boolean isPropertyAllowed(InternalQName propertyName, NodeData parent) {
        PropertyDefinitionDatas pdef = this.ntManager.findPropertyDefinitions(propertyName, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        return pdef != null;
    }

    protected boolean isOrderRestored(List<QPath> restoredOrder, QPath path) {
        for (QPath inPath : restoredOrder) {
            if (!inPath.equals(path)) continue;
            return true;
        }
        return false;
    }

    protected boolean isNodeRenamed(List<QPath> restoredOrder, QPath path) {
        for (QPath inPath : restoredOrder) {
            if (!inPath.equals(path) && !path.isDescendantOf(inPath)) continue;
            return true;
        }
        return false;
    }

    protected void accumulateSkippedList(ItemState firstState, QPath rootPath, ChangesStorage<ItemState> storage, List<QPath> skippedList) throws ClassCastException, IOException, ClassNotFoundException {
        for (ItemState item : storage.getTreeChanges(firstState, rootPath)) {
            QPath skippedPath;
            skippedList.add(item.getData().getQPath());
            if (!item.getData().isNode() || (skippedPath = storage.findNodeInVS(item.getData().getIdentifier())) == null) continue;
            skippedList.add(skippedPath);
        }
    }
}

