/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;

public class PropertyImpl
extends ItemImpl
implements Property {
    protected int type;
    private PropertyDefinitionData propertyDef;
    private TransientPropertyData propertyData;

    PropertyImpl(ItemData data, SessionImpl session) throws RepositoryException, ConstraintViolationException {
        super(data, session);
        this.loadData(data);
    }

    void loadData(ItemData data) throws RepositoryException, ConstraintViolationException {
        if (!(data instanceof TransientPropertyData)) {
            throw new RepositoryException("Load data: TransientPropertyData is expected, but have " + data);
        }
        this.data = data;
        this.propertyData = (TransientPropertyData)data;
        this.type = this.propertyData.getType();
        this.location = this.session.getLocationFactory().createJCRPath(this.getData().getQPath());
        this.propertyDef = null;
        this.initDefinitions(this.propertyData.isMultiValued());
    }

    public Value getValue() throws ValueFormatException, RepositoryException {
        this.checkValid();
        if (this.isMultiValued()) {
            throw new ValueFormatException("The property " + this.getPath() + " is multi-valued (6.2.4)");
        }
        if (this.propertyData.getValues() != null && this.propertyData.getValues().size() == 0) {
            throw new ValueFormatException("The single valued property " + this.getPath() + " is empty");
        }
        return this.valueFactory.loadValue((TransientValueData)this.propertyData.getValues().get(0), this.propertyData.getType());
    }

    public Value[] getValues() throws ValueFormatException, RepositoryException {
        this.checkValid();
        if (!this.isMultiValued()) {
            throw new ValueFormatException("The property " + this.getPath() + " is single-valued (6.2.4)");
        }
        return this.getValueArray();
    }

    public String getString() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getString();
        }
        catch (ValueFormatException e) {
            throw new ValueFormatException("PropertyImpl.getString() for " + this.getPath() + " failed: " + e);
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getString() for " + this.getPath() + " failed: " + e);
        }
    }

    public double getDouble() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getDouble();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getDouble() failed: " + e);
        }
    }

    public long getLong() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getLong();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getLong() failed: " + e);
        }
    }

    public InputStream getStream() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getStream();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getStream() failed: " + e);
        }
    }

    public Calendar getDate() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getDate();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getDate() failed: " + e);
        }
    }

    public boolean getBoolean() throws ValueFormatException, RepositoryException {
        try {
            return this.getValue().getBoolean();
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getBoolean() failed: " + e);
        }
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        try {
            String identifier = ((BaseValue)this.getValue()).getReference();
            return this.session.getNodeByUUID(identifier);
        }
        catch (IllegalStateException e) {
            throw new ValueFormatException("PropertyImpl.getNode() failed: " + e);
        }
    }

    public long getLength() throws ValueFormatException, RepositoryException {
        return ((BaseValue)this.getValue()).getLength();
    }

    public long[] getLengths() throws ValueFormatException, RepositoryException {
        Value[] thisValues = this.getValues();
        long[] lengths = new long[thisValues.length];
        for (int i = 0; i < lengths.length; ++i) {
            lengths[i] = ((BaseValue)thisValues[i]).getLength();
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        this.checkValid();
        if (this.propertyDef == null) {
            throw new RepositoryException("FATAL: property definition is NULL " + this.getPath() + " " + this.propertyData.getValues());
        }
        String name = this.locationFactory.createJCRName(this.propertyDef.getName() != null ? this.propertyDef.getName() : Constants.JCR_ANY_NAME).getAsString();
        ExtendedNodeTypeManager nodeTypeManager = (ExtendedNodeTypeManager)this.session.getWorkspace().getNodeTypeManager();
        Value[] defaultValues = new Value[this.propertyDef.getDefaultValues().length];
        String[] propVal = this.propertyDef.getDefaultValues();
        if (propVal != null) {
            for (int i = 0; i < propVal.length; ++i) {
                defaultValues[i] = this.propertyDef.getRequiredType() == 0 ? this.valueFactory.createValue(propVal[i]) : this.valueFactory.createValue(propVal[i], this.propertyDef.getRequiredType());
            }
        }
        return new PropertyDefinitionImpl(name, nodeTypeManager.findNodeType(this.propertyDef.getDeclaringNodeType()), this.propertyDef.getRequiredType(), this.propertyDef.getValueConstraints(), defaultValues, this.propertyDef.isAutoCreated(), this.propertyDef.isMandatory(), this.propertyDef.getOnParentVersion(), this.propertyDef.isProtected(), this.propertyDef.isMultiple());
    }

    private void initDefinitions(boolean multiple) throws RepositoryException, ConstraintViolationException {
        NodeData parent = this.parentData();
        InternalQName pname = this.getData().getQPath().getName();
        PropertyDefinitionDatas definitions = this.session.getWorkspace().getNodeTypesHolder().findPropertyDefinitions(pname, parent.getPrimaryTypeName(), parent.getMixinTypeNames());
        if (definitions == null) {
            throw new ConstraintViolationException("Definition for property " + this.getPath() + " not found.");
        }
        this.propertyDef = definitions.getDefinition(multiple);
    }

    public int getType() {
        return this.type;
    }

    public void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        this.doUpdateProperty(this.parent(), this.getInternalName(), value, false, 0);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.checkValid();
        this.doUpdateProperty(this.parent(), this.getInternalName(), values, true, 0);
    }

    public boolean isMultiValued() {
        return ((PropertyData)this.data).isMultiValued();
    }

    public void setValue(String value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(value));
    }

    public void setValue(InputStream stream) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(stream));
    }

    public void setValue(double number) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(number));
    }

    public void setValue(long number) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(number));
    }

    public void setValue(Calendar date) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(date));
    }

    public void setValue(boolean b) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(b));
    }

    public void setValue(Node value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.valueFactory.createValue(value));
    }

    public void setValue(String[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        Value[] strValues = null;
        if (values != null) {
            strValues = new Value[values.length];
            for (int i = 0; i < values.length; ++i) {
                strValues[i] = this.valueFactory.createValue(values[i]);
            }
        }
        this.setValue(strValues);
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.checkValid();
        visitor.visit(this);
    }

    public boolean isNode() {
        return false;
    }

    public Value[] getValueArray() throws RepositoryException {
        Value[] values = new Value[this.propertyData.getValues().size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.valueFactory.loadValue((TransientValueData)this.propertyData.getValues().get(i), this.propertyData.getType());
        }
        return values;
    }

    public String dump() {
        String vals = "Property " + this.getPath() + " values: ";
        try {
            for (int i = 0; i < this.getValueArray().length; ++i) {
                vals = vals + new String(((BaseValue)this.getValueArray()[i]).getInternalData().getAsByteArray()) + ";";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return vals;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PropertyImpl) {
            try {
                return this.getLocation().equals(((PropertyImpl)obj).getLocation());
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int hashCode() {
        try {
            return this.getLocation().getAsString(false).hashCode();
        }
        catch (Exception e) {
            return super.hashCode();
        }
    }
}

