/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.jcr.InvalidItemStateException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValue;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValuesList;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionValue;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLog;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionDataHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataHierarchyHolder;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeDataPersister;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerListener;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.NodeDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.nodetype.registration.PropertyDefinitionComparator;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.value.BaseValue;
import org.exoplatform.services.jcr.impl.core.value.ValueFactoryImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientNodeData;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.dataflow.version.VersionHistoryDataHelper;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeDataManagerImpl
implements NodeTypeDataManager {
    protected static final Log LOG = ExoLogger.getLogger("jcr.NodeTypeDataManagerImpl");
    private static final String NODETYPES_FILE = "nodetypes.xml";
    protected final NamespaceRegistry namespaceRegistry;
    protected final NodeTypeDataPersister persister;
    protected final LocationFactory locationFactory;
    protected final String accessControlPolicy;
    protected final NodeTypeDataHierarchyHolder hierarchy;
    protected final ItemDefinitionDataHolder defsHolder;
    private final Set<InternalQName> buildInNodeTypesNames;
    private final Map<NodeTypeManagerListener, NodeTypeManagerListener> listeners;
    private HashSet<QueryHandler> queryHandlers;
    private final ValueFactoryImpl valueFactory;

    public NodeTypeDataManagerImpl(RepositoryEntry config, LocationFactory locationFactory, NamespaceRegistry namespaceRegistry, NodeTypeDataPersister persister) throws RepositoryException {
        this.namespaceRegistry = namespaceRegistry;
        this.persister = persister;
        this.locationFactory = locationFactory;
        this.valueFactory = new ValueFactoryImpl(locationFactory);
        this.accessControlPolicy = config.getAccessControl();
        this.hierarchy = new NodeTypeDataHierarchyHolder();
        this.defsHolder = new ItemDefinitionDataHolder();
        this.listeners = Collections.synchronizedMap(new WeakHashMap());
        this.buildInNodeTypesNames = new HashSet<InternalQName>();
        this.initDefault();
        this.queryHandlers = new HashSet();
    }

    public void addListener(NodeTypeManagerListener listener) {
        if (!this.listeners.containsKey(listener)) {
            this.listeners.put(listener, listener);
        }
    }

    @Override
    public void addQueryHandler(QueryHandler queryHandler) {
        this.queryHandlers.add(queryHandler);
    }

    @Override
    public NodeDefinitionData findChildNodeDefinition(InternalQName nodeName, InternalQName ... nodeTypeNames) {
        NodeDefinitionData ndResidual = this.defsHolder.getDefaultChildNodeDefinition(nodeName, nodeTypeNames);
        if (ndResidual == null && !Constants.JCR_ANY_NAME.equals(nodeName)) {
            ndResidual = this.findChildNodeDefinition(Constants.JCR_ANY_NAME, nodeTypeNames);
        }
        return ndResidual;
    }

    @Override
    public NodeDefinitionData findChildNodeDefinition(InternalQName nodeName, InternalQName primaryNodeType, InternalQName[] mixinTypes) {
        if (mixinTypes != null) {
            InternalQName[] nts = new InternalQName[mixinTypes.length + 1];
            nts[0] = primaryNodeType;
            for (int i = 0; i < mixinTypes.length; ++i) {
                nts[i + 1] = mixinTypes[i];
            }
            return this.findChildNodeDefinition(nodeName, nts);
        }
        return this.findChildNodeDefinition(nodeName, primaryNodeType);
    }

    @Override
    public NodeTypeData findNodeType(InternalQName typeName) {
        return this.hierarchy.getNodeType(typeName);
    }

    @Override
    public PropertyDefinitionDatas findPropertyDefinitions(InternalQName propertyName, InternalQName primaryNodeType, InternalQName[] mixinTypes) {
        if (mixinTypes != null) {
            InternalQName[] nts = new InternalQName[mixinTypes.length + 1];
            nts[0] = primaryNodeType;
            for (int i = 0; i < mixinTypes.length; ++i) {
                nts[i + 1] = mixinTypes[i];
            }
            return this.getPropertyDefinitions(propertyName, nts);
        }
        return this.getPropertyDefinitions(propertyName, primaryNodeType);
    }

    public String getAccessControlPolicy() {
        return this.accessControlPolicy;
    }

    @Override
    public NodeDefinitionData[] getAllChildNodeDefinitions(InternalQName ... nodeTypeNames) {
        HashSet<NodeDefinitionData> defs = new HashSet<NodeDefinitionData>();
        for (InternalQName ntname : nodeTypeNames) {
            for (NodeDefinitionData cnd : this.hierarchy.getNodeType(ntname).getDeclaredChildNodeDefinitions()) {
                defs.add(cnd);
            }
            for (InternalQName suname : this.hierarchy.getSupertypes(ntname)) {
                for (NodeDefinitionData cnd : this.hierarchy.getNodeType(suname).getDeclaredChildNodeDefinitions()) {
                    defs.add(cnd);
                }
            }
        }
        return defs.toArray(new NodeDefinitionData[defs.size()]);
    }

    @Override
    public List<NodeTypeData> getAllNodeTypes() {
        return this.hierarchy.getAllNodeTypes();
    }

    @Override
    public PropertyDefinitionData[] getAllPropertyDefinitions(InternalQName ... nodeTypeNames) {
        HashSet<PropertyDefinitionData> defs = new HashSet<PropertyDefinitionData>();
        for (InternalQName ntname : nodeTypeNames) {
            for (PropertyDefinitionData pd : this.hierarchy.getNodeType(ntname).getDeclaredPropertyDefinitions()) {
                defs.add(pd);
            }
            for (InternalQName suname : this.hierarchy.getSupertypes(ntname)) {
                for (PropertyDefinitionData pd : this.hierarchy.getNodeType(suname).getDeclaredPropertyDefinitions()) {
                    defs.add(pd);
                }
            }
        }
        return defs.toArray(new PropertyDefinitionData[defs.size()]);
    }

    @Override
    public NodeDefinitionData getChildNodeDefinition(InternalQName nodeName, InternalQName nodeTypeName, InternalQName parentTypeName) {
        NodeDefinitionData def = this.defsHolder.getChildNodeDefinition(parentTypeName, nodeName, nodeTypeName);
        if (def == null) {
            def = this.defsHolder.getChildNodeDefinition(parentTypeName, Constants.JCR_ANY_NAME, nodeTypeName);
        }
        return def;
    }

    @Override
    public Set<InternalQName> getDescendantNodeTypes(InternalQName nodeTypeName) {
        return this.hierarchy.getDescendantNodeTypes(nodeTypeName);
    }

    @Override
    public List<ItemDefinitionData> getManadatoryItemDefs(InternalQName primaryNodeType, InternalQName[] mixinTypes) {
        int i;
        HashSet<ItemDefinitionData> mandatoryDefs = new HashSet<ItemDefinitionData>();
        ItemDefinitionData[] itemDefs = this.getAllPropertyDefinitions(primaryNodeType);
        for (i = 0; i < itemDefs.length; ++i) {
            if (!itemDefs[i].isMandatory()) continue;
            mandatoryDefs.add(itemDefs[i]);
        }
        itemDefs = this.getAllChildNodeDefinitions(primaryNodeType);
        for (i = 0; i < itemDefs.length; ++i) {
            if (!itemDefs[i].isMandatory()) continue;
            mandatoryDefs.add(itemDefs[i]);
        }
        itemDefs = this.getAllPropertyDefinitions(mixinTypes);
        for (i = 0; i < itemDefs.length; ++i) {
            if (!itemDefs[i].isMandatory()) continue;
            mandatoryDefs.add(itemDefs[i]);
        }
        itemDefs = this.getAllChildNodeDefinitions(mixinTypes);
        for (i = 0; i < itemDefs.length; ++i) {
            if (!itemDefs[i].isMandatory()) continue;
            mandatoryDefs.add(itemDefs[i]);
        }
        return new ArrayList<ItemDefinitionData>(mandatoryDefs);
    }

    public Set<String> getNodes(InternalQName nodeType) throws RepositoryException {
        return this.getNodes(nodeType, new InternalQName[0], new InternalQName[0]);
    }

    public Set<String> getNodes(InternalQName nodeType, InternalQName[] includeProperties, InternalQName[] excludeProperties) throws RepositoryException {
        String field;
        int i;
        BooleanQuery tmp;
        Query query = this.getQuery(nodeType);
        if (includeProperties.length > 0) {
            tmp = new BooleanQuery();
            for (i = 0; i < includeProperties.length; ++i) {
                field = this.locationFactory.createJCRName(includeProperties[i]).getAsString();
                tmp.add(new TermQuery(new Term(FieldNames.PROPERTIES_SET, field)), BooleanClause.Occur.MUST);
            }
            tmp.add(query, BooleanClause.Occur.MUST);
            query = tmp;
        }
        if (excludeProperties.length > 0) {
            tmp = new BooleanQuery();
            for (i = 0; i < excludeProperties.length; ++i) {
                field = this.locationFactory.createJCRName(excludeProperties[i]).getAsString();
                tmp.add(new TermQuery(new Term(FieldNames.PROPERTIES_SET, field)), BooleanClause.Occur.MUST_NOT);
            }
            tmp.add(query, BooleanClause.Occur.MUST);
            query = tmp;
        }
        Iterator<QueryHandler> it = this.queryHandlers.iterator();
        HashSet<String> result = new HashSet<String>();
        try {
            while (it.hasNext()) {
                QueryHandler queryHandler = it.next();
                QueryHits hits = queryHandler.executeQuery(query, true, new InternalQName[0], new boolean[0]);
                for (int i2 = 0; i2 < hits.length(); ++i2) {
                    result.add(hits.getFieldContent(i2, FieldNames.UUID));
                }
            }
        }
        catch (IOException e) {
            throw new RepositoryException(e.getLocalizedMessage(), e);
        }
        return result;
    }

    @Override
    public PropertyDefinitionDatas getPropertyDefinitions(InternalQName propertyName, InternalQName ... nodeTypeNames) {
        PropertyDefinitionDatas propertyDefinitions = this.defsHolder.getPropertyDefinitions(propertyName, nodeTypeNames);
        if (propertyDefinitions == null) {
            for (int i = 0; i < nodeTypeNames.length && propertyDefinitions == null; ++i) {
                InternalQName[] supers = this.hierarchy.getNodeType(nodeTypeNames[i]).getDeclaredSupertypeNames();
                propertyDefinitions = this.getPropertyDefinitions(propertyName, supers);
            }
        }
        if (propertyDefinitions == null && !propertyName.equals(Constants.JCR_ANY_NAME)) {
            propertyDefinitions = this.getPropertyDefinitions(Constants.JCR_ANY_NAME, nodeTypeNames);
        }
        return propertyDefinitions;
    }

    public Set<QueryHandler> getQueryHandlers() {
        return this.queryHandlers;
    }

    @Override
    public boolean isChildNodePrimaryTypeAllowed(InternalQName childNodeTypeName, InternalQName parentNodeType, InternalQName[] parentMixinNames) {
        NodeDefinitionData[] allChildNodeDefinitions;
        Set<InternalQName> testSuperTypesNames = this.hierarchy.getSupertypes(childNodeTypeName);
        for (NodeDefinitionData cnd : allChildNodeDefinitions = this.getAllChildNodeDefinitions(parentNodeType)) {
            for (InternalQName req : cnd.getRequiredPrimaryTypes()) {
                if (childNodeTypeName.equals(req)) {
                    return true;
                }
                for (InternalQName superName : testSuperTypesNames) {
                    if (!superName.equals(req)) continue;
                    return true;
                }
            }
        }
        for (NodeDefinitionData cnd : allChildNodeDefinitions = this.getAllChildNodeDefinitions(parentMixinNames)) {
            for (InternalQName req : cnd.getRequiredPrimaryTypes()) {
                if (childNodeTypeName.equals(req)) {
                    return true;
                }
                for (InternalQName superName : testSuperTypesNames) {
                    if (!superName.equals(req)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isNodeType(InternalQName testTypeName, InternalQName ... typesNames) {
        return this.hierarchy.isNodeType(testTypeName, typesNames);
    }

    @Override
    public boolean isNodeType(InternalQName testTypeName, InternalQName primaryType, InternalQName[] mixinTypes) {
        if (this.hierarchy.isNodeType(testTypeName, primaryType)) {
            return true;
        }
        return this.hierarchy.isNodeType(testTypeName, mixinTypes);
    }

    @Override
    public boolean isOrderableChildNodesSupported(InternalQName primaryType, InternalQName[] mixinTypes) {
        int nlen = mixinTypes != null ? mixinTypes.length : 0;
        for (int i = -1; i < nlen; ++i) {
            InternalQName name = i < 0 ? primaryType : mixinTypes[i];
            NodeTypeData nt = this.hierarchy.getNodeType(name);
            if (nt == null) continue;
            if (nt.hasOrderableChildNodes()) {
                return true;
            }
            Set<InternalQName> supers = this.hierarchy.getSupertypes(nt.getName());
            for (InternalQName suName : supers) {
                NodeTypeData su = this.hierarchy.getNodeType(suName);
                if (su == null || !su.hasOrderableChildNodes()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PlainChangesLog makeAutoCreatedItems(NodeData parent, InternalQName nodeTypeName, ItemDataConsumer dataManager, String owner) throws RepositoryException {
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        NodeTypeData type = this.findNodeType(nodeTypeName);
        changes.addAll(this.makeAutoCreatedProperties(parent, nodeTypeName, this.getAllPropertyDefinitions(nodeTypeName), dataManager, owner).getAllStates());
        changes.addAll(this.makeAutoCreatedNodes(parent, this.getAllChildNodeDefinitions(nodeTypeName), dataManager, owner).getAllStates());
        if (this.isNodeType(Constants.MIX_VERSIONABLE, type.getName())) {
            this.makeMixVesionableChanges(parent, dataManager, changes);
        }
        return changes;
    }

    public PlainChangesLog makeAutoCreatedNodes(NodeData parent, NodeDefinitionData[] nodeDefs, ItemDataConsumer dataManager, String owner) throws RepositoryException {
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        for (NodeDefinitionData ndef : nodeDefs) {
            if (!ndef.isAutoCreated()) continue;
            TransientNodeData childNodeData = TransientNodeData.createNodeData(parent, ndef.getName(), ndef.getDefaultPrimaryType(), IdGenerator.generate());
            changes.add(ItemState.createAddedState(childNodeData));
            this.makeAutoCreatedItems(childNodeData, childNodeData.getPrimaryTypeName(), dataManager, owner);
        }
        return changes;
    }

    public PlainChangesLog makeAutoCreatedProperties(NodeData parent, InternalQName typeName, PropertyDefinitionData[] propDefs, ItemDataConsumer dataManager, String owner) throws RepositoryException {
        PlainChangesLogImpl changes = new PlainChangesLogImpl();
        HashSet<InternalQName> addedProperties = new HashSet<InternalQName>();
        for (PropertyDefinitionData pdef : propDefs) {
            if (!pdef.isAutoCreated()) continue;
            ItemData pdata = dataManager.getItemData(parent, new QPathEntry(pdef.getName(), 0));
            if (pdata == null && !addedProperties.contains(pdef.getName()) || pdata != null && pdata.isNode()) {
                List<ValueData> listAutoCreateValue = this.autoCreatedValue(parent, typeName, pdef, owner);
                if (listAutoCreateValue == null) continue;
                TransientPropertyData propertyData = TransientPropertyData.createPropertyData(parent, pdef.getName(), pdef.getRequiredType(), pdef.isMultiple(), listAutoCreateValue);
                changes.add(ItemState.createAddedState(propertyData));
                addedProperties.add(pdef.getName());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Skipping existed property " + pdef.getName() + " in " + parent.getQPath().getAsString() + "   during the automatic creation of items for " + typeName.getAsString() + " nodetype or mixin type");
        }
        return changes;
    }

    @Override
    public List<NodeTypeData> registerNodeTypes(InputStream xml, int alreadyExistsBehaviour) throws RepositoryException {
        try {
            IBindingFactory factory = BindingDirectory.getFactory(NodeTypeValuesList.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            NodeTypeValuesList nodeTypeValuesList = (NodeTypeValuesList)uctx.unmarshalDocument(xml, null);
            ArrayList ntvList = nodeTypeValuesList.getNodeTypeValuesList();
            long start = System.currentTimeMillis();
            ArrayList<NodeTypeValue> nts = new ArrayList<NodeTypeValue>();
            for (int i = 0; i < ntvList.size(); ++i) {
                if (ntvList.get(i) != null) {
                    NodeTypeValue nodeTypeValue = (NodeTypeValue)ntvList.get(i);
                    nts.add(nodeTypeValue);
                    continue;
                }
                LOG.error("Empty nodeTypeValue in xml document, index: " + i + ", skiping...");
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Nodetypes registered from xml definitions (count: " + ntvList.size() + "). " + (System.currentTimeMillis() - start) + " ms.");
            }
            return this.registerNodeTypes(nts, alreadyExistsBehaviour);
        }
        catch (JiBXException e) {
            throw new RepositoryException("Error in config initialization " + e, e);
        }
    }

    @Override
    public List<NodeTypeData> registerNodeTypes(List<NodeTypeValue> ntvalues, int alreadyExistsBehaviour) throws RepositoryException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        Map<InternalQName, NodeTypeData> nodeTypeDataList = this.parseNodeTypes(ntvalues);
        for (NodeTypeData nodeTypeData : nodeTypeDataList.values()) {
            changesLog.addAll(this.registerNodeType(nodeTypeData, alreadyExistsBehaviour, nodeTypeDataList).getAllStates());
        }
        this.persister.saveChanges(changesLog);
        return new ArrayList<NodeTypeData>(nodeTypeDataList.values());
    }

    public void removeListener(NodeTypeManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void unregisterNodeType(InternalQName nodeTypeName) throws RepositoryException {
        NodeTypeData nodeType = this.hierarchy.getNodeType(nodeTypeName);
        if (nodeType == null) {
            throw new NoSuchNodeTypeException(nodeTypeName.getAsString());
        }
        if (this.buildInNodeTypesNames.contains(nodeTypeName)) {
            throw new RepositoryException(nodeTypeName.toString() + ": can't unregister built-in node type.");
        }
        Set<InternalQName> descendantNt = this.hierarchy.getDescendantNodeTypes(nodeTypeName);
        if (descendantNt.size() > 0) {
            String message = "Can not remove " + nodeTypeName.getAsString() + "nodetype, because the following node types depend on it: ";
            for (InternalQName internalQName : descendantNt) {
                message = message + internalQName.getAsString() + " ";
            }
            throw new RepositoryException(message);
        }
        Set<String> nodes = this.getNodes(nodeTypeName);
        if (nodes.size() > 0) {
            String message = "Can not remove " + nodeTypeName.getAsString() + " nodetype, because the following node types is used in nodes with uuid: ";
            for (String uuids : nodes) {
                message = message + uuids + " ";
            }
            throw new RepositoryException(message);
        }
        this.internalUnregister(nodeTypeName, nodeType);
    }

    protected Map<InternalQName, NodeTypeData> parseNodeTypes(List<NodeTypeValue> ntvalues) throws RepositoryException {
        HashMap<InternalQName, NodeTypeData> nodeTypeDataList = new HashMap<InternalQName, NodeTypeData>();
        for (NodeTypeValue ntvalue : ntvalues) {
            List<String> nsupertypes;
            if (this.accessControlPolicy.equals("disable") && ((nsupertypes = ntvalue.getDeclaredSupertypeNames()) != null && nsupertypes.contains("exo:privilegeable") || ntvalue.getName().equals("exo:privilegeable"))) {
                LOG.warn("Node type " + ntvalue.getName() + " is not register due to DISABLE control policy");
                return null;
            }
            ntvalue.validateNodeType();
            InternalQName ntName = this.locationFactory.parseJCRName(ntvalue.getName()).getInternalName();
            List<String> stlist = ntvalue.getDeclaredSupertypeNames();
            InternalQName[] supertypes = new InternalQName[stlist.size()];
            for (int i = 0; i < stlist.size(); ++i) {
                supertypes[i] = this.locationFactory.parseJCRName(stlist.get(i)).getInternalName();
            }
            List<PropertyDefinitionValue> pdlist = ntvalue.getDeclaredPropertyDefinitionValues();
            PropertyDefinitionData[] props = new PropertyDefinitionData[pdlist.size()];
            for (int i = 0; i < pdlist.size(); ++i) {
                PropertyDefinitionData pd;
                PropertyDefinitionValue v = pdlist.get(i);
                props[i] = pd = new PropertyDefinitionData(this.locationFactory.parseJCRName(v.getName()).getInternalName(), ntName, v.isAutoCreate(), v.isMandatory(), v.getOnVersion(), v.isReadOnly(), v.getRequiredType(), v.getValueConstraints() != null ? v.getValueConstraints().toArray(new String[v.getValueConstraints().size()]) : new String[]{}, v.getDefaultValueStrings() == null ? new String[]{} : v.getDefaultValueStrings().toArray(new String[v.getDefaultValueStrings().size()]), v.isMultiple());
            }
            List<NodeDefinitionValue> ndlist = ntvalue.getDeclaredChildNodeDefinitionValues();
            NodeDefinitionData[] nodes = new NodeDefinitionData[ndlist.size()];
            for (int i = 0; i < ndlist.size(); ++i) {
                NodeDefinitionData nd;
                NodeDefinitionValue v = ndlist.get(i);
                List<String> rnts = v.getRequiredNodeTypeNames();
                InternalQName[] requiredNTs = new InternalQName[rnts.size()];
                for (int ri = 0; ri < rnts.size(); ++ri) {
                    requiredNTs[ri] = this.locationFactory.parseJCRName(rnts.get(ri)).getInternalName();
                }
                InternalQName defaultNodeName = null;
                if (v.getDefaultNodeTypeName() != null) {
                    defaultNodeName = this.locationFactory.parseJCRName(v.getDefaultNodeTypeName()).getInternalName();
                }
                nodes[i] = nd = new NodeDefinitionData(this.locationFactory.parseJCRName(v.getName()).getInternalName(), ntName, v.isAutoCreate(), v.isMandatory(), v.getOnVersion(), v.isReadOnly(), requiredNTs, defaultNodeName, v.isSameNameSiblings());
            }
            InternalQName primaryItemName = null;
            if (ntvalue.getPrimaryItemName() != null) {
                primaryItemName = this.locationFactory.parseJCRName(ntvalue.getPrimaryItemName()).getInternalName();
            }
            NodeTypeData nodeTypeData = new NodeTypeData(ntName, primaryItemName, ntvalue.isMixin(), ntvalue.isOrderableChild(), supertypes, props, nodes);
            this.validateNodeType(nodeTypeData);
            nodeTypeDataList.put(nodeTypeData.getName(), nodeTypeData);
        }
        this.checkCyclicDependencies(nodeTypeDataList);
        return nodeTypeDataList;
    }

    protected void validateNodeType(NodeTypeData nodeType) throws RepositoryException {
        int i;
        if (nodeType == null) {
            throw new RepositoryException("NodeType object " + nodeType + " is null");
        }
        for (i = 0; i < nodeType.getDeclaredSupertypeNames().length; ++i) {
            if (!nodeType.getName().equals(nodeType.getDeclaredSupertypeNames()[i])) continue;
            throw new RepositoryException("Invalid super type name" + nodeType.getDeclaredSupertypeNames()[i].getAsString());
        }
        for (i = 0; i < nodeType.getDeclaredPropertyDefinitions().length; ++i) {
            if (nodeType.getDeclaredPropertyDefinitions()[i].getDeclaringNodeType().equals(nodeType.getName())) continue;
            throw new RepositoryException("Invalid declared  node type in property definitions with name " + nodeType.getDeclaredPropertyDefinitions()[i].getName().getAsString() + " not registred");
        }
        for (i = 0; i < nodeType.getDeclaredChildNodeDefinitions().length; ++i) {
            if (nodeType.getDeclaredChildNodeDefinitions()[i].getDeclaringNodeType().equals(nodeType.getName())) continue;
            throw new RepositoryException("Invalid declared  node type in child node definitions with name " + nodeType.getDeclaredChildNodeDefinitions()[i].getName().getAsString() + " not registred");
        }
        if (nodeType.getName() == null) {
            throw new RepositoryException("NodeType implementation class " + nodeType.getClass().getName() + " is not supported in this method");
        }
    }

    private List<ValueData> autoCreatedValue(NodeData parent, InternalQName typeName, PropertyDefinitionData def, String owner) throws RepositoryException {
        NodeTypeDataManagerImpl typeDataManager = this;
        ArrayList<ValueData> vals = new ArrayList<ValueData>();
        if (typeDataManager.isNodeType(Constants.NT_BASE, typeName) && def.getName().equals(Constants.JCR_PRIMARYTYPE)) {
            vals.add(new TransientValueData(parent.getPrimaryTypeName()));
        } else if (typeDataManager.isNodeType(Constants.MIX_REFERENCEABLE, typeName) && def.getName().equals(Constants.JCR_UUID)) {
            vals.add(new TransientValueData(parent.getIdentifier()));
        } else if (typeDataManager.isNodeType(Constants.NT_HIERARCHYNODE, typeName) && def.getName().equals(Constants.JCR_CREATED)) {
            vals.add(new TransientValueData(Calendar.getInstance()));
        } else if (typeDataManager.isNodeType(Constants.EXO_OWNEABLE, typeName) && def.getName().equals(Constants.EXO_OWNER)) {
            vals.add(new TransientValueData(owner));
            parent.setACL(new AccessControlList(owner, parent.getACL().getPermissionEntries()));
        } else if (typeDataManager.isNodeType(Constants.EXO_PRIVILEGEABLE, typeName) && def.getName().equals(Constants.EXO_PERMISSIONS)) {
            for (AccessControlEntry ace : parent.getACL().getPermissionEntries()) {
                vals.add(new TransientValueData(ace));
            }
        } else {
            String[] propVal = def.getDefaultValues();
            if (propVal != null && propVal.length != 0) {
                for (String v : propVal) {
                    if (v != null) {
                        if (def.getRequiredType() == 0) {
                            vals.add(((BaseValue)this.valueFactory.createValue(v)).getInternalData());
                            continue;
                        }
                        vals.add(((BaseValue)this.valueFactory.createValue(v, def.getRequiredType())).getInternalData());
                        continue;
                    }
                    vals.add(null);
                }
            } else {
                return null;
            }
        }
        return vals;
    }

    private void checkCyclicDependencies(Map<InternalQName, NodeTypeData> nodeTypeDataList) throws RepositoryException {
        HashSet<InternalQName> unresolvedDependecies = new HashSet<InternalQName>();
        HashSet<InternalQName> resolvedDependecies = new HashSet<InternalQName>();
        for (Map.Entry<InternalQName, NodeTypeData> entry : nodeTypeDataList.entrySet()) {
            int i;
            NodeTypeData nodeTypeData = entry.getValue();
            resolvedDependecies.add(nodeTypeData.getName());
            unresolvedDependecies.remove(nodeTypeData.getName());
            for (i = 0; i < nodeTypeData.getDeclaredSupertypeNames().length; ++i) {
                InternalQName superName = nodeTypeData.getDeclaredSupertypeNames()[i];
                if (this.hierarchy.getNodeType(superName) != null || resolvedDependecies.contains(superName)) continue;
                unresolvedDependecies.add(superName);
            }
            for (i = 0; i < nodeTypeData.getDeclaredChildNodeDefinitions().length; ++i) {
                NodeDefinitionData childnodeDefinitionData = nodeTypeData.getDeclaredChildNodeDefinitions()[i];
                for (int j = 0; j < childnodeDefinitionData.getRequiredPrimaryTypes().length; ++j) {
                    InternalQName requiredPrimaryTypeName = childnodeDefinitionData.getRequiredPrimaryTypes()[j];
                    if (this.hierarchy.getNodeType(requiredPrimaryTypeName) != null || resolvedDependecies.contains(requiredPrimaryTypeName)) continue;
                    unresolvedDependecies.add(requiredPrimaryTypeName);
                }
                if (childnodeDefinitionData.getDefaultPrimaryType() == null || this.hierarchy.getNodeType(childnodeDefinitionData.getDefaultPrimaryType()) != null || resolvedDependecies.contains(childnodeDefinitionData.getDefaultPrimaryType())) continue;
                unresolvedDependecies.add(childnodeDefinitionData.getDefaultPrimaryType());
            }
        }
        if (unresolvedDependecies.size() > 0) {
            String msg = "Fail. Unresolved cyclic dependecy for :";
            for (InternalQName internalQName : resolvedDependecies) {
                msg = msg + " " + internalQName.getAsString();
            }
            throw new RepositoryException(msg);
        }
    }

    private NodeDefinitionData[] getAllChildNodeDefinitions(NodeTypeData nodeType) throws RepositoryException {
        HashSet<NodeDefinitionData> defs = new HashSet<NodeDefinitionData>();
        for (NodeDefinitionData cnd : nodeType.getDeclaredChildNodeDefinitions()) {
            defs.add(cnd);
        }
        for (InternalQName suname : nodeType.getDeclaredSupertypeNames()) {
            for (NodeDefinitionData cnd : this.hierarchy.getNodeType(suname).getDeclaredChildNodeDefinitions()) {
                defs.add(cnd);
            }
        }
        return defs.toArray(new NodeDefinitionData[defs.size()]);
    }

    private PropertyDefinitionData[] getAllPropertyDefinitions(NodeTypeData nodeType) {
        HashSet<PropertyDefinitionData> defs = new HashSet<PropertyDefinitionData>();
        for (PropertyDefinitionData pd : nodeType.getDeclaredPropertyDefinitions()) {
            defs.add(pd);
        }
        for (InternalQName suname : nodeType.getDeclaredSupertypeNames()) {
            for (PropertyDefinitionData pd : this.hierarchy.getNodeType(suname).getDeclaredPropertyDefinitions()) {
                defs.add(pd);
            }
        }
        return defs.toArray(new PropertyDefinitionData[defs.size()]);
    }

    private Query getQuery(InternalQName nodeType) throws RepositoryException {
        Term t;
        ArrayList<Term> terms = new ArrayList<Term>();
        String mixinTypesField = this.locationFactory.createJCRName(Constants.JCR_MIXINTYPES).getAsString();
        String primaryTypeField = this.locationFactory.createJCRName(Constants.JCR_PRIMARYTYPE).getAsString();
        NodeTypeData base = this.findNodeType(nodeType);
        if (base.isMixin()) {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, this.locationFactory.createJCRName(nodeType).getAsString()));
            terms.add(t);
        } else {
            t = new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, this.locationFactory.createJCRName(nodeType).getAsString()));
            terms.add(t);
        }
        Iterator<InternalQName> allTypes = this.hierarchy.getDescendantNodeTypes(nodeType).iterator();
        while (allTypes.hasNext()) {
            NodeTypeData nodeTypeData = this.findNodeType(allTypes.next());
            String ntName = this.locationFactory.createJCRName(nodeTypeData.getName()).getAsString();
            Term t2 = nodeTypeData.isMixin() ? new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(mixinTypesField, ntName)) : new Term(FieldNames.PROPERTIES, FieldNames.createNamedValue(primaryTypeField, ntName));
            terms.add(t2);
        }
        if (terms.size() == 0) {
            return new BooleanQuery();
        }
        if (terms.size() == 1) {
            return new TermQuery((Term)terms.get(0));
        }
        BooleanQuery b = new BooleanQuery();
        for (Term term : terms) {
            b.add(new TermQuery(term), BooleanClause.Occur.SHOULD);
        }
        return b;
    }

    private void initDefault() throws RepositoryException {
        long start = System.currentTimeMillis();
        try {
            try {
                InputStream xml = NodeTypeManagerImpl.class.getResourceAsStream(NODETYPES_FILE);
                if (xml != null) {
                    List<NodeTypeData> registerNodeTypes = this.registerNodeTypes(xml, 0);
                    for (NodeTypeData nodeTypeData : registerNodeTypes) {
                        this.buildInNodeTypesNames.add(nodeTypeData.getName());
                    }
                } else {
                    String msg = "Resource file 'nodetypes.xml' with NodeTypes configuration does not found. Can not create node type manager";
                    LOG.error(msg);
                    throw new RepositoryException(msg);
                }
                Object var8_9 = null;
                LOG.info("Initialization of default nodetypes done. " + (System.currentTimeMillis() - start) + " ms.");
            }
            catch (RepositoryException e) {
                String msg = "Error of initialization default types. Resource file with NodeTypes configuration 'nodetypes.xml'. " + e;
                LOG.error(msg);
                throw new RepositoryException(msg, e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            LOG.info("Initialization of default nodetypes done. " + (System.currentTimeMillis() - start) + " ms.");
            throw throwable;
        }
    }

    private void internalRegister(NodeTypeData nodeType, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws PathNotFoundException, ValueFormatException, RepositoryException {
        this.hierarchy.addNodeType(nodeType, volatileNodeTypes);
        this.defsHolder.putDefinitions(nodeType.getName(), nodeType);
        Set<InternalQName> supers = this.hierarchy.getSupertypes(nodeType.getName(), volatileNodeTypes);
        for (InternalQName superName : supers) {
            this.defsHolder.putDefinitions(nodeType.getName(), this.hierarchy.getNodeType(superName, volatileNodeTypes));
        }
    }

    private void internalUnregister(InternalQName nodeTypeName, NodeTypeData nodeType) throws RepositoryException {
        Set<InternalQName> supers = this.hierarchy.getSupertypes(nodeTypeName);
        this.hierarchy.removeNodeType(nodeTypeName);
        if (supers != null) {
            for (InternalQName superName : supers) {
                this.defsHolder.removeDefinitions(nodeTypeName, this.hierarchy.getNodeType(superName));
            }
        }
        this.defsHolder.removeDefinitions(nodeTypeName, nodeType);
    }

    private void makeMixVesionableChanges(NodeData parent, ItemDataConsumer dataManager, PlainChangesLog changes) throws RepositoryException {
        new VersionHistoryDataHelper(parent, changes, dataManager, this);
    }

    private void notifyRegistered(InternalQName ntName) {
        NodeTypeManagerListener[] la = this.listeners.values().toArray(new NodeTypeManagerListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeRegistered(ntName);
        }
    }

    private void notifyReRegistered(InternalQName ntName) {
        NodeTypeManagerListener[] la = this.listeners.values().toArray(new NodeTypeManagerListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeReRegistered(ntName);
        }
    }

    private void notifyUnregistered(InternalQName ntName) {
        NodeTypeManagerListener[] la = this.listeners.values().toArray(new NodeTypeManagerListener[this.listeners.size()]);
        for (int i = 0; i < la.length; ++i) {
            if (la[i] == null) continue;
            la[i].nodeTypeUnregistered(ntName);
        }
    }

    private PlainChangesLog persistNodeTypeData(NodeTypeData nodeType, boolean checkExistence) throws RepositoryException, PathNotFoundException, ValueFormatException {
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        long start = System.currentTimeMillis();
        if (this.persister.isInitialized()) {
            try {
                if (!checkExistence || !this.persister.hasNodeTypeData(nodeType.getName())) {
                    changesLog.addAll(this.persister.addNodeType(nodeType).getAllStates());
                }
            }
            catch (InvalidItemStateException e) {
                LOG.warn("Error of storing node type " + nodeType.getName() + ". May be node type already registered .", e);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("NodeType " + nodeType.getName() + " initialized. " + (System.currentTimeMillis() - start) + " ms");
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("NodeType " + nodeType.getName() + " registered but not initialized (storage is not initialized). " + (System.currentTimeMillis() - start) + " ms");
        }
        return changesLog;
    }

    private PlainChangesLog registerNodeType(NodeTypeData nodeType, int alreadyExistsBehaviour, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws RepositoryException {
        if (nodeType == null) {
            throw new RepositoryException("NodeTypeData object " + nodeType + " is null");
        }
        long start = System.currentTimeMillis();
        if (this.accessControlPolicy.equals("disable") && nodeType.getName().equals("exo:privilegeable")) {
            throw new RepositoryException("NodeType exo:privilegeable is DISABLED");
        }
        InternalQName qname = nodeType.getName();
        if (qname == null) {
            throw new RepositoryException("NodeType implementation class " + nodeType.getClass().getName() + " is not supported in this method");
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        NodeTypeData registeredNodeType = this.findNodeType(qname);
        if (registeredNodeType != null) {
            switch (alreadyExistsBehaviour) {
                case 2: {
                    throw new RepositoryException("NodeType " + nodeType.getName() + " is already registered");
                }
                case 0: {
                    LOG.warn("Skipped " + nodeType.getName().getAsString() + " as already registered");
                    break;
                }
                case 4: {
                    changesLog.addAll(this.reregisterNodeType(registeredNodeType, nodeType, volatileNodeTypes).getAllStates());
                }
            }
        } else {
            this.internalRegister(nodeType, volatileNodeTypes);
            changesLog.addAll(this.persistNodeTypeData(nodeType, true).getAllStates());
        }
        return changesLog;
    }

    private List<ItemState> removePersistedNodeType(NodeTypeData nodeType) throws RepositoryException {
        return this.persister.removeNodeType(nodeType);
    }

    private PlainChangesLog reregisterNodeType(NodeTypeData ancestorDefinition, NodeTypeData recipientDefinition, Map<InternalQName, NodeTypeData> volatileNodeTypes) throws ConstraintViolationException, RepositoryException {
        if (!ancestorDefinition.getName().equals(recipientDefinition.getName())) {
            throw new RepositoryException("Unsupported Operation");
        }
        if (this.buildInNodeTypesNames.contains(recipientDefinition.getName())) {
            throw new RepositoryException(recipientDefinition.getName() + ": can't reregister built-in node type.");
        }
        PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
        Set<String> nodes = this.getNodes(recipientDefinition.getName());
        if (this.isNodeType(Constants.MIX_VERSIONABLE, recipientDefinition.getDeclaredSupertypeNames()) && !this.isNodeType(Constants.MIX_VERSIONABLE, ancestorDefinition.getDeclaredSupertypeNames())) {
            for (String uuid : nodes) {
                ItemData item = this.persister.getDataManager().getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                this.makeMixVesionableChanges((NodeData)item, this.persister.getDataManager(), changesLog);
            }
        } else if (!this.isNodeType(Constants.MIX_VERSIONABLE, recipientDefinition.getDeclaredSupertypeNames()) && this.isNodeType(Constants.MIX_VERSIONABLE, ancestorDefinition.getDeclaredSupertypeNames()) && nodes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to change ");
            buffer.append(recipientDefinition.getName().getAsString());
            buffer.append(" node type from mix:versionable = true  to mix:versionable = false");
            buffer.append(" because the folowing node exists: ");
            for (String uuid : nodes) {
                ItemData item = this.persister.getDataManager().getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                buffer.append(item.getQPath().getAsString());
                buffer.append(" ");
            }
            throw new ConstraintViolationException(buffer.toString());
        }
        NodeDefinitionComparator nodeDefinitionComparator = new NodeDefinitionComparator(this, this.persister.getDataManager());
        changesLog.addAll(nodeDefinitionComparator.compare(recipientDefinition, this.getAllChildNodeDefinitions(ancestorDefinition), this.getAllChildNodeDefinitions(recipientDefinition)).getAllStates());
        PropertyDefinitionComparator propertyDefinitionComparator = new PropertyDefinitionComparator(this, this.persister.getDataManager(), this.locationFactory);
        changesLog.addAll(propertyDefinitionComparator.compare(recipientDefinition, this.getAllPropertyDefinitions(ancestorDefinition), this.getAllPropertyDefinitions(recipientDefinition)).getAllStates());
        if (!Arrays.deepEquals(recipientDefinition.getDeclaredSupertypeNames(), ancestorDefinition.getDeclaredSupertypeNames())) {
            for (String uuid : nodes) {
                ItemData item = this.persister.getDataManager().getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                changesLog.add(new ItemState(item, 16, false, null));
            }
        }
        if (ancestorDefinition.isMixin() != recipientDefinition.isMixin() && nodes.size() > 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Fail to change ");
            buffer.append(recipientDefinition.getName().getAsString());
            buffer.append(" node type from IsMixin=");
            buffer.append(ancestorDefinition.isMixin());
            buffer.append(" to IsMixin=");
            buffer.append(recipientDefinition.isMixin());
            buffer.append(" because the folowing node exists: ");
            for (String uuid : nodes) {
                ItemData item = this.persister.getDataManager().getItemData(uuid);
                if (item == null || !item.isNode()) continue;
                buffer.append(item.getQPath().getAsString());
                buffer.append(" ");
            }
            throw new ConstraintViolationException(buffer.toString());
        }
        this.internalUnregister(ancestorDefinition.getName(), ancestorDefinition);
        changesLog.addAll(this.removePersistedNodeType(ancestorDefinition));
        this.internalRegister(recipientDefinition, volatileNodeTypes);
        changesLog.addAll(this.persistNodeTypeData(recipientDefinition, false).getAllStates());
        return changesLog;
    }
}

