/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ItemDefinition;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitionDatas;
import org.exoplatform.services.jcr.core.nodetype.PropertyDefinitions;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.PropertyDefinitionImpl;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeTypeImpl
implements NodeType {
    protected static final Log LOG = ExoLogger.getLogger("jcr.NodeTypeImpl");
    protected final NodeTypeData data;
    protected final NodeTypeDataManager typesHolder;
    protected final ExtendedNodeTypeManager typesManager;
    protected final LocationFactory locationFactory;
    protected final ValueFactory valueFactory;

    public NodeTypeImpl(NodeTypeData data, NodeTypeDataManager typesHolder, ExtendedNodeTypeManager typesManager, LocationFactory locationFactory, ValueFactory valueFactory) {
        this.data = data;
        this.typesHolder = typesHolder;
        this.typesManager = typesManager;
        this.locationFactory = locationFactory;
        this.valueFactory = valueFactory;
    }

    @Override
    public boolean canAddChildNode(String childNodeName) {
        try {
            InternalQName cname = this.locationFactory.parseJCRName(childNodeName).getInternalName();
            NodeDefinitionData childNodeDef = this.typesHolder.findChildNodeDefinition(cname, this.data.getName());
            return childNodeDef != null && !childNodeDef.isProtected() && childNodeDef.getDefaultPrimaryType() != null;
        }
        catch (RepositoryException e) {
            LOG.error("canAddChildNode " + e, e);
            return false;
        }
    }

    @Override
    public boolean canAddChildNode(String childNodeName, String nodeTypeName) {
        try {
            InternalQName cname = this.locationFactory.parseJCRName(childNodeName).getInternalName();
            InternalQName ntname = this.locationFactory.parseJCRName(nodeTypeName).getInternalName();
            NodeDefinitionData childNodeDef = this.typesHolder.findChildNodeDefinition(cname, ntname, this.data.getName());
            return childNodeDef != null && !childNodeDef.isProtected() && this.isChildNodePrimaryTypeAllowed(nodeTypeName);
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("canAddChildNode " + e, e);
            }
            return false;
        }
    }

    @Override
    public boolean canRemoveItem(String itemName) {
        try {
            PropertyDefinitionData pd;
            InternalQName iname = this.locationFactory.parseJCRName(itemName).getInternalName();
            PropertyDefinitionDatas pdefs = this.typesHolder.getPropertyDefinitions(iname, this.data.getName());
            if (pdefs != null && (pd = pdefs.getAnyDefinition()) != null) {
                return !pd.isMandatory() && !pd.isProtected();
            }
            NodeDefinitionData cndef = this.typesHolder.findChildNodeDefinition(iname, this.data.getName());
            if (cndef != null) {
                return !cndef.isMandatory() && !cndef.isProtected();
            }
            return false;
        }
        catch (RepositoryException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("canRemoveItem " + e, e);
            }
            return false;
        }
    }

    @Override
    public boolean canSetProperty(String propertyName, Value value) {
        try {
            PropertyDefinitionData pd;
            InternalQName pname = this.locationFactory.parseJCRName(propertyName).getInternalName();
            PropertyDefinitionDatas pdefs = this.typesHolder.getPropertyDefinitions(pname, this.data.getName());
            if (pdefs != null && (pd = pdefs.getDefinition(false)) != null) {
                if (pd.isProtected()) {
                    return false;
                }
                if (value != null) {
                    return this.canSetPropertyForType(pd.getRequiredType(), value, pd.getValueConstraints());
                }
                return !pd.isMandatory();
            }
            return false;
        }
        catch (RepositoryException e) {
            LOG.error("canSetProperty value " + e, e);
            return false;
        }
    }

    @Override
    public boolean canSetProperty(String propertyName, Value[] values) {
        try {
            InternalQName pname = this.locationFactory.parseJCRName(propertyName).getInternalName();
            PropertyDefinitionDatas pdefs = this.typesHolder.getPropertyDefinitions(pname, this.data.getName());
            PropertyDefinitionData pd = pdefs.getDefinition(true);
            if (pd != null) {
                if (pd.isProtected()) {
                    return false;
                }
                if (values != null) {
                    int res = 0;
                    for (Value value : values) {
                        if (!this.canSetPropertyForType(pd.getRequiredType(), value, pd.getValueConstraints())) continue;
                        ++res;
                    }
                    return res == values.length;
                }
                return !pd.isMandatory();
            }
            return false;
        }
        catch (RepositoryException e) {
            LOG.error("canSetProperty value " + e, e);
            return false;
        }
    }

    @Override
    public NodeDefinition[] getChildNodeDefinitions() {
        NodeDefinitionData[] nodeDefs = this.typesHolder.getAllChildNodeDefinitions(this.data.getName());
        NodeDefinition[] ndefs = new NodeDefinition[nodeDefs.length];
        for (int i = 0; i < nodeDefs.length; ++i) {
            NodeDefinitionData cnd = nodeDefs[i];
            try {
                ndefs[i] = this.makeNodeDefinition(cnd);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                LOG.error("Node type not found " + e, e);
                continue;
            }
            catch (RepositoryException e) {
                LOG.error("Error of declared child node definition create " + e, e);
            }
        }
        return ndefs;
    }

    @Override
    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        NodeDefinitionData[] cndefs = this.data.getDeclaredChildNodeDefinitions();
        NodeDefinition[] ndefs = new NodeDefinition[cndefs.length];
        for (int i = 0; i < cndefs.length; ++i) {
            NodeDefinitionData cnd = cndefs[i];
            try {
                ndefs[i] = this.makeNodeDefinition(cnd);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                LOG.error("Node type not found " + e, e);
                continue;
            }
            catch (RepositoryException e) {
                LOG.error("Error of declared child node definition create " + e, e);
            }
        }
        return ndefs;
    }

    private NodeDefinition makeNodeDefinition(NodeDefinitionData data) throws NoSuchNodeTypeException, RepositoryException {
        InternalQName[] rnames = data.getRequiredPrimaryTypes();
        NodeType[] rnts = new NodeType[rnames.length];
        for (int j = 0; j < rnames.length; ++j) {
            rnts[j] = this.typesManager.findNodeType(rnames[j]);
        }
        String name = this.locationFactory.createJCRName(data.getName() != null ? data.getName() : Constants.JCR_ANY_NAME).getAsString();
        NodeType defType = data.getDefaultPrimaryType() != null ? this.typesManager.findNodeType(data.getDefaultPrimaryType()) : null;
        return new NodeDefinitionImpl(name, this, rnts, defType, data.isAutoCreated(), data.isMandatory(), data.getOnParentVersion(), data.isProtected(), data.isAllowsSameNameSiblings());
    }

    @Override
    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        PropertyDefinitionData[] pdefs = this.data.getDeclaredPropertyDefinitions();
        return this.getPropertyDefinition(pdefs);
    }

    private PropertyDefinition[] getPropertyDefinition(PropertyDefinitionData[] pdefs) {
        PropertyDefinition[] propertyDefinitions = new PropertyDefinition[pdefs.length];
        for (int i = 0; i < pdefs.length; ++i) {
            try {
                PropertyDefinitionData propertyDef = pdefs[i];
                String name = this.locationFactory.createJCRName(propertyDef.getName() != null ? propertyDef.getName() : Constants.JCR_ANY_NAME).getAsString();
                Value[] defaultValues = new Value[propertyDef.getDefaultValues().length];
                String[] propVal = propertyDef.getDefaultValues();
                if (propVal != null) {
                    for (int j = 0; j < propVal.length; ++j) {
                        defaultValues[j] = propertyDef.getRequiredType() == 0 ? this.valueFactory.createValue(propVal[j]) : this.valueFactory.createValue(propVal[j], propertyDef.getRequiredType());
                    }
                }
                propertyDefinitions[i] = new PropertyDefinitionImpl(name, this.typesManager.findNodeType(propertyDef.getDeclaringNodeType()), propertyDef.getRequiredType(), propertyDef.getValueConstraints(), defaultValues, propertyDef.isAutoCreated(), propertyDef.isMandatory(), propertyDef.getOnParentVersion(), propertyDef.isProtected(), propertyDef.isMultiple());
                continue;
            }
            catch (ValueFormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                e.printStackTrace();
                continue;
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return propertyDefinitions;
    }

    @Override
    public NodeType[] getDeclaredSupertypes() {
        InternalQName[] snames = this.data.getDeclaredSupertypeNames();
        NodeType[] supers = new NodeType[snames.length];
        for (int i = 0; i < snames.length; ++i) {
            supers[i] = new NodeTypeImpl(this.typesHolder.findNodeType(snames[i]), this.typesHolder, this.typesManager, this.locationFactory, this.valueFactory);
        }
        return supers;
    }

    @Override
    public String getName() {
        try {
            return this.locationFactory.createJCRName(this.data.getName()).getAsString();
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Wrong name in data " + e, e);
        }
    }

    @Override
    public String getPrimaryItemName() {
        try {
            if (this.data.getPrimaryItemName() != null) {
                return this.locationFactory.createJCRName(this.data.getPrimaryItemName()).getAsString();
            }
            return null;
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Wrong primary item name in data " + e, e);
        }
    }

    @Override
    public PropertyDefinition[] getPropertyDefinitions() {
        PropertyDefinitionData[] propertyDefs = this.typesHolder.getAllPropertyDefinitions(this.data.getName());
        return this.getPropertyDefinition(propertyDefs);
    }

    @Override
    public NodeType[] getSupertypes() {
        InternalQName[] dsupers = this.data.getDeclaredSupertypeNames();
        NodeType[] superTypes = new NodeType[dsupers.length];
        for (int i = 0; i < dsupers.length; ++i) {
            try {
                superTypes[i] = this.typesManager.findNodeType(dsupers[i]);
                continue;
            }
            catch (NoSuchNodeTypeException e) {
                e.printStackTrace();
                continue;
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
        }
        return superTypes;
    }

    @Override
    public boolean hasOrderableChildNodes() {
        return this.data.hasOrderableChildNodes();
    }

    @Override
    public boolean isMixin() {
        return this.data.isMixin();
    }

    @Override
    public boolean isNodeType(String nodeTypeName) {
        try {
            return this.typesHolder.isNodeType(this.locationFactory.parseJCRName(nodeTypeName).getInternalName(), this.data.getName());
        }
        catch (RepositoryException e) {
            throw new RuntimeException("Wrong nodetype name " + e, e);
        }
    }

    public NodeDefinition getChildNodeDefinition(InternalQName name) {
        return null;
    }

    public NodeDefinition getChildNodeDefinition(String name) {
        return null;
    }

    public ArrayList<ItemDefinition> getManadatoryItemDefs() {
        return null;
    }

    public PropertyDefinitions getPropertyDefinitions(InternalQName name) {
        return null;
    }

    public PropertyDefinitions getPropertyDefinitions(String name) {
        return null;
    }

    public InternalQName getQName() {
        return this.data.getName();
    }

    public boolean isChildNodePrimaryTypeAllowed(String typeName) {
        try {
            InternalQName iname = this.locationFactory.parseJCRName(typeName).getInternalName();
            return this.typesHolder.isChildNodePrimaryTypeAllowed(iname, this.data.getName(), new InternalQName[0]);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    public boolean isNodeType(InternalQName nodeTypeQName) {
        return this.typesHolder.isNodeType(nodeTypeQName, this.data.getName(), new InternalQName[0]);
    }

    /*
     * Loose catch block
     */
    private boolean canSetPropertyForType(int requiredType, Value value, String[] constrains) {
        if (requiredType == value.getType()) {
            return this.checkValueConstraints(constrains, value);
        }
        if (requiredType == 2 && (value.getType() == 1 || value.getType() == 5 || value.getType() == 3 || value.getType() == 4 || value.getType() == 7 || value.getType() == 8 || value.getType() == 6)) {
            return this.checkValueConstraints(constrains, value);
        }
        if (requiredType == 6) {
            if (value.getType() == 1) {
                return this.checkValueConstraints(constrains, value);
            }
            if (value.getType() == 2) {
                try {
                    return this.isCharsetString(value.getString(), "UTF-8") && this.checkValueConstraints(constrains, value);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
        if (requiredType == 5) {
            String likeDataString = null;
            try {
                if (value.getType() == 1) {
                    likeDataString = value.getString();
                } else if (value.getType() == 2) {
                    likeDataString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 4 || value.getType() == 3) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    return false;
                }
                JCRDateFormat.parse(likeDataString);
                return this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 4) {
            String likeDoubleString = null;
            try {
                if (value.getType() == 1) {
                    likeDoubleString = value.getString();
                } else if (value.getType() == 2) {
                    likeDoubleString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 5) {
                        return true;
                    }
                    if (value.getType() == 3) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    return false;
                }
                Double doubleValue = new Double(likeDoubleString);
                return doubleValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 3) {
            String likeLongString = null;
            try {
                if (value.getType() == 1) {
                    likeLongString = value.getString();
                } else if (value.getType() == 2) {
                    likeLongString = this.getCharsetString(value.getString(), "UTF-8");
                } else {
                    if (value.getType() == 5) {
                        return true;
                    }
                    return value.getType() == 4;
                }
                Long longValue = new Long(likeLongString);
                return longValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 7) {
            String likeNameString;
            block61: {
                likeNameString = null;
                if (value.getType() == 1) {
                    likeNameString = value.getString();
                    break block61;
                }
                if (value.getType() == 2) {
                    likeNameString = this.getCharsetString(value.getString(), "UTF-8");
                    break block61;
                }
                if (value.getType() == 8) {
                    String pathString = value.getString();
                    String[] pathParts = pathString.split("\\/");
                    if (pathString.startsWith("/") && (pathParts.length > 1 || pathString.indexOf("[") > 0)) {
                        return false;
                    }
                    if (!pathParts.equals("/") && pathParts.length == 1 && pathString.indexOf("[") < 0) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    if (pathString.startsWith("/") && pathString.lastIndexOf("/") < 1 && pathString.indexOf("[") < 0) {
                        return this.checkValueConstraints(constrains, value);
                    }
                    return false;
                }
                return false;
                {
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            try {
                Value nameValue = this.valueFactory.createValue(likeNameString, requiredType);
                return nameValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 8) {
            String likeNameString;
            block62: {
                likeNameString = null;
                if (value.getType() == 1) {
                    likeNameString = value.getString();
                    break block62;
                }
                if (value.getType() == 2) {
                    likeNameString = this.getCharsetString(value.getString(), "UTF-8");
                    break block62;
                }
                if (value.getType() == 7) {
                    return this.checkValueConstraints(constrains, value);
                }
                return false;
                {
                    catch (Exception e) {
                        return false;
                    }
                }
            }
            try {
                Value nameValue = this.valueFactory.createValue(likeNameString, requiredType);
                return nameValue != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 1) {
            String likeStringString = null;
            try {
                if (value.getType() == 2) {
                    likeStringString = this.getCharsetString(value.getString(), "UTF-8");
                } else if (value.getType() == 5 || value.getType() == 3 || value.getType() == 6 || value.getType() == 7 || value.getType() == 8 || value.getType() == 4) {
                    likeStringString = value.getString();
                } else {
                    return false;
                }
                return likeStringString != null && this.checkValueConstraints(constrains, value);
            }
            catch (Exception e) {
                return false;
            }
        }
        if (requiredType == 0) {
            return this.checkValueConstraints(constrains, value);
        }
        return false;
    }

    private boolean checkValueConstraints(String[] constraints, Value value) {
        if (constraints != null && constraints.length > 0) {
            for (int i = 0; i < constraints.length; ++i) {
                try {
                    if (!constraints[i].equals(value.getString())) continue;
                    return true;
                }
                catch (RepositoryException e) {
                    LOG.error("Can't get value's string value " + e, e);
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private String getCharsetString(String source, String charSetName) {
        try {
            CharBuffer cb = CharBuffer.wrap(source.toCharArray());
            Charset cs = Charset.forName(charSetName);
            CharsetEncoder cse = cs.newEncoder();
            ByteBuffer encoded = cse.encode(cb);
            return new String(encoded.array()).trim();
        }
        catch (IllegalStateException e) {
            return null;
        }
        catch (MalformedInputException e) {
            return null;
        }
        catch (UnmappableCharacterException e) {
            return null;
        }
        catch (CharacterCodingException e) {
            return null;
        }
    }

    private boolean isCharsetString(String source, String charSetName) {
        try {
            String s = this.getCharsetString(source, charSetName);
            return s != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

