/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

public class OrderQueryNode
extends QueryNode {
    private final List specs = new ArrayList();

    protected OrderQueryNode(QueryNode parent) {
        super(parent);
    }

    public int getType() {
        return 3;
    }

    public void addOrderSpec(InternalQName property, boolean ascending) {
        this.specs.add(new OrderSpec(property, ascending));
    }

    public void addOrderSpec(OrderSpec spec) {
        this.specs.add(spec);
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public boolean isAscending(int i) throws IndexOutOfBoundsException {
        return ((OrderSpec)this.specs.get(i)).ascending;
    }

    public OrderSpec[] getOrderSpecs() {
        return this.specs.toArray(new OrderSpec[this.specs.size()]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OrderQueryNode) {
            OrderQueryNode other = (OrderQueryNode)obj;
            return ((Object)this.specs).equals(other.specs);
        }
        return false;
    }

    public boolean needsSystemTree() {
        return false;
    }

    public static final class OrderSpec {
        private InternalQName property;
        private boolean ascending;

        public OrderSpec(InternalQName property, boolean ascending) {
            this.property = property;
            this.ascending = ascending;
        }

        public InternalQName getProperty() {
            return this.property;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void setAscending(boolean ascending) {
            this.ascending = ascending;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OrderSpec) {
                OrderSpec other = (OrderSpec)obj;
                return (this.property == null ? other.property == null : this.property.equals(other.property)) && this.ascending == other.ascending;
            }
            return false;
        }
    }
}

