/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.ForeignSegmentDocId;
import org.exoplatform.services.jcr.impl.core.query.lucene.HierarchyResolver;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.SingleTermDocs;

public final class CachingMultiIndexReader
extends MultiReader
implements HierarchyResolver,
MultiIndexReader {
    private ReadOnlyIndexReader[] subReaders;
    private final Map<Long, OffsetReader> readersByCreationTick = new HashMap<Long, OffsetReader>();
    private final DocNumberCache cache;
    private int[] starts;
    private int refCount = 1;

    public CachingMultiIndexReader(ReadOnlyIndexReader[] subReaders, DocNumberCache cache) throws IOException {
        super(subReaders);
        this.cache = cache;
        this.subReaders = subReaders;
        this.starts = new int[subReaders.length + 1];
        int maxDoc = 0;
        for (int i = 0; i < subReaders.length; ++i) {
            this.starts[i] = maxDoc;
            maxDoc += subReaders[i].maxDoc();
            OffsetReader offsetReader = new OffsetReader(subReaders[i], this.starts[i]);
            this.readersByCreationTick.put(new Long(subReaders[i].getCreationTick()), offsetReader);
        }
        this.starts[subReaders.length] = maxDoc;
    }

    public int getParent(int n) throws IOException {
        DocId id = this.getParentDocId(n);
        return id.getDocumentNumber(this);
    }

    public DocId getParentDocId(int n) throws IOException {
        int i = this.readerIndex(n);
        DocId id = this.subReaders[i].getParent(n - this.starts[i]);
        return id.applyOffset(this.starts[i]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TermDocs termDocs(Term term) throws IOException {
        if (term.field() == FieldNames.UUID) {
            OffsetReader offsetReader;
            DocNumberCache.Entry e = this.cache.get(term.text());
            if (e != null && (offsetReader = this.readersByCreationTick.get(new Long(e.creationTick))) != null && !offsetReader.reader.isDeleted(e.doc)) {
                return new SingleTermDocs(e.doc + offsetReader.offset);
            }
            for (int i = 0; i < this.subReaders.length; ++i) {
                Object var7_6;
                TermDocs docs;
                block6: {
                    SingleTermDocs singleTermDocs;
                    docs = this.subReaders[i].termDocs(term);
                    try {
                        if (!docs.next()) break block6;
                        singleTermDocs = new SingleTermDocs(docs.doc() + this.starts[i]);
                        var7_6 = null;
                    }
                    catch (Throwable throwable) {
                        var7_6 = null;
                        docs.close();
                        throw throwable;
                    }
                    docs.close();
                    return singleTermDocs;
                }
                var7_6 = null;
                docs.close();
            }
        }
        return super.termDocs(term);
    }

    synchronized void incrementRefCount() {
        ++this.refCount;
    }

    protected synchronized void doClose() throws IOException {
        if (--this.refCount == 0) {
            super.doClose();
        }
    }

    public IndexReader[] getIndexReaders() {
        IndexReader[] readers = new IndexReader[this.subReaders.length];
        System.arraycopy(this.subReaders, 0, readers, 0, this.subReaders.length);
        return readers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForeignSegmentDocId createDocId(String uuid) throws IOException {
        Term id = new Term(FieldNames.UUID, uuid);
        for (int i = 0; i < this.subReaders.length; ++i) {
            Object var10_5;
            TermDocs docs;
            block4: {
                ForeignSegmentDocId foreignSegmentDocId;
                docs = this.subReaders[i].termDocs(id);
                try {
                    if (!docs.next()) break block4;
                    int doc = docs.doc();
                    long tick = this.subReaders[i].getCreationTick();
                    foreignSegmentDocId = new ForeignSegmentDocId(doc, tick);
                    var10_5 = null;
                }
                catch (Throwable throwable) {
                    var10_5 = null;
                    docs.close();
                    throw throwable;
                }
                docs.close();
                return foreignSegmentDocId;
            }
            var10_5 = null;
            docs.close();
        }
        return null;
    }

    public int getDocumentNumber(ForeignSegmentDocId docId) {
        OffsetReader r = this.readersByCreationTick.get(new Long(docId.getCreationTick()));
        if (r != null && !r.reader.isDeleted(docId.getDocNumber())) {
            return r.offset + docId.getDocNumber();
        }
        return -1;
    }

    private int readerIndex(int n) {
        int lo = 0;
        int hi = this.subReaders.length - 1;
        while (hi >= lo) {
            int mid = lo + hi >> 1;
            int midValue = this.starts[mid];
            if (n < midValue) {
                hi = mid - 1;
                continue;
            }
            if (n > midValue) {
                lo = mid + 1;
                continue;
            }
            while (mid + 1 < this.subReaders.length && this.starts[mid + 1] == midValue) {
                ++mid;
            }
            return mid;
        }
        return hi;
    }

    private static final class OffsetReader {
        private final ReadOnlyIndexReader reader;
        private final int offset;

        OffsetReader(ReadOnlyIndexReader reader, int offset) {
            this.reader = reader;
            this.offset = offset;
        }
    }
}

