/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.UnboundedFifoBuffer;
import org.apache.commons.logging.Log;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.MultiIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.log.ExoLogger;

class IndexMerger
extends Thread
implements IndexListener {
    private static final Log log = ExoLogger.getLogger(IndexMerger.class);
    private static final Merge QUIT = new Merge(new Index[0]);
    private int minMergeDocs = new Integer(100);
    private int maxMergeDocs = new Integer(Integer.MAX_VALUE);
    private int mergeFactor = new Integer(10);
    private final Buffer mergeTasks = BufferUtils.blockingBuffer(new UnboundedFifoBuffer());
    private final List<Term> deletedDocuments = Collections.synchronizedList(new ArrayList());
    private final List<IndexBucket> indexBuckets = new ArrayList<IndexBucket>();
    private final MultiIndex multiIndex;
    private final Object lock = new Object();
    private final Semaphore indexReplacement = new Semaphore(1);
    private final Semaphore mergerIdle = new Semaphore(1);

    IndexMerger(MultiIndex multiIndex) {
        this.multiIndex = multiIndex;
        this.setName("IndexMerger " + this.multiIndex.getIndexDir().getPath());
        this.setDaemon(true);
        try {
            this.mergerIdle.acquire();
        }
        catch (InterruptedException e) {
            throw new InternalError("Unable to acquire mutex after construction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void indexAdded(String name, int numDocs) {
        if (numDocs < 0) {
            throw new IllegalArgumentException("numDocs must be positive");
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.indexBuckets.size() == 0) {
                long lower = 0L;
                for (long upper = (long)this.minMergeDocs; upper < (long)this.maxMergeDocs; upper *= (long)this.mergeFactor) {
                    this.indexBuckets.add(new IndexBucket(lower, upper, true));
                    lower = upper + 1L;
                }
                this.indexBuckets.add(new IndexBucket(lower, this.maxMergeDocs, false));
                this.indexBuckets.add(new IndexBucket(this.maxMergeDocs + 1, Long.MAX_VALUE, false));
            }
            IndexBucket bucket = this.indexBuckets.get(this.indexBuckets.size() - 1);
            for (int i = 0; i < this.indexBuckets.size() && !(bucket = this.indexBuckets.get(i)).fits(numDocs); ++i) {
            }
            bucket.add(new Index(name, numDocs));
            if (log.isDebugEnabled()) {
                log.debug("index added: name=" + name + ", numDocs=" + numDocs);
            }
            if (!bucket.allowsMerge()) {
                return;
            }
            if (bucket.size() >= this.mergeFactor) {
                long targetMergeDocs = bucket.upper;
                targetMergeDocs = Math.min(targetMergeDocs * (long)this.mergeFactor, (long)this.maxMergeDocs);
                ArrayList indexesToMerge = new ArrayList();
                int mergeDocs = 0;
                Iterator it = bucket.iterator();
                while (it.hasNext() && (long)mergeDocs <= targetMergeDocs) {
                    indexesToMerge.add(it.next());
                }
                if (indexesToMerge.size() > 2) {
                    Index[] idxs = indexesToMerge.toArray(new Index[indexesToMerge.size()]);
                    bucket.removeAll(indexesToMerge);
                    if (log.isDebugEnabled()) {
                        log.debug("requesting merge for " + indexesToMerge);
                    }
                    this.mergeTasks.add(new Merge(idxs));
                    log.debug("merge queue now contains " + this.mergeTasks.size() + " tasks.");
                }
            }
        }
    }

    public void documentDeleted(Term id) {
        log.debug("document deleted: " + id.text());
        this.deletedDocuments.add(id);
    }

    void waitUntilIdle() throws InterruptedException {
        this.mergerIdle.acquire();
        this.mergerIdle.release();
    }

    void dispose() {
        if (log.isDebugEnabled()) {
            log.info("dispose " + this.getName() + ", " + Thread.currentThread());
        }
        try {
            this.indexReplacement.acquire();
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while acquiring index replacement sync: " + e);
        }
        this.mergeTasks.clear();
        this.mergeTasks.add(QUIT);
        log.debug("quit sent");
        try {
            this.join(500L);
            if (this.isAlive()) {
                log.info("Unable to stop IndexMerger. Deamon is busy.");
            } else {
                log.debug("IndexMerger thread stopped");
            }
            log.debug("merge queue size: " + this.mergeTasks.size());
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for IndexMerger thread to terminate.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Merge task;
            boolean isIdle = false;
            if (this.mergeTasks.size() == 0) {
                this.mergerIdle.release();
                isIdle = true;
            }
            if ((task = (Merge)this.mergeTasks.remove()) == QUIT) {
                this.mergerIdle.release();
                break;
            }
            if (isIdle) {
                try {
                    this.mergerIdle.acquire();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    log.warn("Unable to acquire mergerIdle sync");
                }
            }
            log.debug("accepted merge request");
            this.deletedDocuments.clear();
            String[] names = new String[task.indexes.length];
            for (int i = 0; i < task.indexes.length; ++i) {
                names[i] = task.indexes[i].name;
            }
            try {
                Object var18_17;
                log.debug("create new index");
                PersistentIndex index = this.multiIndex.getOrCreateIndex(null);
                boolean success = false;
                try {
                    Object var16_16;
                    IOException e2;
                    int i;
                    Object var12_13;
                    log.debug("get index readers from MultiIndex");
                    IndexReader[] readers = this.multiIndex.getIndexReaders(names, this);
                    try {
                        long time = System.currentTimeMillis();
                        index.addIndexes(readers);
                        time = System.currentTimeMillis() - time;
                        int docCount = 0;
                        for (int i2 = 0; i2 < readers.length; ++i2) {
                            docCount += readers[i2].numDocs();
                        }
                        log.info("merged " + docCount + " documents in " + time + " ms into " + index.getName() + ".");
                        var12_13 = null;
                    }
                    catch (Throwable throwable) {
                        var12_13 = null;
                        for (i = 0; i < readers.length; ++i) {
                            try {
                                readers[i].close();
                                continue;
                            }
                            catch (IOException e2) {
                                log.warn("Unable to close IndexReader: " + e2);
                            }
                        }
                        throw throwable;
                    }
                    for (i = 0; i < readers.length; ++i) {
                        try {
                            readers[i].close();
                            continue;
                        }
                        catch (IOException e2) {
                            log.warn("Unable to close IndexReader: " + e2);
                        }
                    }
                    if (!this.indexReplacement.tryAcquire()) {
                        if (log.isDebugEnabled()) {
                            log.debug("index merging canceled " + this.getName());
                        }
                        var18_17 = null;
                        if (!success) {
                            log.debug("deleting index " + index.getName());
                            this.multiIndex.deleteIndex(index);
                        }
                        break;
                    }
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("replace indexes");
                        }
                        this.multiIndex.replaceIndexes(names, index, this.deletedDocuments);
                        var16_16 = null;
                        this.indexReplacement.release();
                    }
                    catch (Throwable throwable) {
                        var16_16 = null;
                        this.indexReplacement.release();
                        throw throwable;
                    }
                    success = true;
                }
                catch (Throwable throwable) {
                    var18_17 = null;
                    if (!success) {
                        log.debug("deleting index " + index.getName());
                        this.multiIndex.deleteIndex(index);
                    }
                    throw throwable;
                }
                var18_17 = null;
                if (success) continue;
                log.debug("deleting index " + index.getName());
                this.multiIndex.deleteIndex(index);
                {
                    continue;
                }
            }
            catch (Throwable e) {
                log.error("Error while merging indexes in " + this.getName() + ": " + e);
                continue;
            }
            break;
        }
        log.info(this.getName() + " terminated");
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setMinMergeDocs(int minMergeDocs) {
        this.minMergeDocs = minMergeDocs;
    }

    public void setMaxMergeDocs(int maxMergeDocs) {
        this.maxMergeDocs = maxMergeDocs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IndexBucket
    extends ArrayList<Index> {
        private static final long serialVersionUID = 1885162315017837466L;
        private final long lower;
        private final long upper;
        private final boolean allowMerge;

        IndexBucket(long lower, long upper, boolean allowMerge) {
            this.lower = lower;
            this.upper = upper;
            this.allowMerge = allowMerge;
        }

        boolean fits(long numDocs) {
            return numDocs >= this.lower && numDocs <= this.upper;
        }

        boolean allowsMerge() {
            return this.allowMerge;
        }
    }

    private static final class Merge {
        private final Index[] indexes;

        Merge(Index[] indexes) {
            this.indexes = new Index[indexes.length];
            System.arraycopy(indexes, 0, this.indexes, 0, indexes.length);
        }
    }

    private static final class Index
    implements Comparable {
        private final String name;
        private final int numDocs;

        Index(String name, int numDocs) {
            this.name = name;
            this.numDocs = numDocs;
        }

        public int compareTo(Object o) {
            int val;
            Index other = (Index)o;
            int n = this.numDocs < other.numDocs ? -1 : (val = this.numDocs == other.numDocs ? 0 : 1);
            if (val != 0) {
                return val;
            }
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.name + ":" + this.numDocs;
        }
    }
}

