/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.commons.logging.Log;
import org.apache.lucene.search.Query;
import org.exoplatform.services.jcr.access.AccessManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.AbstractQueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocOrderNodeIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ExcerptProvider;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryHits;
import org.exoplatform.services.jcr.impl.core.query.lucene.RowIteratorImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNode;
import org.exoplatform.services.jcr.impl.core.query.lucene.ScoreNodeIterator;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.SpellSuggestion;
import org.exoplatform.services.jcr.impl.core.query.lucene.TwoWayRangeIterator;
import org.exoplatform.services.log.ExoLogger;

public class QueryResultImpl
implements QueryResult {
    private static final Log log = ExoLogger.getLogger(QueryResultImpl.class);
    private final SearchIndex index;
    private final SessionDataManager itemMgr;
    protected final LocationFactory resolver;
    private final AccessManager accessMgr;
    protected final AbstractQueryImpl queryImpl;
    protected final Query query;
    protected final SpellSuggestion spellSuggestion;
    protected final InternalQName[] selectProps;
    protected final InternalQName[] orderProps;
    protected final boolean[] orderSpecs;
    private final List<ScoreNode> resultNodes = new ArrayList<ScoreNode>();
    private int numResults = -1;
    private int invalid = 0;
    private final boolean docOrder;
    private ExcerptProvider excerptProvider;
    private final long offset;
    private final long limit;
    private final String userId;
    private final ValueFactory vFactory;

    public QueryResultImpl(SearchIndex index, SessionDataManager itemMgr, LocationFactory resolver2, ValueFactory vFactory, AccessManager accessMgr, String userId, AbstractQueryImpl queryImpl, Query query, SpellSuggestion spellSuggestion, InternalQName[] selectProps, InternalQName[] orderProps, boolean[] orderSpecs, boolean documentOrder, long offset, long limit) throws RepositoryException {
        this.index = index;
        this.itemMgr = itemMgr;
        this.userId = userId;
        this.resolver = resolver2;
        this.vFactory = vFactory;
        this.accessMgr = accessMgr;
        this.queryImpl = queryImpl;
        this.query = query;
        this.spellSuggestion = spellSuggestion;
        this.selectProps = selectProps;
        this.orderProps = orderProps;
        this.orderSpecs = orderSpecs;
        this.docOrder = orderProps.length == 0 && documentOrder;
        this.offset = offset;
        this.limit = limit;
        this.getResults(this.docOrder ? Integer.MAX_VALUE : (long)index.getQueryHandlerConfig().getResultFetchSize());
    }

    public String[] getColumnNames() throws RepositoryException {
        try {
            String[] propNames = new String[this.selectProps.length];
            for (int i = 0; i < this.selectProps.length; ++i) {
                propNames[i] = this.resolver.createJCRName(this.selectProps[i]).getAsString();
            }
            return propNames;
        }
        catch (NamespaceException npde) {
            String msg = "encountered invalid property name";
            log.debug(msg);
            throw new RepositoryException(msg, npde);
        }
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.getNodeIterator();
    }

    public RowIterator getRows() throws RepositoryException {
        if (this.excerptProvider == null) {
            try {
                this.excerptProvider = this.index.createExcerptProvider(this.query);
            }
            catch (IOException e) {
                throw new RepositoryException(e);
            }
        }
        return new RowIteratorImpl(this.getNodeIterator(), this.selectProps, this.resolver, this.excerptProvider, this.spellSuggestion, this.vFactory);
    }

    protected QueryHits executeQuery() throws IOException {
        return this.index.executeQuery(this.query, this.queryImpl.needsSystemTree(), this.orderProps, this.orderSpecs);
    }

    private ScoreNodeIterator getNodeIterator() {
        if (this.docOrder) {
            return new DocOrderNodeIteratorImpl(this.itemMgr, this.accessMgr, this.userId, this.resultNodes);
        }
        return new LazyScoreNodeIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getResults(long size) throws RepositoryException {
        if (log.isDebugEnabled()) {
            log.debug("getResults(" + size + ")");
        }
        long maxResultSize = size;
        if (this.limit > 0L) {
            maxResultSize = this.limit;
        }
        if ((long)this.resultNodes.size() >= maxResultSize) {
            return;
        }
        QueryHits result = null;
        result = this.executeQuery();
        if (this.numResults == -1) {
            this.numResults = result.length();
        }
        int start = this.resultNodes.size() + this.invalid + (int)this.offset;
        int max = Math.min(result.length(), this.numResults);
        for (int i = start; i < max && (long)this.resultNodes.size() < maxResultSize; ++i) {
            String id = result.getFieldContent(i, FieldNames.UUID);
            this.resultNodes.add(new ScoreNode(id, result.score(i)));
        }
        Object var11_9 = null;
        if (result == null) return;
        try {
            result.close();
            return;
        }
        catch (IOException e2) {
            log.warn("Unable to close query result: " + e2);
        }
        return;
        {
            catch (IOException e) {
                log.error("Exception while executing query: ", e);
                Object var11_10 = null;
                if (result == null) return;
                try {
                    result.close();
                    return;
                }
                catch (IOException e2) {
                    log.warn("Unable to close query result: " + e2);
                }
                return;
            }
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (result == null) throw throwable;
            try {
                result.close();
                throw throwable;
            }
            catch (IOException e2) {
                log.warn("Unable to close query result: " + e2);
            }
            throw throwable;
        }
    }

    public int getTotalSize() {
        return this.numResults - this.invalid;
    }

    private final class LazyScoreNodeIterator
    implements TwoWayRangeIterator,
    ScoreNodeIterator {
        private int position = -1;
        private boolean initialized = false;
        private NodeImpl next;

        private LazyScoreNodeIterator() {
        }

        public float getScore() {
            this.initialize();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ((ScoreNode)QueryResultImpl.this.resultNodes.get(this.position)).getScore();
        }

        public NodeImpl nextNodeImpl() {
            this.initialize();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            NodeImpl n = this.next;
            this.fetchNext();
            return n;
        }

        public Node nextNode() {
            return this.nextNodeImpl();
        }

        public void skip(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if ((long)(this.position + QueryResultImpl.this.invalid) + skipNum > (long)QueryResultImpl.this.numResults) {
                throw new NoSuchElementException();
            }
            if (skipNum != 0L) {
                try {
                    QueryResultImpl.this.getResults(this.position + QueryResultImpl.this.invalid + (int)skipNum);
                    if ((long)QueryResultImpl.this.resultNodes.size() < (long)this.position + skipNum) {
                        throw new NoSuchElementException();
                    }
                    this.position = (int)((long)this.position + (skipNum - 1L));
                    this.fetchNext();
                }
                catch (RepositoryException e) {
                    throw new NoSuchElementException(e.getMessage());
                }
            }
        }

        public void skipBack(long skipNum) {
            this.initialize();
            if (skipNum < 0L) {
                throw new IllegalArgumentException("skipNum must not be negative");
            }
            if ((long)this.position - skipNum < 0L) {
                throw new NoSuchElementException();
            }
            if (skipNum != 0L) {
                this.position = (int)((long)this.position - (skipNum + 1L));
                this.fetchNext();
            }
        }

        public long getSize() {
            long size = (long)QueryResultImpl.this.getTotalSize() - QueryResultImpl.this.offset;
            if (QueryResultImpl.this.limit > 0L && size > QueryResultImpl.this.limit) {
                return QueryResultImpl.this.limit;
            }
            return size;
        }

        public long getPosition() {
            this.initialize();
            return this.position;
        }

        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        public boolean hasNext() {
            this.initialize();
            return this.next != null;
        }

        public Object next() {
            return this.nextNodeImpl();
        }

        private void initialize() {
            if (!this.initialized) {
                this.fetchNext();
                this.initialized = true;
            }
        }

        private void fetchNext() {
            this.next = null;
            int nextPos = this.position + 1;
            while (this.next == null && nextPos + QueryResultImpl.this.invalid < QueryResultImpl.this.numResults) {
                if (nextPos >= QueryResultImpl.this.resultNodes.size()) {
                    try {
                        int num = QueryResultImpl.this.resultNodes.size() == 0 ? QueryResultImpl.this.index.getQueryHandlerConfig().getResultFetchSize() : QueryResultImpl.this.resultNodes.size() * 2;
                        QueryResultImpl.this.getResults(num);
                    }
                    catch (RepositoryException e) {
                        log.warn("Exception getting more results: " + e);
                    }
                    if (nextPos >= QueryResultImpl.this.resultNodes.size()) {
                        return;
                    }
                }
                ScoreNode sn = (ScoreNode)QueryResultImpl.this.resultNodes.get(nextPos);
                try {
                    this.next = (NodeImpl)QueryResultImpl.this.itemMgr.getItemByIdentifier(sn.getNodeId(), true);
                    if (this.next != null) continue;
                    QueryResultImpl.this.resultNodes.remove(nextPos);
                    QueryResultImpl.this.invalid++;
                }
                catch (RepositoryException e) {
                    log.warn("Exception retrieving Node with UUID: " + sn.getNodeId() + ": " + e.toString());
                    QueryResultImpl.this.resultNodes.remove(nextPos);
                    QueryResultImpl.this.invalid++;
                }
            }
            ++this.position;
        }
    }
}

