/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.dataflow.session;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.exoplatform.services.jcr.impl.core.XASessionImpl;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableDataManager;
import org.exoplatform.services.transaction.TransactionException;

public class TransactionableResourceManager {
    private ConcurrentMap<String, List<SoftReference<XASessionImpl>>> txManagers = new ConcurrentHashMap<String, List<SoftReference<XASessionImpl>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(XASessionImpl userSession) {
        List joinedList = (List)this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            List list = joinedList;
            synchronized (list) {
                Iterator siter = joinedList.iterator();
                while (siter.hasNext()) {
                    try {
                        XASessionImpl xaSession = (XASessionImpl)((SoftReference)siter.next()).get();
                        if (xaSession != null && xaSession.isLive()) continue;
                        siter.remove();
                    }
                    catch (ConcurrentModificationException e) {
                        e.printStackTrace();
                        System.err.println("same user >>> " + e);
                    }
                }
                joinedList.add(new SoftReference<XASessionImpl>(userSession));
            }
            this.txManagers.putIfAbsent(userSession.getUserID(), joinedList);
        } else {
            ArrayList<SoftReference<XASessionImpl>> newJoinedList = new ArrayList<SoftReference<XASessionImpl>>();
            List previous = this.txManagers.putIfAbsent(userSession.getUserID(), newJoinedList);
            if (previous != null) {
                previous.add(new SoftReference<XASessionImpl>(userSession));
            } else {
                newJoinedList.add(new SoftReference<XASessionImpl>(userSession));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(XASessionImpl userSession) {
        List joinedList = (List)this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            List list = joinedList;
            synchronized (list) {
                Iterator siter = joinedList.iterator();
                while (siter.hasNext()) {
                    XASessionImpl xaSession = (XASessionImpl)((SoftReference)siter.next()).get();
                    if (xaSession != null && xaSession.isLive() && xaSession != userSession) continue;
                    siter.remove();
                }
                if (joinedList.size() <= 0) {
                    this.txManagers.remove(userSession.getUserID(), joinedList);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(XASessionImpl userSession) throws TransactionException {
        List joinedList = (List)this.txManagers.remove(userSession.getUserID());
        if (joinedList != null) {
            List list = joinedList;
            synchronized (list) {
                for (SoftReference sr : joinedList) {
                    XASessionImpl xaSession = (XASessionImpl)sr.get();
                    if (xaSession == null || !xaSession.isLive()) continue;
                    TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                    txManager.commit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(XASessionImpl userSession) {
        List joinedList = (List)this.txManagers.get(userSession.getUserID());
        if (joinedList != null) {
            List list = joinedList;
            synchronized (list) {
                for (SoftReference sr : joinedList) {
                    XASessionImpl xaSession = (XASessionImpl)sr.get();
                    if (xaSession == null || !xaSession.isLive()) continue;
                    TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                    txManager.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(XASessionImpl userSession) {
        List joinedList = (List)this.txManagers.remove(userSession.getUserID());
        if (joinedList != null) {
            List list = joinedList;
            synchronized (list) {
                for (SoftReference sr : joinedList) {
                    XASessionImpl xaSession = (XASessionImpl)sr.get();
                    if (xaSession == null || !xaSession.isLive()) continue;
                    TransactionableDataManager txManager = xaSession.getTransientNodesManager().getTransactManager();
                    txManager.rollback();
                }
            }
        }
    }
}

