/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.monitor;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.storage.jdbc.monitor.ManagedPreparedStatement;
import org.exoplatform.services.jcr.impl.storage.jdbc.monitor.ManagedStatement;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnection
implements Connection {
    public static final String JCR_JDBC_CONNECTION_MONITOR = "org.exoplatform.jcr.monitor.jdbcMonitor";
    public static final String PREPARE_INTREST_NAME = "PREPARE";
    public static final String COMMIT_INTEREST_NAME = "COMMIT";
    public static final String CLOSE_INTEREST_NAME = "CLOSE";
    public static final String OPEN_INTEREST_NAME = "OPEN";
    public static final String EXECUTE_INTEREST_NAME = "EXECUTE";
    public static final int PREPARE_INTREST = 1;
    public static final int COMMIT_INTREST = 2;
    public static final int CLOSE_INTREST = 4;
    public static final int OPEN_INTREST = 8;
    public static final int EXECUTE_INTREST = 16;
    protected static final Log LOG = ExoLogger.getLogger("jcr.ManagedConnection");
    protected final Connection jdbcConn;
    protected int interest;

    public ManagedConnection(Connection jdbcConn, int interest) {
        this.jdbcConn = jdbcConn;
        this.interest = interest;
        if ((interest & 8) != 0) {
            LOG.info("8 " + jdbcConn + " - " + System.currentTimeMillis());
        }
    }

    public int getInterest() {
        return this.interest;
    }

    public void setInterest(int interest) {
        this.interest = interest;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.jdbcConn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.jdbcConn.close();
        if ((this.interest & 8) != 0) {
            LOG.info("8 - " + System.currentTimeMillis());
        }
    }

    @Override
    public void commit() throws SQLException {
        long start = System.currentTimeMillis();
        this.jdbcConn.commit();
        if ((this.interest & 2) != 0) {
            LOG.info("COMMIT - " + (System.currentTimeMillis() - start) + "ms");
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return new ManagedStatement(this.jdbcConn.createStatement(), this.interest, LOG);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ManagedStatement(this.jdbcConn.createStatement(resultSetType, resultSetConcurrency), this.interest, LOG);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ManagedStatement(this.jdbcConn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability), this.interest, LOG);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.jdbcConn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.jdbcConn.getCatalog();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.jdbcConn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.jdbcConn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.jdbcConn.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.jdbcConn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.jdbcConn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.jdbcConn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.jdbcConn.isReadOnly();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.jdbcConn.nativeSQL(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.jdbcConn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.jdbcConn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.jdbcConn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new ManagedPreparedStatement(this.jdbcConn.prepareStatement(sql), sql, this.interest, LOG);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new ManagedPreparedStatement(this.jdbcConn.prepareStatement(sql, autoGeneratedKeys), sql, this.interest, LOG);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new ManagedPreparedStatement(this.jdbcConn.prepareStatement(sql, columnIndexes), sql, this.interest, LOG);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new ManagedPreparedStatement(this.jdbcConn.prepareStatement(sql, columnNames), sql, this.interest, LOG);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new ManagedPreparedStatement(this.jdbcConn.prepareStatement(sql, resultSetType, resultSetConcurrency), sql, this.interest, LOG);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new ManagedPreparedStatement(this.jdbcConn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability), sql, this.interest, LOG);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.jdbcConn.releaseSavepoint(savepoint);
    }

    @Override
    public void rollback() throws SQLException {
        this.jdbcConn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.jdbcConn.rollback(savepoint);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.jdbcConn.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.jdbcConn.setCatalog(catalog);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.jdbcConn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.jdbcConn.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.jdbcConn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.jdbcConn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.jdbcConn.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.jdbcConn.setTypeMap(map);
    }
}

