/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.storage.value.ValueFile;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordNotFoundException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

public class CASValueFileImpl
implements ValueFile {
    private static final Log LOG = ExoLogger.getLogger("jcr.CASValueFileImpl");
    String propId;
    ValueContentAddressStorage vcas;
    File file;
    FileCleaner cleaner;

    CASValueFileImpl(String propId, File file, ValueContentAddressStorage vcas) {
        this.propId = propId;
        this.vcas = vcas;
        this.file = file;
    }

    CASValueFileImpl(String propId, File file, ValueContentAddressStorage vcas, FileCleaner cleaner) {
        this(propId, file, vcas);
        this.cleaner = cleaner;
    }

    public void rollback() {
        try {
            this.vcas.delete(this.propId);
            if (!this.vcas.hasSharedContent(this.propId) && !this.file.delete() && this.cleaner != null) {
                this.cleaner.addFile(this.file);
            }
        }
        catch (RecordNotFoundException e) {
            LOG.error(e.getMessage(), e);
        }
        catch (VCASException e) {
            LOG.error(e.getMessage(), e);
        }
    }
}

