/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.VCASException;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileDigestOutputStream;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileIOChannel;
import org.exoplatform.services.log.ExoLogger;

public class CASableIOSupport {
    private static Log LOG = ExoLogger.getLogger("jcr.CASeableIOSupport");
    public static final int HASHFILE_ORDERNUMBER = 0;
    protected final FileIOChannel channel;
    protected final String digestAlgo;

    CASableIOSupport(FileIOChannel channel, String digestAlgo) {
        this.channel = channel;
        this.digestAlgo = digestAlgo;
    }

    FileDigestOutputStream openFile(File file) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance(this.digestAlgo);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Can't wriet using " + this.digestAlgo + " algorithm, " + e, e);
            throw new IOException(e.getMessage());
        }
        return new FileDigestOutputStream(file, md);
    }

    File saveFile(FileDigestOutputStream dout) throws IOException, RecordAlreadyExistsException {
        File vcasFile = new File(this.channel.rootDir, this.channel.makeFilePath(dout.getDigestHash(), 0));
        vcasFile.getParentFile().mkdirs();
        if (vcasFile.exists()) {
            dout.getFile().delete();
        } else if (!dout.getFile().renameTo(vcasFile)) {
            throw new VCASException("File " + dout.getFile().getAbsolutePath() + " can't be renamed to VCAS-named " + vcasFile.getAbsolutePath());
        }
        return vcasFile;
    }
}

