/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.value.fs;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.storage.value.ValueFile;
import org.exoplatform.services.jcr.impl.storage.value.cas.RecordAlreadyExistsException;
import org.exoplatform.services.jcr.impl.storage.value.cas.ValueContentAddressStorage;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASValueFileImpl;
import org.exoplatform.services.jcr.impl.storage.value.fs.CASableIOSupport;
import org.exoplatform.services.jcr.impl.storage.value.fs.FileDigestOutputStream;
import org.exoplatform.services.jcr.impl.storage.value.fs.SimpleFileIOChannel;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.log.ExoLogger;

public class CASableSimpleFileIOChannel
extends SimpleFileIOChannel {
    private static final Log LOG = ExoLogger.getLogger("jcr.CASableSimpleFileIOChannel");
    private final CASableIOSupport cas;
    private final ValueContentAddressStorage vcas;

    public CASableSimpleFileIOChannel(File rootDir, FileCleaner cleaner, String storageId, ValueContentAddressStorage vcas, String digestAlgo) {
        super(rootDir, cleaner, storageId);
        this.vcas = vcas;
        this.cas = new CASableIOSupport(this, digestAlgo);
    }

    public ValueFile write(String propertyId, ValueData value) throws IOException {
        File temp = new File(this.rootDir, propertyId + value.getOrderNumber() + ".cas-temp");
        FileDigestOutputStream out = this.cas.openFile(temp);
        this.writeOutput(out, value);
        out.close();
        try {
            this.vcas.add(propertyId, value.getOrderNumber(), out.getDigestHash());
            File vcasFile = this.cas.saveFile(out);
            return new CASValueFileImpl(propertyId, vcasFile, this.vcas, this.cleaner);
        }
        catch (RecordAlreadyExistsException e) {
            if (!temp.delete()) {
                LOG.warn("Can't delete cas-temp file. Added to file cleaner. " + temp.getAbsolutePath());
                this.cleaner.addFile(temp);
            }
            throw new RecordAlreadyExistsException("Write error: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String propertyId) throws IOException {
        boolean bl;
        try {
            bl = super.delete(propertyId);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.vcas.delete(propertyId);
            throw throwable;
        }
        this.vcas.delete(propertyId);
        return bl;
    }

    protected File getFile(String propertyId, int orderNumber) throws IOException {
        return super.getFile(this.vcas.getIdentifier(propertyId, orderNumber), 0);
    }

    protected File[] getFiles(String propertyId) throws IOException {
        List<String> hids = this.vcas.getIdentifiers(propertyId, true);
        File[] files = new File[hids.size()];
        for (int i = 0; i < hids.size(); ++i) {
            files[i] = super.getFile(hids.get(i), 0);
        }
        return files;
    }
}

