/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFormatException;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.util.ItemDataReader;
import org.exoplatform.services.jcr.impl.util.PropertyDataReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDataReader
extends ItemDataReader {
    private final HashMap<InternalQName, NodeInfo> nodes = new HashMap();
    private final HashMap<InternalQName, NodeInfo> nodesByType = new HashMap();
    private PropertyDataReader nodePropertyReader = null;
    private final List<NodeData> skiped = new ArrayList<NodeData>();
    private boolean rememberSkiped = false;

    public NodeDataReader(NodeData node, DataManager dataManager) {
        super(node, dataManager);
    }

    public NodeDataReader forNodesByType(InternalQName name) {
        this.nodesByType.put(name, new NodeInfo(name, new ArrayList<NodeDataReader>()));
        return this;
    }

    public NodeDataReader forNode(InternalQName name) {
        this.nodes.put(name, new NodeInfo(name, new ArrayList<NodeDataReader>()));
        return this;
    }

    public List<NodeDataReader> getNodes(InternalQName name) throws PathNotFoundException {
        List<NodeDataReader> nr = this.nodes.get(name).getChildNodesReaders();
        if (nr.size() > 0) {
            return nr;
        }
        throw new PathNotFoundException("Node with name " + this.parent.getQPath().getAsString() + name.getAsString() + " not found");
    }

    public List<NodeDataReader> getNodesByType(InternalQName typeName) throws PathNotFoundException {
        List<NodeDataReader> nr = this.nodesByType.get(typeName).getChildNodesReaders();
        if (nr.size() > 0) {
            return nr;
        }
        throw new PathNotFoundException("Nodes with type " + typeName.getAsString() + " not found. Parent " + this.parent.getQPath().getAsString());
    }

    public ValueData getPropertyValue(InternalQName name) throws ValueFormatException, PathNotFoundException, RepositoryException {
        return this.nodePropertyReader.getPropertyValue(name);
    }

    public List<ValueData> getPropertyValues(InternalQName name) throws ValueFormatException, PathNotFoundException, RepositoryException {
        return this.nodePropertyReader.getPropertyValues(name);
    }

    public PropertyDataReader forProperty(InternalQName name, int type) {
        if (this.nodePropertyReader == null) {
            this.nodePropertyReader = new PropertyDataReader(this.parent, this.dataManager);
        }
        return this.nodePropertyReader.forProperty(name, type);
    }

    public void read() throws RepositoryException {
        this.cleanReaders();
        if (this.nodePropertyReader != null) {
            this.nodePropertyReader.read();
        }
        if (this.nodes.size() > 0 || this.nodesByType.size() > 0 || this.rememberSkiped) {
            List<NodeData> ndNodes = this.dataManager.getChildNodesData(this.parent);
            for (NodeData node : ndNodes) {
                NodeInfo nodesByTypeInfo;
                boolean isSkiped = true;
                NodeDataReader cnReader = new NodeDataReader(node, this.dataManager);
                NodeInfo nodeInfo = this.nodes.get(node.getQPath().getName());
                if (nodeInfo != null) {
                    nodeInfo.getChildNodesReaders().add(cnReader);
                    isSkiped = false;
                }
                if ((nodesByTypeInfo = this.nodesByType.get(node.getPrimaryTypeName())) != null) {
                    nodesByTypeInfo.getChildNodesReaders().add(cnReader);
                    isSkiped = false;
                }
                if (!isSkiped || !this.rememberSkiped) continue;
                this.skiped.add(node);
            }
        }
    }

    private void cleanReaders() {
        for (Map.Entry<InternalQName, NodeInfo> nodesEntry : this.nodes.entrySet()) {
            nodesEntry.getValue().getChildNodesReaders().clear();
        }
        for (Map.Entry<InternalQName, NodeInfo> nodesEntry : this.nodesByType.entrySet()) {
            nodesEntry.getValue().getChildNodesReaders().clear();
        }
        this.skiped.clear();
    }

    public void clean() {
        this.nodes.clear();
        this.nodesByType.clear();
        this.skiped.clear();
        this.nodePropertyReader = null;
    }

    public boolean isRememberSkiped() {
        return this.rememberSkiped;
    }

    public void setRememberSkiped(boolean rememberSkiped) {
        this.rememberSkiped = rememberSkiped;
    }

    public List<NodeData> getSkiped() {
        return this.skiped;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeInfo {
        private final InternalQName nodeName;
        private final List<NodeDataReader> childNodesReaders;

        NodeInfo(InternalQName nodeName, List<NodeDataReader> childNodesReaders) {
            this.nodeName = nodeName;
            this.childNodesReaders = childNodesReaders;
        }

        public InternalQName getNodeName() {
            return this.nodeName;
        }

        public List<NodeDataReader> getChildNodesReaders() {
            return this.childNodesReaders;
        }
    }
}

