/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.storage.value;

import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.datamodel.QPath;

public final class ValuePluginFilter {
    private final int propertyType;
    private final QPath ancestorPath;
    private final InternalQName propertyName;
    private final long minValueSize;

    public ValuePluginFilter() throws RepositoryConfigurationException {
        this(2, null, null, 0L);
    }

    public ValuePluginFilter(int propertyType, QPath ancestorPath, InternalQName propertyName, long minValueSize) throws RepositoryConfigurationException {
        if (propertyType == 0) {
            throw new RepositoryConfigurationException("Property type is obligatory");
        }
        this.propertyType = propertyType;
        this.ancestorPath = ancestorPath;
        this.propertyName = propertyName;
        this.minValueSize = minValueSize > 0L ? minValueSize : -1L;
    }

    public QPath getAncestorPath() {
        return this.ancestorPath;
    }

    public InternalQName getPropertyName() {
        return this.propertyName;
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public boolean match(PropertyData prop, int valueOrderNumer) {
        return !(this.propertyType != prop.getType() || this.ancestorPath != null && !prop.getQPath().isDescendantOf(this.ancestorPath) || this.minValueSize != -1L && (prop.getValues().get(valueOrderNumer).getLength() <= this.minValueSize || this.minValueSize <= 0L) || this.propertyName != null && !prop.getQPath().getName().equals(this.propertyName));
    }

    public long getMinValueSize() {
        return this.minValueSize;
    }
}

