/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.organization.GroupEventListener;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.OrganizationServiceInitializer;
import org.exoplatform.services.organization.UserEventListener;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.UserProfileEventListener;
import org.exoplatform.services.organization.UserProfileHandler;
import org.picocontainer.Startable;

public abstract class BaseOrganizationService
implements OrganizationService,
Startable {
    protected UserHandler userDAO_;
    protected UserProfileHandler userProfileDAO_;
    protected GroupHandler groupDAO_;
    protected MembershipHandler membershipDAO_;
    protected MembershipTypeHandler membershipTypeDAO_;
    protected List<OrganizationServiceInitializer> listeners_ = new ArrayList<OrganizationServiceInitializer>(3);

    public UserHandler getUserHandler() {
        return this.userDAO_;
    }

    public UserProfileHandler getUserProfileHandler() {
        return this.userProfileDAO_;
    }

    public GroupHandler getGroupHandler() {
        return this.groupDAO_;
    }

    public MembershipTypeHandler getMembershipTypeHandler() {
        return this.membershipTypeDAO_;
    }

    public MembershipHandler getMembershipHandler() {
        return this.membershipDAO_;
    }

    public void start() {
        try {
            for (int i = 0; i < this.listeners_.size(); ++i) {
                OrganizationServiceInitializer listener = this.listeners_.get(i);
                listener.init(this);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void stop() {
    }

    public synchronized void addListenerPlugin(ComponentPlugin listener) throws Exception {
        if (listener instanceof UserEventListener) {
            this.userDAO_.addUserEventListener((UserEventListener)listener);
        } else if (listener instanceof GroupEventListener) {
            this.groupDAO_.addGroupEventListener((GroupEventListener)listener);
        } else if (listener instanceof MembershipEventListener) {
            this.membershipDAO_.addMembershipEventListener((MembershipEventListener)listener);
        } else if (listener instanceof UserProfileEventListener) {
            this.userProfileDAO_.addUserProfileEventListener((UserProfileEventListener)listener);
        } else if (listener instanceof OrganizationServiceInitializer) {
            this.listeners_.add((OrganizationServiceInitializer)((Object)listener));
        } else {
            throw new RuntimeException(listener.getClass().getName() + " is an unknown listener type");
        }
    }
}

