/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.exoplatform.services.resources.InputStreamURLStreamHandler;
import org.exoplatform.services.resources.XMLResourceBundleParser;

public class PropertiesClassLoader
extends ClassLoader {
    public PropertiesClassLoader(ClassLoader parent) {
        super(parent);
    }

    public PropertiesClassLoader() {
    }

    protected URL findResource(String name) {
        String xmlName;
        URL xmlURL;
        if (name.endsWith(".properties") && (xmlURL = super.getResource(xmlName = name.substring(0, name.length() - ".properties".length()) + ".xml")) != null) {
            try {
                InputStream in = xmlURL.openStream();
                Properties props = XMLResourceBundleParser.asProperties(in);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                props.store(out, null);
                out.close();
                in = new ByteArrayInputStream(out.toByteArray());
                return new URL(xmlURL, "", new InputStreamURLStreamHandler(in));
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return super.findResource(name);
    }
}

