/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.rest.GenericContainerRequest;
import org.exoplatform.services.rest.GenericContainerResponse;
import org.exoplatform.services.rest.RequestFilter;
import org.exoplatform.services.rest.RequestHandler;
import org.exoplatform.services.rest.ResponseFilter;
import org.exoplatform.services.rest.impl.ApplicationContext;
import org.exoplatform.services.rest.impl.RequestDispatcher;
import org.exoplatform.services.rest.impl.RequestFilterComponentPlugin;
import org.exoplatform.services.rest.impl.ResponseFilterComponentPlugin;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.method.MethodInvokerFilterComponentPlugin;
import org.exoplatform.services.rest.impl.provider.ByteEntityProvider;
import org.exoplatform.services.rest.impl.provider.DOMSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.DataSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.EntityProviderComponentPlugin;
import org.exoplatform.services.rest.impl.provider.EntityProviderMap;
import org.exoplatform.services.rest.impl.provider.FileEntityProvider;
import org.exoplatform.services.rest.impl.provider.InputStreamEntityProvider;
import org.exoplatform.services.rest.impl.provider.JAXBContextResolver;
import org.exoplatform.services.rest.impl.provider.JAXBElementEntityProvider;
import org.exoplatform.services.rest.impl.provider.JAXBObjectEntityProvider;
import org.exoplatform.services.rest.impl.provider.JsonEntityProvider;
import org.exoplatform.services.rest.impl.provider.MultipartFormDataEntityProvider;
import org.exoplatform.services.rest.impl.provider.MultivaluedMapEntityProvider;
import org.exoplatform.services.rest.impl.provider.ReaderEntityProvider;
import org.exoplatform.services.rest.impl.provider.SAXSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.StreamOutputEntityProvider;
import org.exoplatform.services.rest.impl.provider.StreamSourceEntityProvider;
import org.exoplatform.services.rest.impl.provider.StringEntityProvider;
import org.exoplatform.services.rest.impl.uri.UriPattern;
import org.exoplatform.services.rest.method.MethodInvokerFilter;
import org.exoplatform.services.rest.provider.EntityProvider;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RequestHandlerImpl
implements RequestHandler,
Startable {
    private final EntityProviderMap readProviderMap;
    private final EntityProviderMap writeProviderMap;
    private final RequestDispatcher dispatcher;
    private final List<MethodInvokerFilter> invokerFilters;
    private final JAXBContextResolver jaxbContexts;
    private final FilterMap<UriPattern, RequestFilter> requestFilters;
    private final FilterMap<UriPattern, ResponseFilter> responseFilters;
    private Map<String, Object> attributes;

    public RequestHandlerImpl(RequestDispatcher dispatcher, JAXBContextResolver jaxbContexts) {
        this.dispatcher = dispatcher;
        this.jaxbContexts = jaxbContexts;
        this.readProviderMap = new EntityProviderMap();
        this.writeProviderMap = new EntityProviderMap();
        this.invokerFilters = new ArrayList<MethodInvokerFilter>();
        this.requestFilters = new FilterMap();
        this.responseFilters = new FilterMap();
    }

    @Override
    public void handleRequest(GenericContainerRequest request, GenericContainerResponse response) throws IOException {
        URI uri = UriBuilder.fromUri(request.getRequestUri()).replaceQuery(null).fragment(null).build(new Object[0]);
        String path = uri.getRawPath().substring(request.getBaseUri().getRawPath().length());
        ArrayList<String> t = new ArrayList<String>();
        for (Map.Entry e : this.requestFilters.entrySet()) {
            if (!((UriPattern)e.getKey()).match(path, t)) continue;
            for (RequestFilter f : (List)e.getValue()) {
                f.doFilter(request);
            }
        }
        ApplicationContext context = new ApplicationContext(this, request, response);
        ApplicationContext.setCurrent(context);
        try {
            this.dispatcher.dispatch(request, response);
        }
        catch (WebApplicationException e) {
            RequestHandlerImpl.processError(e, response);
        }
        for (Map.Entry e : this.responseFilters.entrySet()) {
            if (!((UriPattern)e.getKey()).match(path, t)) continue;
            for (ResponseFilter f : (List)e.getValue()) {
                f.doFilter(response);
            }
        }
        try {
            response.writeResponse();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException();
        }
        finally {
            ApplicationContext.setCurrent(null);
        }
    }

    @Override
    public List<MethodInvokerFilter> getInvokerFilters() {
        return this.invokerFilters;
    }

    private static void processError(WebApplicationException e, GenericContainerResponse response) {
        Response r = e.getResponse();
        if (r.getStatus() < 500) {
            response.setResponse(r);
        } else {
            e.printStackTrace();
            if (r.getEntity() == null) {
                r = Response.status(r.getStatus()).entity(new ErrorStreaming(e)).type("text/plain").build();
            }
            response.setResponse(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntityProvider(EntityProvider<?> provider) {
        Consumes consumesAnnotation = provider.getClass().getAnnotation(Consumes.class);
        Produces producesAnnotation = provider.getClass().getAnnotation(Produces.class);
        List<MediaType> consumes = MediaTypeHelper.createConsumesList(consumesAnnotation);
        List<MediaType> produces = MediaTypeHelper.createProducesList(producesAnnotation);
        EntityProviderMap entityProviderMap = this.readProviderMap;
        synchronized (entityProviderMap) {
            for (MediaType mime : consumes) {
                this.readProviderMap.getList(mime).add(provider);
            }
        }
        entityProviderMap = this.writeProviderMap;
        synchronized (entityProviderMap) {
            for (MediaType mime : produces) {
                this.writeProviderMap.getList(mime).add(provider);
            }
        }
    }

    @Override
    public MessageBodyWriter<?> getMessageBodyWriter(Class<?> type, Type genericType, Annotation[] annotations, MediaType contentType) {
        if (contentType == null) {
            return this.getMessageBodyWriter0(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        MessageBodyWriter<?> writer = this.getMessageBodyWriter0(type, genericType, annotations, contentType);
        if (writer == null) {
            writer = this.getMessageBodyWriter0(type, genericType, annotations, new MediaType(contentType.getType(), "*"));
        }
        if (writer == null) {
            writer = this.getMessageBodyWriter0(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        return writer;
    }

    private MessageBodyWriter<?> getMessageBodyWriter0(Class<?> type, Type genericType, Annotation[] annotations, MediaType contentType) {
        for (EntityProvider<?> e : this.writeProviderMap.getList(contentType)) {
            if (!e.isWriteable(type, genericType, annotations, contentType)) continue;
            return e;
        }
        return null;
    }

    @Override
    public MessageBodyReader<?> getMessageBodyReader(Class<?> type, Type genericType, Annotation[] annotations, MediaType contentType) {
        if (contentType == null) {
            return this.getMessageBodyReader0(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        MessageBodyReader<?> reader = this.getMessageBodyReader0(type, genericType, annotations, contentType);
        if (reader == null) {
            reader = this.getMessageBodyReader0(type, genericType, annotations, new MediaType(contentType.getType(), "*"));
        }
        if (reader == null) {
            reader = this.getMessageBodyReader0(type, genericType, annotations, MediaTypeHelper.DEFAULT_TYPE);
        }
        return reader;
    }

    private MessageBodyReader<?> getMessageBodyReader0(Class<?> type, Type genericType, Annotation[] annotations, MediaType contentType) {
        for (EntityProvider<?> e : this.readProviderMap.getList(contentType)) {
            if (!e.isReadable(type, genericType, annotations, contentType)) continue;
            return e;
        }
        return null;
    }

    @Override
    public List<MediaType> getAcceptableWriterMediaTypes(Class<?> type, Type genericType, Annotation[] annotations) {
        ArrayList<MediaType> l = new ArrayList<MediaType>();
        for (Map.Entry e : this.writeProviderMap.entrySet()) {
            MediaType m = (MediaType)e.getKey();
            for (EntityProvider p : (List)e.getValue()) {
                if (!p.isWriteable(type, genericType, annotations, null)) continue;
                l.add(m);
            }
        }
        Collections.sort(l, MediaTypeHelper.MEDIA_TYPE_COMPARATOR);
        return l;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes == null ? (this.attributes = new HashMap<String, Object>()) : this.attributes;
    }

    @Override
    public void start() {
        this.init();
    }

    protected void init() {
        this.addEntityProvider(new ByteEntityProvider());
        this.addEntityProvider(new DataSourceEntityProvider());
        this.addEntityProvider(new DOMSourceEntityProvider());
        this.addEntityProvider(new FileEntityProvider());
        this.addEntityProvider(new MultivaluedMapEntityProvider());
        this.addEntityProvider(new MultipartFormDataEntityProvider());
        this.addEntityProvider(new InputStreamEntityProvider());
        this.addEntityProvider(new ReaderEntityProvider());
        this.addEntityProvider(new SAXSourceEntityProvider());
        this.addEntityProvider(new StreamSourceEntityProvider());
        this.addEntityProvider(new StringEntityProvider());
        this.addEntityProvider(new StreamOutputEntityProvider());
        this.addEntityProvider(new JsonEntityProvider());
        JAXBElementEntityProvider jep = new JAXBElementEntityProvider();
        jep.setContexResolver(this.jaxbContexts);
        this.addEntityProvider(jep);
        JAXBObjectEntityProvider jop = new JAXBObjectEntityProvider();
        jop.setContexResolver(this.jaxbContexts);
        this.addEntityProvider(jop);
    }

    public void addPlugin(ComponentPlugin plugin) {
        block4: {
            block6: {
                block5: {
                    block3: {
                        if (!MethodInvokerFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block3;
                        this.invokerFilters.addAll(((MethodInvokerFilterComponentPlugin)plugin).getFilters());
                        break block4;
                    }
                    if (!EntityProviderComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block5;
                    List<EntityProvider<?>> eps = ((EntityProviderComponentPlugin)plugin).getEntityProviders();
                    for (EntityProvider<?> ep : eps) {
                        this.addEntityProvider(ep);
                    }
                    break block4;
                }
                if (!RequestFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block6;
                List<RequestFilter> filters = ((RequestFilterComponentPlugin)plugin).getFilters();
                for (RequestFilter filter : filters) {
                    this.addRequestFilter(filter);
                }
                break block4;
            }
            if (!ResponseFilterComponentPlugin.class.isAssignableFrom(plugin.getClass())) break block4;
            List<ResponseFilter> filters = ((ResponseFilterComponentPlugin)plugin).getFilters();
            for (ResponseFilter filter : filters) {
                this.addResponseFilter(filter);
            }
        }
    }

    private void addRequestFilter(RequestFilter filter) {
        Path pathAnnotation = filter.getClass().getAnnotation(Path.class);
        String path = pathAnnotation == null ? "/" : pathAnnotation.value();
        UriPattern uriPattern = new UriPattern(path);
        this.requestFilters.getList(uriPattern).add(filter);
    }

    private void addResponseFilter(ResponseFilter filter) {
        Path pathAnnotation = filter.getClass().getAnnotation(Path.class);
        String path = pathAnnotation == null ? "/" : pathAnnotation.value();
        UriPattern uriPattern = new UriPattern(path);
        this.responseFilters.getList(uriPattern).add(filter);
    }

    @Override
    public void stop() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilterMap<T, V>
    extends HashMap<T, List<V>> {
        private static final long serialVersionUID = 8248982446381545144L;

        private FilterMap() {
        }

        public List<V> getList(T uriPattern) {
            ArrayList l = (ArrayList)this.get(uriPattern);
            if (l == null) {
                l = new ArrayList();
                this.put(uriPattern, l);
            }
            return l;
        }
    }

    static class ErrorStreaming
    implements StreamingOutput {
        private final Exception e;

        ErrorStreaming(Exception e) {
            this.e = e;
        }

        public void write(OutputStream output) {
            PrintWriter pw = new PrintWriter(output);
            this.e.printStackTrace(pw);
            pw.flush();
        }
    }
}

