/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.impl.header.AcceptMediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MediaTypeHelper {
    public static final Comparator<MediaType> MEDIA_TYPE_COMPARATOR = new Comparator<MediaType>(){

        @Override
        public int compare(MediaType o1, MediaType o2) {
            if (o1.getType().equals("*") && !o2.getType().equals("*")) {
                return 1;
            }
            if (!o1.getType().equals("*") && o2.getType().equals("*")) {
                return -1;
            }
            if (o1.getSubtype().equals("*") && !o2.getSubtype().equals("*")) {
                return 1;
            }
            if (!o1.getSubtype().equals("*") && o2.getSubtype().equals("*")) {
                return -1;
            }
            return 0;
        }
    };
    public static final String DEFAULT = "*/*";
    public static final MediaType DEFAULT_TYPE = new MediaType("*", "*");
    public static final List<MediaType> DEFAULT_TYPE_LIST = Collections.singletonList(DEFAULT_TYPE);
    public static final String WADL = "application/vnd.sun.wadl+xml";
    public static final MediaType WADL_TYPE = new MediaType("application", "vnd.sun.wadl+xml");

    private MediaTypeHelper() {
    }

    public static List<MediaType> createConsumesList(Consumes mime) {
        if (mime == null) {
            return DEFAULT_TYPE_LIST;
        }
        return MediaTypeHelper.createMediaTypesList(mime.value());
    }

    public static List<MediaType> createProducesList(Produces mime) {
        if (mime == null) {
            return DEFAULT_TYPE_LIST;
        }
        return MediaTypeHelper.createMediaTypesList(mime.value());
    }

    public static boolean isConsume(List<MediaType> consumes, MediaType contentType) {
        for (MediaType c : consumes) {
            if (!contentType.isCompatible(c)) continue;
            return true;
        }
        return false;
    }

    private static List<MediaType> createMediaTypesList(String[] mimes) {
        ArrayList<MediaType> l = new ArrayList<MediaType>(mimes.length);
        for (String m : mimes) {
            l.add(MediaType.valueOf(m));
        }
        Collections.sort(l, MEDIA_TYPE_COMPARATOR);
        return l;
    }

    public static float processQuality(List<MediaType> accept, List<MediaType> produces) {
        for (AcceptMediaType acceptMediaType : accept) {
            if ("*".equals(acceptMediaType.getType())) {
                return acceptMediaType.getQvalue();
            }
            for (MediaType p : produces) {
                if (!p.isCompatible(acceptMediaType)) continue;
                return acceptMediaType.getQvalue();
            }
        }
        return 0.0f;
    }
}

