/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;

public final class IOHelper {
    private static final int DEFAULT_MAX_BUFFER_SIZE = 204800;
    private static int bufferSize = -1;
    static final Charset DEFAULT_CHARSET = Charset.forName("UTF-8");
    private static Object lock = new Object();

    private IOHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxBufferSize(int size) {
        Object object = lock;
        synchronized (object) {
            if (bufferSize >= 0) {
                throw new IllegalStateException("Buffer size already defined. ");
            }
            bufferSize = size;
        }
    }

    static int getMaxBufferSize() {
        if (bufferSize < 0) {
            bufferSize = 204800;
        }
        return bufferSize;
    }

    static void write(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[1024];
        int rd = -1;
        while ((rd = in.read(buf)) != -1) {
            out.write(buf, 0, rd);
        }
    }

    static void write(Reader in, Writer out) throws IOException {
        char[] buf = new char[1024];
        int rd = -1;
        while ((rd = in.read(buf)) != -1) {
            out.write(buf, 0, rd);
        }
    }

    static String readString(InputStream in, String cs) throws IOException {
        Charset charset;
        try {
            charset = cs != null ? Charset.forName(cs) : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            charset = DEFAULT_CHARSET;
        }
        InputStreamReader r = new InputStreamReader(in, charset);
        char[] buf = new char[1024];
        StringBuffer sb = new StringBuffer();
        int rd = -1;
        while ((rd = r.read(buf)) != -1) {
            sb.append(buf, 0, rd);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeString(String s, OutputStream out, String cs) throws IOException {
        Charset charset;
        try {
            charset = cs != null ? Charset.forName(cs) : DEFAULT_CHARSET;
        }
        catch (Exception e) {
            charset = DEFAULT_CHARSET;
        }
        OutputStreamWriter w = new OutputStreamWriter(out, charset);
        try {
            w.write(s);
        }
        finally {
            ((Writer)w).flush();
            ((Writer)w).close();
        }
    }
}

