/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.rest.impl.EnvironmentContext;
import org.exoplatform.services.rest.impl.provider.IOHelper;
import org.exoplatform.services.rest.provider.EntityProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Consumes(value={"multipart/*"})
public class MultipartFormDataEntityProvider
implements EntityProvider<Iterator<FileItem>> {
    private static final Log LOG = ExoLogger.getLogger(MultipartFormDataEntityProvider.class.getName());
    private static final String DEFAULT_FOLDER = "ws.rs.upload";
    private static String uploadFolder;
    private final File repo;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUploadFolder(String folder) {
        Object object = lock;
        synchronized (object) {
            if (uploadFolder != null) {
                throw new IllegalStateException("Upload folder already defined");
            }
            uploadFolder = folder;
        }
    }

    public MultipartFormDataEntityProvider() {
        if (uploadFolder == null) {
            uploadFolder = System.getProperty("java.io.tmpdir") + File.separator + DEFAULT_FOLDER;
        }
        this.repo = new File(uploadFolder);
        if (!this.repo.exists()) {
            this.repo.mkdir();
        }
        this.registerShutdownHook();
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                File[] files;
                for (File file : files = MultipartFormDataEntityProvider.this.repo.listFiles()) {
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        });
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == Iterator.class) {
            try {
                ParameterizedType t = (ParameterizedType)genericType;
                Type[] ta = t.getActualTypeArguments();
                return ta.length == 1 && ta[0] == FileItem.class;
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public Iterator<FileItem> readFrom(Class<Iterator<FileItem>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        try {
            EnvironmentContext envctx = EnvironmentContext.getCurrent();
            if (envctx == null) {
                LOG.warn("EnvironmentContext is not set.");
                return null;
            }
            if (envctx.get(HttpServletRequest.class) == null) {
                LOG.warn("HttpServletRequest is not set in current environment context.");
                return null;
            }
            DefaultFileItemFactory factory = new DefaultFileItemFactory(IOHelper.getMaxBufferSize(), this.repo);
            FileUpload upload = new FileUpload(factory);
            return upload.parseRequest((HttpServletRequest)envctx.get(HttpServletRequest.class)).iterator();
        }
        catch (FileUploadException e) {
            throw new IOException("Can't process multipart data item " + e);
        }
    }

    @Override
    public long getSize(Iterator<FileItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return false;
    }

    @Override
    public void writeTo(Iterator<FileItem> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        lock = new Object();
    }
}

