/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.exoplatform.services.rest.impl.header.MediaTypeHelper;
import org.exoplatform.services.rest.impl.method.DefaultMethodInvoker;
import org.exoplatform.services.rest.impl.method.MethodParameter;
import org.exoplatform.services.rest.impl.method.MethodParameterHelper;
import org.exoplatform.services.rest.impl.resource.AbstractResourceDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.PathValue;
import org.exoplatform.services.rest.impl.resource.ResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.SubResourceLocatorDescriptorImpl;
import org.exoplatform.services.rest.impl.resource.SubResourceMethodDescriptorImpl;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceDescriptorFactory {
    private ResourceDescriptorFactory() {
    }

    public static AbstractResourceDescriptor createAbstractResourceDescriptor(Class<?> resourceClass) {
        AbstractResourceDescriptorImpl resourceDescriptor = null;
        Path pathAnnotation = resourceClass.getAnnotation(Path.class);
        if (pathAnnotation != null) {
            PathValue path = new PathValue(pathAnnotation.value());
            resourceDescriptor = new AbstractResourceDescriptorImpl(path, resourceClass);
        } else {
            resourceDescriptor = new AbstractResourceDescriptorImpl(resourceClass);
        }
        boolean encoded = resourceClass.getAnnotation(Encoded.class) != null;
        Consumes consumesAnnotation = resourceClass.getAnnotation(Consumes.class);
        Produces producesAnnotation = resourceClass.getAnnotation(Produces.class);
        List<MediaType> consumes = MediaTypeHelper.createConsumesList(consumesAnnotation);
        List<MediaType> produces = MediaTypeHelper.createProducesList(producesAnnotation);
        ResourceDescriptorFactory.addResourceMethodDescriptor(resourceDescriptor, ResourceDescriptorFactory.createMethodList(resourceClass.getMethods()), consumes, produces, encoded);
        ResourceDescriptorFactory.addSubResourceMethodDescriptor(resourceDescriptor, ResourceDescriptorFactory.createMethodList(resourceClass.getMethods()), consumes, produces, encoded);
        ResourceDescriptorFactory.addSubResourceLocatordDescriptor(resourceDescriptor, ResourceDescriptorFactory.createMethodList(resourceClass.getMethods()), encoded);
        return resourceDescriptor;
    }

    private static void addResourceMethodDescriptor(AbstractResourceDescriptor resourceDescriptor, List<Method> methods, List<MediaType> consumesFromParent, List<MediaType> producesFromParent, boolean encodedFromParent) {
        ResourceDescriptorFactory.retainWithMetaAnnotation(methods, HttpMethod.class);
        ResourceDescriptorFactory.removeWithAnnotaion(methods, Path.class);
        for (Method method : methods) {
            String httpMethod = ResourceDescriptorFactory.getMetaAnnotations(method, HttpMethod.class).get(0).value();
            List<MediaType> consumes = ResourceDescriptorFactory.resolveConsumesMediaType(method, consumesFromParent);
            List<MediaType> produces = ResourceDescriptorFactory.resolveProducesMediaType(method, producesFromParent);
            List<MethodParameter> methodParameters = ResourceDescriptorFactory.createParametersList(method, encodedFromParent);
            ResourceMethodDescriptorImpl resMethodDescriptor = new ResourceMethodDescriptorImpl(method, httpMethod, methodParameters, resourceDescriptor, consumes, produces, new DefaultMethodInvoker());
            resourceDescriptor.getResourceMethodDescriptors().add(resMethodDescriptor);
        }
    }

    private static void addSubResourceMethodDescriptor(AbstractResourceDescriptor resourceDescriptor, List<Method> methods, List<MediaType> consumesFromParent, List<MediaType> producesFromParent, boolean encodedFromParent) {
        ResourceDescriptorFactory.retainWithMetaAnnotation(methods, HttpMethod.class);
        ResourceDescriptorFactory.retainWithAnnotation(methods, Path.class);
        for (Method method : methods) {
            String httpMethod = ResourceDescriptorFactory.getMetaAnnotations(method, HttpMethod.class).get(0).value();
            List<MediaType> consumes = ResourceDescriptorFactory.resolveConsumesMediaType(method, consumesFromParent);
            List<MediaType> produces = ResourceDescriptorFactory.resolveProducesMediaType(method, producesFromParent);
            List<MethodParameter> methodParameters = ResourceDescriptorFactory.createParametersList(method, encodedFromParent);
            Path p = method.getAnnotation(Path.class);
            PathValue pathValue = new PathValue(p.value());
            SubResourceMethodDescriptorImpl subresMethodDescriptor = new SubResourceMethodDescriptorImpl(pathValue, method, httpMethod, methodParameters, resourceDescriptor, consumes, produces, new DefaultMethodInvoker());
            resourceDescriptor.getSubResourceMethodDescriptors().add(subresMethodDescriptor);
        }
    }

    private static void addSubResourceLocatordDescriptor(AbstractResourceDescriptor resourceDescriptor, List<Method> methods, boolean encodedFromParent) {
        ResourceDescriptorFactory.retainWithAnnotation(methods, Path.class);
        ResourceDescriptorFactory.removeWithMetaAnnotation(methods, HttpMethod.class);
        for (Method method : methods) {
            List<MethodParameter> methodParameters = ResourceDescriptorFactory.createParametersList(method, encodedFromParent);
            Path p = method.getAnnotation(Path.class);
            PathValue pathValue = new PathValue(p.value());
            SubResourceLocatorDescriptorImpl subresLocatorDescriptor = new SubResourceLocatorDescriptorImpl(pathValue, method, methodParameters, resourceDescriptor, new DefaultMethodInvoker());
            resourceDescriptor.getSubResourceLocatorDescriptors().add(subresLocatorDescriptor);
        }
    }

    private static List<Method> createMethodList(Method[] methods) {
        ArrayList<Method> l = new ArrayList<Method>(methods.length);
        for (Method m : methods) {
            l.add(m);
        }
        return l;
    }

    private static List<MethodParameter> createParametersList(Method m, boolean encodedFromParent) {
        ArrayList<MethodParameter> l = new ArrayList<MethodParameter>();
        Class<?>[] parameterClasses = m.getParameterTypes();
        Type[] parameterGenTypes = m.getGenericParameterTypes();
        Annotation[][] annotations = m.getParameterAnnotations();
        for (int i = 0; i < parameterClasses.length; ++i) {
            l.add(ResourceDescriptorFactory.createMethodParameter(parameterClasses[i], parameterGenTypes[i], annotations[i], encodedFromParent || m.getAnnotation(Encoded.class) != null));
        }
        return l;
    }

    private static MethodParameter createMethodParameter(Class parameterClass, Type parameterGenType, Annotation[] annotations, boolean encodedFromParent) {
        String defaultValue = null;
        Annotation annotation = null;
        boolean encoded = false;
        for (Annotation a : annotations) {
            if (MethodParameterHelper.PARAMETER_ANNOTATIONS_MAP.containsKey(a.annotationType().getName())) {
                annotation = a;
                continue;
            }
            if (a.annotationType() == Encoded.class) {
                encoded = true;
                continue;
            }
            if (a.annotationType() != DefaultValue.class) continue;
            defaultValue = ((DefaultValue)a).value();
        }
        return new MethodParameter(annotation, annotations, parameterClass, parameterGenType, defaultValue, encoded || encodedFromParent);
    }

    private static List<MediaType> resolveProducesMediaType(Method m, List<MediaType> producesFromParent) {
        Produces a = m.getAnnotation(Produces.class);
        if (a != null) {
            return MediaTypeHelper.createProducesList(a);
        }
        return producesFromParent;
    }

    private static List<MediaType> resolveConsumesMediaType(Method m, List<MediaType> consumesFromParent) {
        Consumes a = m.getAnnotation(Consumes.class);
        if (a != null) {
            return MediaTypeHelper.createConsumesList(a);
        }
        return consumesFromParent;
    }

    private static <T extends Annotation> List<T> getMetaAnnotations(Method m, Class<T> annotation) {
        Annotation[] as = m.getAnnotations();
        ArrayList<T> l = new ArrayList<T>();
        for (Annotation a : as) {
            if (a.annotationType().getAnnotation(annotation) == null) continue;
            l.add(a.annotationType().getAnnotation(annotation));
        }
        return l;
    }

    private static <T extends Annotation> boolean hasMetaAnnotation(Method m, Class<T> annotation) {
        Annotation[] as;
        for (Annotation a : as = m.getAnnotations()) {
            if (a.annotationType().getAnnotation(annotation) == null) continue;
            return true;
        }
        return false;
    }

    private static <T extends Annotation> void removeWithAnnotaion(List<Method> ms, Class<T> annotation) {
        Iterator<Method> i = ms.iterator();
        while (i.hasNext()) {
            Method m = i.next();
            if (m.getAnnotation(annotation) == null) continue;
            i.remove();
        }
    }

    private static <T extends Annotation> void removeWithMetaAnnotation(List<Method> ms, Class<T> annotation) {
        Iterator<Method> i = ms.iterator();
        while (i.hasNext()) {
            Method m = i.next();
            if (!ResourceDescriptorFactory.hasMetaAnnotation(m, annotation)) continue;
            i.remove();
        }
    }

    private static <T extends Annotation> void retainWithAnnotation(List<Method> ms, Class<T> annotation) {
        Iterator<Method> i = ms.iterator();
        while (i.hasNext()) {
            Method m = i.next();
            if (m.getAnnotation(annotation) != null) continue;
            i.remove();
        }
    }

    private static <T extends Annotation> void retainWithMetaAnnotation(List<Method> ms, Class<T> annotation) {
        Iterator<Method> i = ms.iterator();
        while (i.hasNext()) {
            Method m = i.next();
            if (ResourceDescriptorFactory.hasMetaAnnotation(m, annotation)) continue;
            i.remove();
        }
    }
}

