/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.jaas;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;

public class IdentitySetLoginModule
implements LoginModule {
    private static final String OPTION_PORTAL_CONTAINER_NAME = "portalContainerName";
    private static final String DEFAULT_PORTAL_CONTAINER_NAME = "portal";
    protected Log log = ExoLogger.getLogger("core.IdentitySetLoginModule");
    protected Subject subject;
    protected Map sharedState;
    protected boolean singleLogin = false;
    private String portalContainerName;

    public boolean abort() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("in abort");
        }
        return true;
    }

    public boolean commit() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("in commit");
        }
        String userId = (String)this.sharedState.get("javax.security.auth.login.name");
        try {
            Authenticator authenticator = (Authenticator)this.getContainer().getComponentInstanceOfType(Authenticator.class);
            if (authenticator == null) {
                throw new LoginException("No Authenticator component found, check your configuration.");
            }
            IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
            if (this.singleLogin && identityRegistry.getIdentity(userId) != null) {
                throw new LoginException("User " + userId + " already logined.");
            }
            Identity identity = authenticator.createIdentity(userId);
            identity.setSubject(this.subject);
            identityRegistry.register(identity);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new LoginException(e.getMessage());
        }
        return true;
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("in initialize");
        }
        this.subject = subject;
        this.sharedState = sharedState;
        this.portalContainerName = this.getPortalContainerName(options);
        String sl = (String)options.get("singleLogin");
        if (sl != null && (sl.equalsIgnoreCase("yes") || sl.equalsIgnoreCase("true"))) {
            this.singleLogin = true;
        }
    }

    public boolean login() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("in login");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("in logout");
        }
        return true;
    }

    protected ExoContainer getContainer() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        if (container instanceof RootContainer) {
            container = RootContainer.getInstance().getPortalContainer(this.portalContainerName);
        }
        return container;
    }

    private String getPortalContainerName(Map options) {
        String optionValue;
        if (options != null && (optionValue = (String)options.get(OPTION_PORTAL_CONTAINER_NAME)) != null && optionValue.length() > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("The IdentitySetLoginModule will use the portal container " + optionValue);
            }
            return optionValue;
        }
        return DEFAULT_PORTAL_CONTAINER_NAME;
    }
}

