/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.security.web;

import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.exoplatform.services.security.ConversationRegistry;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.web.ConversationStateListener;
import org.exoplatform.services.security.web.HttpSessionStateKey;

public class JAASConversationStateListener
extends ConversationStateListener {
    public void sessionDestroyed(HttpSessionEvent event) {
        HttpSession httpSession = event.getSession();
        HttpSessionStateKey stateKey = new HttpSessionStateKey(httpSession);
        try {
            ConversationRegistry conversationRegistry = (ConversationRegistry)this.getContainer(httpSession.getServletContext()).getComponentInstanceOfType(ConversationRegistry.class);
            ConversationState conversationState = conversationRegistry.unregister(stateKey);
            if (conversationState != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Remove conversation state " + httpSession.getId());
                }
                if (conversationState.getAttribute("subject") != null) {
                    Subject subject = (Subject)conversationState.getAttribute("subject");
                    LoginContext ctx = new LoginContext("exo-domain", subject);
                    ctx.logout();
                } else {
                    this.log.warn("Subject was not found in ConversationState attributes.");
                }
            }
        }
        catch (Exception e) {
            this.log.error("Can't remove conversation state " + httpSession.getId());
        }
    }
}

