/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.action.Executable;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.entity.Queryable;

public class BulkOperationCleanupAction
implements Executable,
Serializable {
    private final SessionImplementor session;
    private final Set affectedEntityNames = new HashSet();
    private final Set affectedCollectionRoles = new HashSet();
    private final Serializable[] spaces;

    public BulkOperationCleanupAction(SessionImplementor session, Queryable[] affectedQueryables) {
        int i;
        this.session = session;
        ArrayList<Serializable> tmpSpaces = new ArrayList<Serializable>();
        for (i = 0; i < affectedQueryables.length; ++i) {
            Set roles;
            if (affectedQueryables[i].hasCache()) {
                this.affectedEntityNames.add(affectedQueryables[i].getEntityName());
            }
            if ((roles = session.getFactory().getCollectionRolesByEntityParticipant(affectedQueryables[i].getEntityName())) != null) {
                this.affectedCollectionRoles.addAll(roles);
            }
            for (int y = 0; y < affectedQueryables[i].getQuerySpaces().length; ++y) {
                tmpSpaces.add(affectedQueryables[i].getQuerySpaces()[y]);
            }
        }
        this.spaces = new Serializable[tmpSpaces.size()];
        for (i = 0; i < tmpSpaces.size(); ++i) {
            this.spaces[i] = (Serializable)tmpSpaces.get(i);
        }
    }

    public void init() {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public boolean hasAfterTransactionCompletion() {
        return true;
    }

    public void afterTransactionCompletion(boolean success) throws HibernateException {
        this.evictEntityRegions();
        this.evictCollectionRegions();
    }

    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    public void beforeExecutions() throws HibernateException {
    }

    public void execute() throws HibernateException {
    }

    private void evictEntityRegions() {
        if (this.affectedEntityNames != null) {
            Iterator itr = this.affectedEntityNames.iterator();
            while (itr.hasNext()) {
                String entityName = (String)itr.next();
                this.session.getFactory().evictEntity(entityName);
            }
        }
    }

    private void evictCollectionRegions() {
        if (this.affectedCollectionRoles != null) {
            Iterator itr = this.affectedCollectionRoles.iterator();
            while (itr.hasNext()) {
                String roleName = (String)itr.next();
                this.session.getFactory().evictCollection(roleName);
            }
        }
    }
}

