/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.action.CollectionRemoveAction;
import org.hibernate.event.EventSource;
import org.hibernate.event.def.ProxyVisitor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.Type;

public abstract class ReattachVisitor
extends ProxyVisitor {
    private static final Log log = LogFactory.getLog(ReattachVisitor.class);
    private final Serializable key;

    final Serializable getKey() {
        return this.key;
    }

    public ReattachVisitor(EventSource session, Serializable key) {
        super(session);
        this.key = key;
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        Type[] types = componentType.getSubtypes();
        if (component == null) {
            this.processValues(new Object[types.length], types);
        } else {
            super.processComponent(component, componentType);
        }
        return null;
    }

    public void removeCollection(CollectionPersister role, Serializable id, EventSource source) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace("collection dereferenced while transient " + MessageHelper.collectionInfoString(role, id, source.getFactory()));
        }
        source.getActionQueue().addAction(new CollectionRemoveAction(null, role, id, false, source));
    }
}

