/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.modules.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.Parameter;
import xdoclet.XDocletException;
import xdoclet.XmlSubTask;
import xdoclet.modules.hibernate.HibernateProperties;
import xdoclet.util.Translator;

public class HibernateCfgSubTask
extends XmlSubTask
implements HibernateProperties {
    private static final String HIBERNATE_PUBLICID_20 = "-//Hibernate/Hibernate Configuration DTD 2.0//EN";
    private static final String HIBERNATE_SYSTEMID_20 = "http://hibernate.sourceforge.net/hibernate-configuration-2.0.dtd";
    private static final String DTD_FILE_NAME_20 = "resources/hibernate-configuration-2.0.dtd";
    private static final String HIBERNATE_PUBLICID_30 = "-//Hibernate/Hibernate Configuration DTD 3.0//EN";
    private static final String HIBERNATE_SYSTEMID_30 = "http://hibernate.sourceforge.net/hibernate-configuration-3.0.dtd";
    private static final String DTD_FILE_NAME_30 = "resources/hibernate-configuration-3.0.dtd";
    private static String DEFAULT_TEMPLATE_FILE = "resources/hibernate-cfg.xdt";
    private static String GENERATED_CONFIG_FILE_NAME = "hibernate.cfg.xml";
    private String hibernateVersion = "2.0";
    private String jndiName = null;
    private String dataSource = null;
    private String dialect = null;
    private boolean useOuterJoin = false;
    private boolean showSql = false;
    private String userName = null;
    private String password = null;
    private String userTransactionName = null;
    private String transactionManagerStrategy = null;
    private String driver;
    private String jdbcUrl;
    private String poolSize;
    private String transactionManagerLookup;
    private ArrayList jndiProperties = new ArrayList();
    private List otherProperties = new ArrayList();
    private String defaultSchema = null;
    private String cglibUseReflectionOptimizer = null;
    private String cacheProviderClass = null;
    private String transactionManagerFactory = null;
    private String hbm2ddl = null;
    private List otherMappings = new ArrayList();
    static /* synthetic */ Class class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages;

    public HibernateCfgSubTask() {
        this.setSubTaskName("hibernatecfg");
        this.setHavingClassTag("hibernate.class");
        this.setTemplateURL(this.getClass().getResource(DEFAULT_TEMPLATE_FILE));
        this.setDestinationFile(GENERATED_CONFIG_FILE_NAME);
    }

    public String getVersion() {
        return this.hibernateVersion;
    }

    public String getHbm2ddl() {
        return this.hbm2ddl;
    }

    public String getTransactionManagerLookup() {
        return this.transactionManagerLookup;
    }

    public Collection getJndiProperties() {
        return this.jndiProperties;
    }

    public Collection getOtherProperties() {
        return this.otherProperties;
    }

    public Collection getOtherMappings() {
        return this.otherMappings;
    }

    public String getTransactionManagerStrategy() {
        return this.transactionManagerStrategy;
    }

    public String getUserTransactionName() {
        return this.userTransactionName;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean getUseOuterJoin() {
        return this.useOuterJoin;
    }

    public boolean getShowSql() {
        return this.showSql;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getDialect() {
        return this.dialect;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getPoolSize() {
        return this.poolSize;
    }

    public String getCacheProviderClass() {
        return this.cacheProviderClass;
    }

    public String getCglibUseReflectionOptimizer() {
        return this.cglibUseReflectionOptimizer;
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public String getTransactionManagerFactory() {
        return this.transactionManagerFactory;
    }

    public void setVersion(HibernateCFGVersion version) {
        this.hibernateVersion = version.getValue();
    }

    public void setHbm2ddl(String hbm2ddl) {
        this.hbm2ddl = hbm2ddl;
    }

    public void setPoolSize(String poolSize) {
        this.poolSize = poolSize;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setTransactionManagerStrategy(String transactionManagerStrategy) {
        this.transactionManagerStrategy = transactionManagerStrategy;
    }

    public void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public void setTransactionManagerLookup(String transactionManagerLookup) {
        this.transactionManagerLookup = transactionManagerLookup;
    }

    public void setUseOuterJoin(boolean useOuterJoin) {
        this.useOuterJoin = useOuterJoin;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setCacheProviderClass(String string) {
        this.cacheProviderClass = string;
    }

    public void setCglibUseReflectionOptimizer(String string) {
        this.cglibUseReflectionOptimizer = string;
    }

    public void setDefaultSchema(String string) {
        this.defaultSchema = string;
    }

    public void setTransactionManagerFactory(String string) {
        this.transactionManagerFactory = string;
    }

    public void execute() throws XDocletException {
        if (this.hibernateVersion.equals("2.0")) {
            this.setPublicId(HIBERNATE_PUBLICID_20);
            this.setSystemId(HIBERNATE_SYSTEMID_20);
            this.setDtdURL(this.getClass().getResource(DTD_FILE_NAME_20));
        } else {
            this.setPublicId(HIBERNATE_PUBLICID_30);
            this.setSystemId(HIBERNATE_SYSTEMID_30);
            this.setDtdURL(this.getClass().getResource(DTD_FILE_NAME_30));
        }
        this.startProcess();
    }

    public void validateOptions() throws XDocletException {
        super.validateOptions();
        if (null == this.dataSource && (null == this.driver || null == this.jdbcUrl || null == this.userName || null == this.password)) {
            throw new XDocletException(Translator.getString(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateCfgSubTask.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages, "DATA_CONNECTION_REQUIRED"));
        }
        if (this.jndiProperties.size() > 0 && null == this.jndiName) {
            throw new XDocletException(Translator.getString(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateCfgSubTask.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages, "JNDI_NAME_FOR_PROPS_REQUIRED"));
        }
        if (this.getDialect() == null) {
            throw new XDocletException(Translator.getString(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateCfgSubTask.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages, "SQL_DIALECT_REQUIRED"));
        }
    }

    public void addConfiguredJndiProperty(Parameter jndiProperty) {
        System.out.println("addConfiguredJndiProperty(): name=" + jndiProperty.getName() + ", " + jndiProperty.getValue());
        this.jndiProperties.add(jndiProperty);
    }

    public void addOtherProperty(Parameter otherProperty) {
        System.out.println("addOtherProperty(): name=" + otherProperty.getName() + ", " + otherProperty.getValue());
        this.otherProperties.add(otherProperty);
    }

    public void addOtherMapping(Parameter otherMapping) {
        System.out.println("addOtherMapping(): name=" + otherMapping.getName() + ", " + otherMapping.getValue());
        this.otherMappings.add(otherMapping);
    }

    protected void engineStarted() throws XDocletException {
        System.out.println(Translator.getString(class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages == null ? (class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages = HibernateCfgSubTask.class$("xdoclet.modules.hibernate.XDocletModulesHibernateMessages")) : class$xdoclet$modules$hibernate$XDocletModulesHibernateMessages, "GENERATING_HIBERNATE_CFG_XML", new String[]{this.getDestinationFile()}));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class HibernateCFGVersion
    extends EnumeratedAttribute {
        public static final String HIBERNATE_2_0 = "2.0";
        public static final String HIBERNATE_3_0 = "3.0";

        public String[] getValues() {
            return new String[]{HIBERNATE_2_0, HIBERNATE_3_0};
        }
    }
}

