/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.utils.TextUtils;
import org.exoplatform.services.log.ExoLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient {
    private static Log LOG = ExoLogger.getLogger(HttpClient.class);
    public static final String CLIENT_DESCRIPTION = "Exo-Http Client v.1.0.beta";
    public static final String HEADER_SPLITTER = ": ";
    public static final String CLIENT_VERSION = "HTTP/1.1";
    private String server = "";
    private int port = 0;
    private Socket clientSocket = null;
    private PrintStream outPrintStream = null;
    private OutputStream outStream = null;
    private InputStream inputStream = null;
    private String httpCommand = "GET";
    private String httpRequestStr = "";
    private ArrayList<String> requestHeaders = new ArrayList();
    private String httpRequestBodyStr;
    private byte[] httpRequestBodyBytes;
    private InputStream httpRequestBodyStream;
    private String mainHeader = "";
    private ArrayList<String> responseHeaders = new ArrayList();
    private byte[] contentBytes = null;

    public HttpClient(String server, int port) {
        this.server = server;
        this.port = port;
    }

    public void conect() throws Exception {
        for (int i = 0; i < 10; ++i) {
            try {
                this.clientSocket = new Socket(this.server, this.port);
                this.outStream = this.clientSocket.getOutputStream();
                this.outPrintStream = new PrintStream(this.clientSocket.getOutputStream());
                this.inputStream = this.clientSocket.getInputStream();
                return;
            }
            catch (SocketException exc) {
                Thread.sleep(500L);
                continue;
            }
        }
    }

    public void setHttpCommand(String httpCommand) {
        this.httpCommand = httpCommand;
    }

    public void setRequestPath(String httpRequestStr) {
        this.httpRequestStr = httpRequestStr;
    }

    public void setRequestHeader(String headerName, String headerValue) {
        int existedIndex = -1;
        for (int i = 0; i < this.requestHeaders.size(); ++i) {
            String curHeader = this.requestHeaders.get(i);
            String[] curHeaderValues = curHeader.split(HEADER_SPLITTER);
            if (!curHeaderValues[0].toUpperCase().equals(headerName.toUpperCase())) continue;
            existedIndex = i;
            break;
        }
        if (existedIndex >= 0) {
            this.requestHeaders.remove(existedIndex);
        }
        String newHeader = headerName + HEADER_SPLITTER + headerValue;
        this.requestHeaders.add(newHeader);
    }

    public void setRequestBody(String httpRequestBodyStr) {
        this.httpRequestBodyStr = httpRequestBodyStr;
    }

    public void setRequestBody(byte[] httpRequestBodyBytes) {
        this.httpRequestBodyBytes = httpRequestBodyBytes;
    }

    public void setRequestStream(InputStream httpRequestBodyStream) {
        this.httpRequestBodyStream = httpRequestBodyStream;
    }

    public void zeroRequestBody() {
        this.httpRequestBodyStr = null;
    }

    public void sendRequest(String request) {
        this.outPrintStream.print(request);
    }

    public String getMainHeader() {
        return this.mainHeader;
    }

    public int getContentLength() {
        for (int i = 0; i < this.responseHeaders.size(); ++i) {
            String curHeader = this.responseHeaders.get(i);
            if (!curHeader.startsWith("Content-Length")) continue;
            String[] params = curHeader.split(":");
            String lenValue = params[1];
            lenValue = lenValue.trim();
            return new Integer(lenValue);
        }
        return 0;
    }

    public ArrayList<String> getResponseHeadersNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.responseHeaders.size(); ++i) {
            String curHeader = this.responseHeaders.get(i);
            result.add(curHeader.split(":")[0]);
        }
        return result;
    }

    public String getResponseHeader(String headerName) {
        for (int i = 0; i < this.responseHeaders.size(); ++i) {
            String curHeader = this.responseHeaders.get(i);
            String[] splitted = curHeader.split(HEADER_SPLITTER);
            if (!splitted[0].equalsIgnoreCase(headerName)) continue;
            return splitted[1];
        }
        return null;
    }

    public int getReplyCode() {
        int replyCode = 0;
        String[] mPathes = this.mainHeader.split(" ");
        replyCode = new Integer(mPathes[1]);
        return replyCode;
    }

    public String getResponseBody() {
        String contentString = "";
        for (int i = 0; i < this.contentBytes.length; ++i) {
            contentString = contentString + (char)this.contentBytes[i];
        }
        return contentString;
    }

    public byte[] getResponseBytes() {
        return this.contentBytes;
    }

    public InputStream getResponseStream() {
        return new ByteArrayInputStream(this.contentBytes);
    }

    /*
     * Unable to fully structure code
     */
    public int execute() throws IOException {
        escapedHttpPath = TextUtils.Escape(this.httpRequestStr, '%', true);
        httpLine = this.httpCommand + " " + escapedHttpPath + " " + "HTTP/1.1";
        this.outPrintStream.println(httpLine);
        reqContLength = 0L;
        if (this.httpRequestBodyStream == null) {
            if (this.httpRequestBodyStr != null) {
                reqContLength = this.httpRequestBodyStr.length();
            } else if (this.httpRequestBodyBytes != null) {
                reqContLength = this.httpRequestBodyBytes.length;
            }
            this.setRequestHeader("Content-Length", "" + reqContLength);
        }
        this.setRequestHeader("Host", this.server + (this.port == 80 ? "" : ":" + this.port));
        this.setRequestHeader("User-Agent", "Exo-Http Client v.1.0.beta");
        for (i = 0; i < this.requestHeaders.size(); ++i) {
            curHeader = this.requestHeaders.get(i);
            this.outPrintStream.println(curHeader);
        }
        this.outPrintStream.println();
        if (this.httpRequestBodyStream != null) {
            buff = new byte[4096];
            readData = 0L;
            while (true) {
                readed = this.httpRequestBodyStream.read(buff);
                readData += (long)readed;
                if (readed >= 0) {
                    this.outStream.write(buff, 0, readed);
                    continue;
                }
                break;
            }
        } else if (reqContLength != 0L) {
            if (this.httpRequestBodyStr != null) {
                this.outPrintStream.print(this.httpRequestBodyStr);
            } else {
                this.outStream.write(this.httpRequestBodyBytes);
            }
        }
        this.mainHeader = this.readLine();
        while (!(nextHeader = this.readLine()).equals("")) {
            this.responseHeaders.add(nextHeader);
        }
        outStream = new ByteArrayOutputStream();
        transferEncoding = this.getResponseHeader("Transfer-Encoding");
        if ("chunked".equals(transferEncoding)) {
            while ((needsToRead = Integer.parseInt(nextLengthValue = this.readLine(), 16)) != 0) {
                buffer = new byte[needsToRead];
                while (true) {
                    readed = this.inputStream.read(buffer);
                    outStream.write(buffer, 0, readed);
                    if (readed == needsToRead) break;
                    buffer = new byte[needsToRead -= readed];
                }
                this.readLine();
            }
        } else {
            try {
                contentLength = this.getContentLength();
                if (contentLength == 0 || "HEAD".equals(this.httpCommand)) ** GOTO lbl70
                buffer = new byte[16384];
                for (received = 0; received < contentLength; received += readed) {
                    needToRead = buffer.length;
                    if (needToRead > contentLength - received) {
                        needToRead = contentLength - received;
                    }
                    if ((readed = this.inputStream.read(buffer, 0, needToRead)) < 0) break;
                    if (readed == 0) {
                        Thread.sleep(100L);
                    }
                    outStream.write(buffer, 0, readed);
                }
            }
            catch (Exception exc) {
                HttpClient.LOG.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
            }
        }
lbl70:
        // 5 sources

        this.contentBytes = outStream.toByteArray();
        try {
            this.clientSocket.close();
        }
        catch (Exception exc) {
            // empty catch block
        }
        return this.getReplyCode();
    }

    protected String readLine() throws IOException {
        byte[] buffer = new byte[4096];
        int bufPos = 0;
        int prevByte = 0;
        while (true) {
            int received;
            if ((received = this.inputStream.read()) < 0) {
                throw new RuntimeException();
            }
            buffer[bufPos] = (byte)received;
            ++bufPos;
            if (prevByte == 13 && received == 10) {
                String resultLine = "";
                for (int i = 0; i < bufPos - 2; ++i) {
                    resultLine = resultLine + (char)buffer[i];
                }
                return resultLine;
            }
            prevByte = (byte)received;
        }
    }
}

