/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.ooplugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.exoplatform.applications.ooplugin.LocalFileSystem;
import org.exoplatform.frameworks.webdavclient.WebDavContext;
import org.exoplatform.services.log.ExoLogger;

public class WebDavConfig {
    private static final Log log = ExoLogger.getLogger((String)"jcr.ooplugin.AddonHandler");
    public static final String WHOST = "Host";
    public static final String WPORT = "Port";
    public static final String WSERVLET = "Servlet";
    public static final String WREPOSITORY = "Repository";
    public static final String WWORKSPACE = "WorkSpace";
    public static final String WUSER = "User";
    public static final String WPASS = "Pass";
    private String host = "localhost";
    private int port = 8080;
    private String servlet = "/rest/jcr/";
    private String repository = "repository";
    private String workSpace = "production";
    private String user_id = "root";
    private String user_pass = "exo";
    private String configFileName = LocalFileSystem.getDocumentsPath() + File.separatorChar + "exoplugin.config";

    public WebDavConfig() {
        this.loadConfig();
    }

    public WebDavContext getContext() {
        String replaced;
        String path = this.servlet + "/" + this.repository + "/" + this.workSpace;
        while (!(replaced = path.replace("//", "/")).equals(path)) {
            path = replaced;
        }
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return new WebDavContext(this.host, this.port, path, this.user_id, this.user_pass);
    }

    public String getServerPrefix() {
        return "http://" + this.host + ":" + this.port + this.servlet + this.repository + "/" + this.workSpace;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getServlet() {
        return this.servlet;
    }

    public void setServlet(String servlet) {
        this.servlet = servlet;
    }

    public void setRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        String localRepository = this.repository;
        while (localRepository.startsWith("/")) {
            localRepository = localRepository.substring(1);
        }
        while (localRepository.endsWith("/")) {
            localRepository = localRepository.substring(0, localRepository.length() - 1);
        }
        return localRepository;
    }

    public String getWorkSpace() {
        String localWorkspace = this.workSpace;
        while (localWorkspace.startsWith("/")) {
            localWorkspace = localWorkspace.substring(1);
        }
        while (localWorkspace.endsWith("/")) {
            localWorkspace = localWorkspace.substring(0, localWorkspace.length() - 1);
        }
        return localWorkspace;
    }

    public void setWorkSpace(String workSpace) {
        this.workSpace = workSpace;
    }

    public String getUserId() {
        return this.user_id;
    }

    public void setUserId(String user_id) {
        this.user_id = user_id;
    }

    public String getUserPass() {
        return this.user_pass;
    }

    public void setUserPass(String user_pass) {
        this.user_pass = user_pass;
    }

    public void saveConfig() throws Exception {
        String outParams = "Host=" + this.host + "\r\n";
        outParams = outParams + "Port=" + this.port + "\r\n";
        outParams = outParams + "Servlet=" + this.servlet + "\r\n";
        outParams = outParams + "Repository=" + this.repository + "\r\n";
        outParams = outParams + "WorkSpace=" + this.workSpace + "\r\n";
        outParams = outParams + "User=" + this.user_id + "\r\n";
        outParams = outParams + "Pass=" + this.user_pass + "\r\n";
        File outConfigFile = new File(this.configFileName);
        outConfigFile.createNewFile();
        FileOutputStream outStream = new FileOutputStream(outConfigFile);
        outStream.write(outParams.getBytes());
        outStream.close();
    }

    public void loadConfig() {
        try {
            File configFile = new File(this.configFileName);
            if (!configFile.exists()) {
                log.info((Object)"Config file not exist!!!!!! USE DEFAULT !!!");
                return;
            }
            FileInputStream inStream = new FileInputStream(configFile);
            byte[] data = new byte[inStream.available()];
            inStream.read(data);
            String confParams = new String(data);
            String[] params = confParams.split("\r\n");
            HashMap<String, String> hParams = new HashMap<String, String>();
            for (int i = 0; i < params.length; ++i) {
                String[] curParams = params[i].split("=");
                hParams.put(curParams[0], curParams[1]);
            }
            this.host = (String)hParams.get(WHOST);
            this.port = new Integer((String)hParams.get(WPORT));
            this.servlet = (String)hParams.get(WSERVLET);
            this.repository = (String)hParams.get(WREPOSITORY);
            this.workSpace = (String)hParams.get(WWORKSPACE);
            this.user_id = (String)hParams.get(WUSER);
            this.user_pass = (String)hParams.get(WPASS);
        }
        catch (Exception exc) {
            log.info((Object)("Unhandled exception. " + exc.getMessage()), (Throwable)exc);
        }
    }
}

