/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.repoload;

import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.applications.repoload.DataReaderTh;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.CredentialsImpl;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.JCRPath;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionDataManager;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.storage.WorkspaceDataContainerBase;
import org.exoplatform.services.jcr.storage.WorkspaceStorageConnection;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataReader {
    private Log log = ExoLogger.getLogger((String)"repload.DataReader");
    protected String[] args;
    protected HashMap<String, String> mapConfig;
    protected String tree = "10-5-5-5";
    protected String sVdfile = "/image.tif";
    protected String sConf = "/exo-configuration.xml";
    protected String sRoot = "/testroot";
    protected String sWorkspace = "ws";
    protected String sRepository = "db1";
    protected String sReadTree = "false";
    protected String sReadOnly;
    protected SessionImpl session;
    protected SessionDataManager dataManager;
    protected RepositoryImpl repository;
    protected CredentialsImpl credentials;
    protected WorkspaceImpl workspace;
    protected RepositoryService repositoryService;
    protected NodeImpl root;
    protected NodeImpl rootTestNode;
    protected StandaloneContainer container;
    protected WorkspaceStorageConnection connection;
    protected WorkspaceDataContainerBase workspaceDataContainer;
    protected LocationFactory locationFactory;
    protected TransientValueData fileData;
    protected Calendar date;
    protected String sName;
    protected String sFile;
    public int countNodes;
    private int ntFolderCount;
    private int ntFileCount;
    private long end;
    private long start;
    private boolean readProperty;

    public DataReader(String[] args) {
        this.mapConfig = this.parceCommandLine(args);
        this.args = args;
        this.readProperty = Boolean.valueOf(this.mapConfig.get("-readprop"));
        try {
            this.initRepository();
        }
        catch (Exception e) {
            this.log.error((Object)"Error: Can not initialize repository", (Throwable)e);
        }
        try {
            this.readDataAPI();
        }
        catch (Exception e) {
            this.log.error((Object)"Read error", (Throwable)e);
        }
    }

    public DataReader(String[] args, String threadName) {
        this.mapConfig = this.parceCommandLine(args);
        this.args = args;
        try {
            this.initRepository();
        }
        catch (Exception e) {
            this.log.error((Object)"Error: Can not initialize repository", (Throwable)e);
        }
        int iThreads = Integer.valueOf(this.mapConfig.get("-threads"));
        int iteration = Integer.valueOf(this.mapConfig.get("-iteration"));
        DataReaderTh[] readers = new DataReaderTh[iThreads];
        if (iThreads == 1) {
            try {
                readers[0] = new DataReaderTh((Node)this.rootTestNode, threadName + 1, this.mapConfig);
                readers[0].startRead();
            }
            catch (Exception e) {
                this.log.error((Object)"Error: read data", (Throwable)e);
            }
        } else {
            try {
                if (this.mapConfig.get("-concurrent").equals("true")) {
                    for (int i = 0; i < readers.length; ++i) {
                        readers[i] = new DataReaderTh((Node)this.rootTestNode, threadName + i, this.mapConfig);
                    }
                } else {
                    NodeIterator ni = this.rootTestNode.getNodes();
                    for (int i = 0; i < readers.length; ++i) {
                        if (ni.hasNext()) {
                            readers[i] = new DataReaderTh(ni.nextNode(), threadName + i, this.mapConfig);
                            continue;
                        }
                        ni = this.rootTestNode.getNodes();
                    }
                }
                this.start = System.currentTimeMillis();
                for (int i = 0; i < readers.length; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    readers[i].startRead();
                }
            }
            catch (RepositoryException e) {
                this.log.error((Object)"Error: read data", (Throwable)e);
            }
        }
        try {
            boolean countFinished = false;
            boolean bFinished = false;
            block13: while (!bFinished) {
                Thread.sleep(10L);
                for (int j = 0; j < readers.length; ++j) {
                    if (readers[j].getTimeAdding() == 0L) {
                        bFinished = false;
                        continue block13;
                    }
                    bFinished = true;
                }
            }
            this.end = System.currentTimeMillis();
            for (int i = 0; i < readers.length; ++i) {
                this.log.info((Object)(readers[i].getThreadName() + ": " + "The time of reading of " + readers[i].getNTCount() + " nodes: " + (double)readers[i].getTimeAdding() / 1000.0 + " sec"));
            }
            this.log.info((Object)("Total reading time " + (double)(this.end - this.start) / 1000.0 + " sec"));
        }
        catch (Throwable e) {
            this.log.error((Object)"Error read data", e);
        }
    }

    public void initRepository() throws Exception {
        this.sConf = this.mapConfig.get("-conf");
        this.sRepository = this.mapConfig.get("-repo");
        this.sWorkspace = this.mapConfig.get("-ws");
        this.sRoot = this.mapConfig.get("-root");
        this.sVdfile = this.mapConfig.get("-vdfile");
        this.sReadTree = this.mapConfig.get("-readtree");
        this.sReadOnly = this.mapConfig.get("-read");
        try {
            StandaloneContainer.addConfigurationPath((String)this.sConf);
            this.container = StandaloneContainer.getInstance();
            if (System.getProperty("java.security.auth.login.config") == null) {
                System.setProperty("java.security.auth.login.config", Thread.currentThread().getContextClassLoader().getResource("login.conf").toString());
            }
            this.credentials = new CredentialsImpl("admin", "admin".toCharArray());
            this.repositoryService = (RepositoryService)this.container.getComponentInstanceOfType(RepositoryService.class);
            this.repository = (RepositoryImpl)this.repositoryService.getRepository(this.sRepository);
            if (this.repository != null) {
                this.log.info((Object)"--->>> perository");
            }
            this.session = (SessionImpl)this.repository.login((Credentials)this.credentials, this.sWorkspace);
            if (this.session != null) {
                this.log.info((Object)"--->>> session");
            }
            this.locationFactory = this.session.getLocationFactory();
            if (this.locationFactory != null) {
                this.log.info((Object)"--->>> locationFactory");
            }
            this.dataManager = this.session.getTransientNodesManager();
            if (this.dataManager != null) {
                this.log.info((Object)"--->>> dataManager");
            }
            this.workspaceDataContainer = (WorkspaceDataContainerBase)this.session.getContainer().getComponentInstanceOfType(WorkspaceDataContainerBase.class);
            this.connection = this.workspaceDataContainer.openConnection();
            if (this.connection != null) {
                this.log.info((Object)"--->>> connection");
            }
            this.workspace = this.session.getWorkspace();
            if (this.workspace != null) {
                this.log.info((Object)"--->>> workspace");
            }
            this.root = (NodeImpl)this.session.getRootNode();
            if (this.root != null) {
                this.log.info((Object)"--->>> root");
            }
        }
        catch (Exception e) {
            this.log.error((Object)"Can not initialize repository", (Throwable)e);
        }
        try {
            if (this.sRoot.startsWith("/")) {
                this.rootTestNode = (NodeImpl)this.session.getItem(this.sRoot);
                this.log.info((Object)("--->>> Node " + this.sRoot + " exist"));
            } else {
                new Exception("Test root is not absolute path: " + this.sRoot);
            }
        }
        catch (PathNotFoundException e) {
            this.log.error((Object)("Testroot is not found : " + this.sRoot), (Throwable)e);
        }
        DCPropertyQName.dcElementSet = this.locationFactory.parseJCRName("dc:elementSet").getInternalName();
        DCPropertyQName.dcTitle = this.locationFactory.parseJCRName("dc:title").getInternalName();
        DCPropertyQName.dcCreator = this.locationFactory.parseJCRName("dc:creator").getInternalName();
        DCPropertyQName.dcSubject = this.locationFactory.parseJCRName("dc:subject").getInternalName();
        DCPropertyQName.dcDescription = this.locationFactory.parseJCRName("dc:description").getInternalName();
        DCPropertyQName.dcPublisher = this.locationFactory.parseJCRName("dc:publisher").getInternalName();
    }

    @Deprecated
    public void readData() {
        int[] tree = this.getTree(this.mapConfig.get("-tree"));
        for (int i = 1; i <= tree[0]; ++i) {
            try {
                NodeImpl n_1 = this.getNode(this.rootTestNode, this.sName + i);
                for (int j = 1; j <= tree[1]; ++j) {
                    NodeImpl n_2 = this.getNode(n_1, this.sName + j);
                    for (int k = 1; k <= tree[2]; ++k) {
                        NodeImpl n_3 = this.getNode(n_2, this.sName + k);
                        for (int s = 1; s <= tree[3]; ++s) {
                            NodeImpl n_4 = this.getNode(n_3, this.sFile + s);
                            NodeImpl sourceNode = this.getNode(n_4, "jcr:content");
                            InputStream fis = this.getProperty(sourceNode, "jcr:data").getStream();
                            Value[] t = this.getProperty(n_4, "dc:title").getValues();
                            String tit = t[0].getString();
                            Value[] d = this.getProperty(n_4, "dc:description").getValues();
                            String des = d[0].getString();
                            this.log.info((Object)("--->>> Node " + this.mapConfig.get("-root") + "/" + this.sName + i + "/" + this.sName + j + "/" + this.sName + k + "/" + this.sFile + s + " exist : " + fis.available() + " b   |   dc:title --> " + tit + "   |   dc:description --> " + des));
                        }
                    }
                }
                continue;
            }
            catch (Exception e) {
                this.log.error((Object)">>>>>>>>>>>---------- Read data Exception ----------<<<<<<<<<<<<", (Throwable)e);
            }
        }
    }

    public void readDataAPI() throws RepositoryException {
        NodeIterator ni = this.rootTestNode.getNodes();
        this.log.info((Object)"Reader root ls: ");
        while (ni.hasNext()) {
            this.readChilds(ni.nextNode());
        }
    }

    public void readChilds(Node parent) throws RepositoryException {
        String primaryType = parent.getPrimaryNodeType().getName();
        if (primaryType.equals("nt:folder")) {
            ++this.ntFolderCount;
            this.log.info((Object)("\t" + this.ntFolderCount + " nt:folder has been raed"));
            NodeIterator ni = parent.getNodes();
            if (ni.hasNext()) {
                while (ni.hasNext()) {
                    Node n1 = ni.nextNode();
                    this.readChilds(n1);
                }
            }
        } else if (primaryType.equals("nt:file")) {
            ++this.ntFileCount;
            this.log.info((Object)("\t" + this.ntFileCount + " nt:file has been raed"));
            if (this.readProperty) {
                this.showDCProperty(parent);
                NodeIterator ni = parent.getNodes();
                if (ni.hasNext()) {
                    while (ni.hasNext()) {
                        Node n1 = ni.nextNode();
                        this.readChilds(n1);
                    }
                } else {
                    this.showProperty(parent);
                }
            }
        } else if (this.readProperty) {
            this.showProperty(parent);
        }
    }

    public void showDCProperty(Node parent) throws RepositoryException {
        PropertyIterator pi = parent.getProperties();
        String sMix = parent.getPrimaryNodeType().getName();
        if (sMix.equals("nt:file")) {
            for (NodeType mt : parent.getMixinNodeTypes()) {
                sMix = sMix + " " + mt.getName();
            }
            this.log.info((Object)(sMix + " " + parent.getPath()));
            if (this.mapConfig.get("-readdc").equals("true")) {
                String[] dcprop = new String[]{"dc:title", "dc:creator", "dc:subject", "dc:description", "dc:publisher"};
                for (int i = 0; i < dcprop.length; ++i) {
                    Property propdc = parent.getProperty(dcprop[i]);
                    String s = propdc.getValues()[0].getString();
                    this.log.info((Object)("\t\t" + propdc.getName() + " " + PropertyType.nameFromValue((int)propdc.getType()) + " " + s));
                }
            }
        }
    }

    public void showProperty(Node parent) throws RepositoryException {
        PropertyIterator pi = parent.getProperties();
        String sMix = parent.getPrimaryNodeType().getName();
        if (sMix.equals("nt:resource")) {
            for (NodeType mt : parent.getMixinNodeTypes()) {
                sMix = sMix + " " + mt.getName();
            }
            this.log.info((Object)(sMix + " " + parent.getPath()));
            while (pi.hasNext()) {
                Property prop = pi.nextProperty();
                if (prop.getType() == 2) {
                    this.log.info((Object)("\t\t" + prop.getName() + " " + PropertyType.nameFromValue((int)prop.getType())));
                    continue;
                }
                String s = prop.getString();
                if (s.length() > 64) {
                    s = s.substring(0, 64);
                }
                this.log.info((Object)("\t\t" + prop.getName() + " " + PropertyType.nameFromValue((int)prop.getType()) + " " + s));
            }
        }
    }

    public NodeImpl getNode(NodeImpl parentNode, String relPath) throws PathNotFoundException, RepositoryException {
        JCRPath itemPath = this.session.getLocationFactory().createJCRPath(parentNode.getLocation(), relPath);
        NodeImpl node = (NodeImpl)this.dataManager.getItem(itemPath.getInternalPath(), true);
        if (node == null) {
            throw new PathNotFoundException("Node not found " + itemPath.getAsString(true));
        }
        return node;
    }

    public Property getProperty(NodeImpl node, String relPath) throws PathNotFoundException, RepositoryException {
        JCRPath itemPath = this.locationFactory.createJCRPath(node.getLocation(), relPath);
        ItemImpl prop = this.dataManager.getItem(itemPath.getInternalPath(), true);
        if (prop == null || prop.isNode()) {
            throw new PathNotFoundException("Property not found " + itemPath.getAsString(false));
        }
        return (Property)prop;
    }

    protected int[] getTree(String sTree) {
        String[] masTree = sTree.split("-");
        int[] iTree = new int[4];
        for (int i = 0; i < 4; ++i) {
            iTree[i] = Integer.valueOf(masTree[i]);
        }
        return iTree;
    }

    private HashMap<String, String> parceCommandLine(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("-conf", "");
        map.put("-root", "");
        map.put("-tree", "");
        map.put("-vdfile", "");
        map.put("-repo", "");
        map.put("-ws", "");
        map.put("-readtree", "");
        map.put("-read", "");
        map.put("-readdc", "false");
        map.put("-threads", "1");
        map.put("-iteration", "1");
        map.put("-concurrent", "false");
        map.put("-readprop", "false");
        for (int i = 0; i < args.length; ++i) {
            String[] params = args[i].split("=");
            if (!map.containsKey(params[0])) {
                this.log.info((Object)("Error: " + params[0] + " unknown parameter"));
            }
            map.remove(params[0]);
            if (params.length > 1) {
                map.put(params[0], params[1]);
            } else if (params[0].equals("-readdc") || params[0].equals("-concurrent") || params[0].equals("-readprop")) {
                map.put(params[0], "true");
                this.log.info((Object)(params[0] + " = true"));
            } else {
                map.put(params[0], "");
            }
            if (params.length <= 1) continue;
            this.log.info((Object)(params[0] + " = " + params[1]));
        }
        return map;
    }

    protected static class DCPropertyQName {
        public static InternalQName dcElementSet;
        public static InternalQName dcTitle;
        public static InternalQName dcCreator;
        public static InternalQName dcSubject;
        public static InternalQName dcDescription;
        public static InternalQName dcPublisher;

        protected DCPropertyQName() {
        }
    }
}

