/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.applications.repoload;

import org.exoplatform.applications.repoload.DataReader;
import org.exoplatform.applications.repoload.DataUploader;
import org.exoplatform.applications.repoload.DataUploaderAPI;
import org.exoplatform.applications.scale.Scale;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RepositoryDataUploader {
    protected static Log log = ExoLogger.getLogger((String)"repload.RepositoryDataUploader");

    public static void main(String[] args) {
        block13: {
            if (RepositoryDataUploader.isRead(args)) {
                if (RepositoryDataUploader.isThreads(args)) {
                    DataReader dataReader = new DataReader(args, "ThReader");
                } else {
                    DataReader dataReader = new DataReader(args);
                }
            } else if (RepositoryDataUploader.isScaleTest(args)) {
                Scale.main(args);
            } else {
                try {
                    if (RepositoryDataUploader.isAPIRead(args)) {
                        DataUploaderAPI dataUploaderApi = new DataUploaderAPI(args);
                        dataUploaderApi.initRepository();
                        long start = System.currentTimeMillis();
                        try {
                            dataUploaderApi.uploadDataAPI();
                        }
                        catch (Exception e) {
                            log.info((Object)"Error upload data", (Throwable)e);
                        }
                        long end = System.currentTimeMillis();
                        dataUploaderApi.readData();
                        log.info((Object)("The time of the adding of " + dataUploaderApi.countNodes + " nodes: " + (double)(end - start) / 1000.0 + " sec"));
                        break block13;
                    }
                    DataUploader dataUploader = new DataUploader(args);
                    dataUploader.initRepository();
                    long start = System.currentTimeMillis();
                    try {
                        dataUploader.uploadData();
                    }
                    catch (Exception e) {
                        log.info((Object)"Error upload data", (Throwable)e);
                    }
                    long end = System.currentTimeMillis();
                    dataUploader.readData();
                    log.info((Object)("The time of the adding of " + dataUploader.countNodes + " nodes: " + (double)(end - start) / 1000.0 + " sec"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info((Object)"Error upload data", (Throwable)e);
                }
            }
        }
        System.exit(0);
    }

    private static boolean isRead(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-read")) continue;
            return true;
        }
        return false;
    }

    private static boolean isWrite(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-write")) continue;
            return true;
        }
        return false;
    }

    private static boolean isThreads(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String[] pair = args[i].split("=");
            if (!pair[0].equals("-threads")) continue;
            return true;
        }
        return false;
    }

    private static boolean isAPIRead(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String[] pair = args[i].split("=");
            if (!pair[0].equals("-api")) continue;
            return true;
        }
        return false;
    }

    private static boolean isScaleTest(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-scale")) continue;
            return true;
        }
        return false;
    }
}

