/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.jcr.RepositoryException;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.dataflow.ItemState;
import org.exoplatform.services.jcr.dataflow.PlainChangesLogImpl;
import org.exoplatform.services.jcr.datamodel.Identifier;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.ValueData;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.PropertyImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.dataflow.ItemDataRemoveVisitor;
import org.exoplatform.services.jcr.impl.dataflow.TransientPropertyData;
import org.exoplatform.services.jcr.impl.dataflow.TransientValueData;
import org.exoplatform.services.jcr.impl.xml.ItemDataKeeperAdapter;
import org.exoplatform.services.log.ExoLogger;

public class VersionHistoryImporter {
    private static final Log LOG = ExoLogger.getLogger(VersionHistoryImporter.class);
    private final NodeImpl versionableNode;
    private final InputStream versionHistoryStream;
    private final SessionImpl userSession;
    private final NodeTypeManagerImpl nodeTypeDataManager;
    private final ItemDataKeeperAdapter dataKeeper;
    private final String baseVersionUuid;
    private final String[] predecessors;
    private final String versionHistory;
    private String uuid;
    private String path;

    public VersionHistoryImporter(NodeImpl versionableNode, InputStream versionHistoryStream, String baseVersionUuid, String[] predecessors, String versionHistory) throws RepositoryException {
        this.versionableNode = versionableNode;
        this.versionHistoryStream = versionHistoryStream;
        this.baseVersionUuid = baseVersionUuid;
        this.predecessors = predecessors;
        this.versionHistory = versionHistory;
        this.userSession = versionableNode.getSession();
        this.nodeTypeDataManager = this.userSession.getWorkspace().getNodeTypeManager();
        this.dataKeeper = new ItemDataKeeperAdapter(this.userSession.getTransientNodesManager());
    }

    public void doImport() throws RepositoryException, IOException {
        try {
            this.uuid = this.versionableNode.getUUID();
            this.path = this.versionableNode.getVersionHistory().getParent().getPath();
            LOG.info((Object)("Started: Import version history for node wiht path=" + this.path + " and UUID=" + this.uuid));
            String path = this.versionableNode.getVersionHistory().getParent().getPath();
            NodeData versionable = (NodeData)this.versionableNode.getData();
            TransientPropertyData vh = TransientPropertyData.createPropertyData(versionable, Constants.JCR_VERSIONHISTORY, 9, false);
            vh.setValue(new TransientValueData(new Identifier(this.versionHistory)));
            TransientPropertyData bv = TransientPropertyData.createPropertyData(versionable, Constants.JCR_BASEVERSION, 9, false);
            bv.setValue(new TransientValueData(new Identifier(this.baseVersionUuid)));
            TransientPropertyData pd = TransientPropertyData.createPropertyData(versionable, Constants.JCR_PREDECESSORS, 9, true);
            ArrayList<ValueData> values = new ArrayList<ValueData>();
            for (int i = 0; i < this.predecessors.length; ++i) {
                values.add(new TransientValueData(new Identifier(this.predecessors[i])));
            }
            pd.setValues(values);
            PlainChangesLogImpl changesLog = new PlainChangesLogImpl();
            RemoveVisitor rv = new RemoveVisitor();
            rv.visit((NodeData)((NodeImpl)this.versionableNode.getVersionHistory()).getData());
            changesLog.addAll(rv.getRemovedStates());
            changesLog.add(ItemState.createAddedState(vh));
            changesLog.add(ItemState.createAddedState(bv));
            changesLog.add(ItemState.createAddedState(pd));
            PlainChangesLogImpl changesLogDeltete = new PlainChangesLogImpl();
            changesLogDeltete.add(ItemState.createDeletedState(((PropertyImpl)this.versionableNode.getProperty("jcr:versionHistory")).getData()));
            changesLogDeltete.add(ItemState.createDeletedState(((PropertyImpl)this.versionableNode.getProperty("jcr:baseVersion")).getData()));
            changesLogDeltete.add(ItemState.createDeletedState(((PropertyImpl)this.versionableNode.getProperty("jcr:predecessors")).getData()));
            this.dataKeeper.save(changesLogDeltete);
            this.dataKeeper.save(changesLog);
            this.userSession.save();
            this.userSession.getWorkspace().importXML(path, this.versionHistoryStream, 0);
            this.userSession.save();
            LOG.info((Object)("Completed: Import version history for node wiht path=" + path + " and UUID=" + this.uuid));
        }
        catch (RepositoryException exception) {
            LOG.error((Object)("Failed: Import version history for node wiht path=" + this.path + " and UUID=" + this.uuid), (Throwable)exception);
            throw new RepositoryException((Throwable)exception);
        }
        catch (IOException exception) {
            LOG.error((Object)("Failed: Import version history for node wiht path=" + this.path + " and UUID=" + this.uuid), (Throwable)exception);
            IOException newException = new IOException();
            newException.initCause(exception);
            throw newException;
        }
    }

    protected class RemoveVisitor
    extends ItemDataRemoveVisitor {
        RemoveVisitor() throws RepositoryException {
            super(VersionHistoryImporter.this.userSession.getTransientNodesManager(), null, VersionHistoryImporter.this.nodeTypeDataManager, VersionHistoryImporter.this.userSession.getAccessManager(), VersionHistoryImporter.this.userSession.getUserState());
        }

        protected void validateReferential(NodeData node) throws RepositoryException {
        }
    }
}

