/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.logging.Log;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeType;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeManagerListener;
import org.exoplatform.services.log.ExoLogger;

public class PropertyTypeRegistry
implements NodeTypeManagerListener {
    private static final Log log = ExoLogger.getLogger(PropertyTypeRegistry.class);
    private static final TypeMapping[] EMPTY = new TypeMapping[0];
    private final NodeTypeManagerImpl registry;
    private final Map<InternalQName, TypeMapping[]> typeMapping = new HashMap<InternalQName, TypeMapping[]>();

    public PropertyTypeRegistry(NodeTypeManagerImpl reg) {
        this.registry = reg;
        this.fillCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeMapping[] getPropertyTypes(InternalQName propName) {
        Map<InternalQName, TypeMapping[]> map = this.typeMapping;
        synchronized (map) {
            TypeMapping[] types = this.typeMapping.get((Object)propName);
            if (types != null) {
                return types;
            }
            return EMPTY;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeRegistered(InternalQName ntName) {
        try {
            ExtendedNodeType def = this.registry.getNodeType(ntName);
            PropertyDefinition[] propDefs = def.getPropertyDefinitions();
            Map<InternalQName, TypeMapping[]> map = this.typeMapping;
            synchronized (map) {
                for (int i = 0; i < propDefs.length; ++i) {
                    int type = propDefs[i].getRequiredType();
                    if (((ItemDefinitionImpl)propDefs[i]).isResidualSet() || type == 0) continue;
                    InternalQName name = ((ItemDefinitionImpl)propDefs[i]).getQName();
                    TypeMapping[] types = this.typeMapping.get((Object)name);
                    if (types == null) {
                        types = new TypeMapping[1];
                    } else {
                        TypeMapping[] tmp = new TypeMapping[types.length + 1];
                        System.arraycopy(types, 0, tmp, 0, types.length);
                        types = tmp;
                    }
                    types[types.length - 1] = new TypeMapping(ntName, type, propDefs[i].isMultiple());
                    this.typeMapping.put(name, types);
                }
            }
        }
        catch (RepositoryException e) {
            log.error((Object)("Unable to get newly registered node type definition for name: " + (Object)((Object)ntName)));
        }
    }

    public void nodeTypeReRegistered(InternalQName ntName) {
        this.nodeTypeUnregistered(ntName);
        this.nodeTypeRegistered(ntName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeTypeUnregistered(InternalQName ntName) {
        Map<InternalQName, TypeMapping[]> map = this.typeMapping;
        synchronized (map) {
            HashMap<InternalQName, TypeMapping[]> modified = new HashMap<InternalQName, TypeMapping[]>();
            Iterator<InternalQName> it = this.typeMapping.keySet().iterator();
            while (it.hasNext()) {
                InternalQName propName = it.next();
                TypeMapping[] mapping = this.typeMapping.get((Object)propName);
                ArrayList<TypeMapping> remove = null;
                for (int i = 0; i < mapping.length; ++i) {
                    if (!mapping[i].ntName.equals((Object)ntName)) continue;
                    if (remove == null) {
                        remove = new ArrayList<TypeMapping>(mapping.length);
                    }
                    remove.add(mapping[i]);
                }
                if (remove == null) continue;
                it.remove();
                if (mapping.length == remove.size()) continue;
                ArrayList<TypeMapping> remaining = new ArrayList<TypeMapping>(Arrays.asList(mapping));
                remaining.removeAll(remove);
                modified.put(propName, remaining.toArray(new TypeMapping[remaining.size()]));
            }
            this.typeMapping.putAll(modified);
        }
    }

    private void fillCache() {
        NodeTypeIterator ntTypes = this.registry.getAllNodeTypes();
        while (ntTypes.hasNext()) {
            this.nodeTypeRegistered(((NodeTypeImpl)ntTypes.nextNodeType()).getQName());
        }
    }

    public static class TypeMapping {
        public final int type;
        final InternalQName ntName;
        public final boolean isMultiValued;

        private TypeMapping(InternalQName ntName, int type, boolean isMultiValued) {
            this.type = type;
            this.ntName = ntName;
            this.isMultiValued = isMultiValued;
        }
    }
}

