/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.datamodel.QPath;
import org.exoplatform.services.jcr.datamodel.QPathEntry;
import org.exoplatform.services.jcr.impl.core.query.QueryNode;
import org.exoplatform.services.jcr.impl.core.query.QueryNodeVisitor;

public class TextsearchQueryNode
extends QueryNode {
    private final String query;
    private QPath relPath;
    private boolean propertyRef;

    protected TextsearchQueryNode(QueryNode parent, String query) {
        super(parent);
        this.query = query;
        this.relPath = null;
        this.propertyRef = false;
    }

    public Object accept(QueryNodeVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public int getType() {
        return 4;
    }

    public String getQuery() {
        return this.query;
    }

    @Deprecated
    public InternalQName getPropertyName() {
        return this.relPath == null ? null : this.relPath.getName();
    }

    @Deprecated
    public void setPropertyName(InternalQName property) {
        this.relPath = QPath.makeChildPath(this.relPath, property);
        this.propertyRef = true;
    }

    public QPath getRelativePath() {
        return this.relPath;
    }

    public void setRelativePath(QPath relPath) {
        if (relPath != null && relPath.isAbsolute()) {
            throw new IllegalArgumentException("relPath must be relative");
        }
        this.relPath = relPath;
        if (relPath == null) {
            this.propertyRef = false;
        }
    }

    public void addPathElement(QPathEntry element) {
        this.relPath = this.relPath == null ? new QPath(new QPathEntry[]{element}) : QPath.makeChildPath(this.relPath, element, element.getIndex());
    }

    public boolean getReferencesProperty() {
        return this.propertyRef;
    }

    public void setReferencesProperty(boolean b) {
        this.propertyRef = b;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TextsearchQueryNode) {
            TextsearchQueryNode other = (TextsearchQueryNode)obj;
            return (this.query == null ? other.query == null : this.query.equals(other.query)) && (this.relPath == null ? other.relPath == null : this.relPath.equals(other.relPath) && this.propertyRef == other.propertyRef);
        }
        return false;
    }

    public boolean needsSystemTree() {
        return false;
    }
}

