/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Hits;
import org.exoplatform.services.jcr.impl.core.query.lucene.PerQueryCache;

public class QueryHits {
    private final Hits hits;
    private final IndexReader reader;
    private final int length;

    public QueryHits(Hits hits, IndexReader reader) {
        this.hits = hits;
        this.reader = reader;
        this.length = hits.length();
    }

    public final void close() throws IOException {
        this.reader.close();
        PerQueryCache.getInstance().dispose();
    }

    public final int length() {
        return this.length;
    }

    public final Document doc(int n) throws IOException {
        return this.hits.doc(n);
    }

    public String getFieldContent(int n, final String field) throws IOException {
        FieldSelector fieldSelector;
        int id = this.hits.id(n);
        Document doc = this.reader.document(id, fieldSelector = new FieldSelector(){

            public FieldSelectorResult accept(String fieldName) {
                if (fieldName.equals(field)) {
                    return FieldSelectorResult.LOAD_AND_BREAK;
                }
                return FieldSelectorResult.NO_LOAD;
            }
        });
        if (doc == null) {
            throw new IOException("Document with id " + id + " not found");
        }
        return doc.get(field);
    }

    public final float score(int n) throws IOException {
        return this.hits.score(n);
    }

    public final int id(int n) throws IOException {
        return this.hits.id(n);
    }
}

