/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.dataflow;

import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.dataflow.ItemDataVisitor;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;

public abstract class ItemDataTraversingVisitor
implements ItemDataVisitor {
    protected final int maxLevel;
    public static final int INFINITE_DEPTH = -1;
    protected int currentLevel = 0;
    protected final ItemDataConsumer dataManager;

    public ItemDataTraversingVisitor(ItemDataConsumer dataManager, int maxLevel) {
        this.maxLevel = maxLevel;
        this.dataManager = dataManager;
    }

    public ItemDataTraversingVisitor(ItemDataConsumer dataManager) {
        this.maxLevel = -1;
        this.dataManager = dataManager;
    }

    public void visit(PropertyData property) throws RepositoryException {
        this.entering(property, this.currentLevel);
        this.leaving(property, this.currentLevel);
    }

    public void visit(NodeData node) throws RepositoryException {
        try {
            this.entering(node, this.currentLevel);
            if (this.maxLevel == -1 || this.currentLevel < this.maxLevel) {
                ++this.currentLevel;
                for (PropertyData propertyData : this.dataManager.getChildPropertiesData(node)) {
                    propertyData.accept(this);
                }
                for (NodeData nodeData : this.dataManager.getChildNodesData(node)) {
                    nodeData.accept(this);
                }
                --this.currentLevel;
            }
            this.leaving(node, this.currentLevel);
        }
        catch (RepositoryException re) {
            this.currentLevel = 0;
            throw re;
        }
    }

    public ItemDataConsumer getDataManager() {
        return this.dataManager;
    }

    protected abstract void entering(PropertyData var1, int var2) throws RepositoryException;

    protected abstract void entering(NodeData var1, int var2) throws RepositoryException;

    protected abstract void leaving(PropertyData var1, int var2) throws RepositoryException;

    protected abstract void leaving(NodeData var1, int var2) throws RepositoryException;
}

